// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: authentication/v1alpha1/policy.proto

// This package defines user-facing authentication policy.

package v1alpha1

import (
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Associates authentication with request principal.
type PrincipalBinding int32

const (
	// Principal will be set to the identity from peer authentication.
	PrincipalBinding_USE_PEER PrincipalBinding = 0
	// Principal will be set to the identity from origin authentication.
	PrincipalBinding_USE_ORIGIN PrincipalBinding = 1
)

var PrincipalBinding_name = map[int32]string{
	0: "USE_PEER",
	1: "USE_ORIGIN",
}

var PrincipalBinding_value = map[string]int32{
	"USE_PEER":   0,
	"USE_ORIGIN": 1,
}

func (x PrincipalBinding) String() string {
	return proto.EnumName(PrincipalBinding_name, int32(x))
}

func (PrincipalBinding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{0}
}

// Defines the acceptable connection TLS mode.
type MutualTls_Mode int32

const (
	// Client cert must be presented, connection is in TLS.
	MutualTls_STRICT MutualTls_Mode = 0
	// Connection can be either plaintext or TLS, and client cert can be omitted.
	MutualTls_PERMISSIVE MutualTls_Mode = 1
)

var MutualTls_Mode_name = map[int32]string{
	0: "STRICT",
	1: "PERMISSIVE",
}

var MutualTls_Mode_value = map[string]int32{
	"STRICT":     0,
	"PERMISSIVE": 1,
}

func (x MutualTls_Mode) String() string {
	return proto.EnumName(MutualTls_Mode_name, int32(x))
}

func (MutualTls_Mode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{1, 0}
}

// Describes how to match a given string. Match is case-sensitive.
type StringMatch struct {
	// Types that are valid to be assigned to MatchType:
	//	*StringMatch_Exact
	//	*StringMatch_Prefix
	//	*StringMatch_Suffix
	//	*StringMatch_Regex
	MatchType            isStringMatch_MatchType `protobuf_oneof:"match_type"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StringMatch) Reset()         { *m = StringMatch{} }
func (m *StringMatch) String() string { return proto.CompactTextString(m) }
func (*StringMatch) ProtoMessage()    {}
func (*StringMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{0}
}
func (m *StringMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *StringMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_StringMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *StringMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StringMatch.Merge(m, src)
}
func (m *StringMatch) XXX_Size() int {
	return m.Size()
}
func (m *StringMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_StringMatch.DiscardUnknown(m)
}

var xxx_messageInfo_StringMatch proto.InternalMessageInfo

type isStringMatch_MatchType interface {
	isStringMatch_MatchType()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StringMatch_Exact struct {
	Exact string `protobuf:"bytes,1,opt,name=exact,proto3,oneof"`
}
type StringMatch_Prefix struct {
	Prefix string `protobuf:"bytes,2,opt,name=prefix,proto3,oneof"`
}
type StringMatch_Suffix struct {
	Suffix string `protobuf:"bytes,3,opt,name=suffix,proto3,oneof"`
}
type StringMatch_Regex struct {
	Regex string `protobuf:"bytes,4,opt,name=regex,proto3,oneof"`
}

func (*StringMatch_Exact) isStringMatch_MatchType()  {}
func (*StringMatch_Prefix) isStringMatch_MatchType() {}
func (*StringMatch_Suffix) isStringMatch_MatchType() {}
func (*StringMatch_Regex) isStringMatch_MatchType()  {}

func (m *StringMatch) GetMatchType() isStringMatch_MatchType {
	if m != nil {
		return m.MatchType
	}
	return nil
}

func (m *StringMatch) GetExact() string {
	if x, ok := m.GetMatchType().(*StringMatch_Exact); ok {
		return x.Exact
	}
	return ""
}

func (m *StringMatch) GetPrefix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Prefix); ok {
		return x.Prefix
	}
	return ""
}

func (m *StringMatch) GetSuffix() string {
	if x, ok := m.GetMatchType().(*StringMatch_Suffix); ok {
		return x.Suffix
	}
	return ""
}

func (m *StringMatch) GetRegex() string {
	if x, ok := m.GetMatchType().(*StringMatch_Regex); ok {
		return x.Regex
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StringMatch) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StringMatch_OneofMarshaler, _StringMatch_OneofUnmarshaler, _StringMatch_OneofSizer, []interface{}{
		(*StringMatch_Exact)(nil),
		(*StringMatch_Prefix)(nil),
		(*StringMatch_Suffix)(nil),
		(*StringMatch_Regex)(nil),
	}
}

func _StringMatch_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Exact)
	case *StringMatch_Prefix:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Prefix)
	case *StringMatch_Suffix:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Suffix)
	case *StringMatch_Regex:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Regex)
	case nil:
	default:
		return fmt.Errorf("StringMatch.MatchType has unexpected type %T", x)
	}
	return nil
}

func _StringMatch_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StringMatch)
	switch tag {
	case 1: // match_type.exact
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Exact{x}
		return true, err
	case 2: // match_type.prefix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Prefix{x}
		return true, err
	case 3: // match_type.suffix
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Suffix{x}
		return true, err
	case 4: // match_type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.MatchType = &StringMatch_Regex{x}
		return true, err
	default:
		return false, nil
	}
}

func _StringMatch_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StringMatch)
	// match_type
	switch x := m.MatchType.(type) {
	case *StringMatch_Exact:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Exact)))
		n += len(x.Exact)
	case *StringMatch_Prefix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Prefix)))
		n += len(x.Prefix)
	case *StringMatch_Suffix:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Suffix)))
		n += len(x.Suffix)
	case *StringMatch_Regex:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Regex)))
		n += len(x.Regex)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// TLS authentication params.
type MutualTls struct {
	// WILL BE DEPRECATED, if set, will translates to `TLS_PERMISSIVE` mode.
	// Set this flag to true to allow regular TLS (i.e without client x509
	// certificate). If request carries client certificate, identity will be
	// extracted and used (set to peer identity). Otherwise, peer identity will
	// be left unset.
	// When the flag is false (default), request must have client certificate.
	AllowTls bool `protobuf:"varint,1,opt,name=allow_tls,json=allowTls,proto3" json:"allow_tls,omitempty"`
	// Defines the mode of mTLS authentication.
	Mode                 MutualTls_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=istio.authentication.v1alpha1.MutualTls_Mode" json:"mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *MutualTls) Reset()         { *m = MutualTls{} }
func (m *MutualTls) String() string { return proto.CompactTextString(m) }
func (*MutualTls) ProtoMessage()    {}
func (*MutualTls) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{1}
}
func (m *MutualTls) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *MutualTls) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_MutualTls.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *MutualTls) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutualTls.Merge(m, src)
}
func (m *MutualTls) XXX_Size() int {
	return m.Size()
}
func (m *MutualTls) XXX_DiscardUnknown() {
	xxx_messageInfo_MutualTls.DiscardUnknown(m)
}

var xxx_messageInfo_MutualTls proto.InternalMessageInfo

func (m *MutualTls) GetAllowTls() bool {
	if m != nil {
		return m.AllowTls
	}
	return false
}

func (m *MutualTls) GetMode() MutualTls_Mode {
	if m != nil {
		return m.Mode
	}
	return MutualTls_STRICT
}

// JSON Web Token (JWT) token format for authentication as defined by
// [RFC 7519](https://tools.ietf.org/html/rfc7519). See [OAuth
// 2.0](https://tools.ietf.org/html/rfc6749) and [OIDC
// 1.0](http://openid.net/connect) for how this is used in the whole
// authentication flow.
//
// For example:
//
// A JWT for any requests:
//
// ```yaml
// issuer: https://example.com
// audiences:
// - bookstore_android.apps.googleusercontent.com
//   bookstore_web.apps.googleusercontent.com
// jwksUri: https://example.com/.well-known/jwks.json
// ```
//
// A JWT for all requests except request at path `/health_check` and path with
// prefix `/status/`. This is useful to expose some paths for public access but
// keep others JWT validated.
//
// ```yaml
// issuer: https://example.com
// jwks_uri: https://example.com/.well-known/jwks.json
// trigger_rules:
// - excluded_paths:
//   - exact: /health_check
//   - prefix: /status/
// ```
//
// A JWT only for requests at path `/admin`. This is useful to only require JWT
// validation on a specific set of paths but keep others public accessible.
//
// ```yaml
// issuer: https://example.com
// jwks_uri: https://example.com/.well-known/jwks.json
// trigger_rules:
// - included_paths:
//   - prefix: /admin
// ```
//
// A JWT only for requests at path of prefix `/status/` but except the path of
// `/status/version`. This means for any request path with prefix `/status/` except
// `/status/version` will require a valid JWT to proceed.
//
// ```yaml
// issuer: https://example.com
// jwks_uri: https://example.com/.well-known/jwks.json
// trigger_rules:
// - excluded_paths:
//   - exact: /status/version
//   included_paths:
//   - prefix: /status/
// ```
type Jwt struct {
	// Identifies the issuer that issued the JWT. See
	// [issuer](https://tools.ietf.org/html/rfc7519#section-4.1.1)
	// Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	Issuer string `protobuf:"bytes,1,opt,name=issuer,proto3" json:"issuer,omitempty"`
	// The list of JWT
	// [audiences](https://tools.ietf.org/html/rfc7519#section-4.1.3).
	// that are allowed to access. A JWT containing any of these
	// audiences will be accepted.
	//
	// The service name will be accepted if audiences is empty.
	//
	// Example:
	//
	// ```yaml
	// audiences:
	// - bookstore_android.apps.googleusercontent.com
	//   bookstore_web.apps.googleusercontent.com
	// ```
	Audiences []string `protobuf:"bytes,2,rep,name=audiences,proto3" json:"audiences,omitempty"`
	// URL of the provider's public key set to validate signature of the
	// JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
	//
	// Optional if the key set document can either (a) be retrieved from
	// [OpenID
	// Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of
	// the issuer or (b) inferred from the email domain of the issuer (e.g. a
	// Google service account).
	//
	// Example: `https://www.googleapis.com/oauth2/v1/certs`
	//
	// Note: Only one of jwks_uri and jwks should be used.
	JwksUri string `protobuf:"bytes,3,opt,name=jwks_uri,json=jwksUri,proto3" json:"jwks_uri,omitempty"`
	// JSON Web Key Set of public keys to validate signature of the JWT.
	// See https://auth0.com/docs/jwks.
	//
	// Note: Only one of jwks_uri and jwks should be used.
	Jwks string `protobuf:"bytes,10,opt,name=jwks,proto3" json:"jwks,omitempty"`
	// JWT is sent in a request header. `header` represents the
	// header name.
	//
	// For example, if `header=x-goog-iap-jwt-assertion`, the header
	// format will be x-goog-iap-jwt-assertion: <JWT>.
	JwtHeaders []string `protobuf:"bytes,6,rep,name=jwt_headers,json=jwtHeaders,proto3" json:"jwt_headers,omitempty"`
	// JWT is sent in a query parameter. `query` represents the
	// query parameter name.
	//
	// For example, `query=jwt_token`.
	JwtParams []string `protobuf:"bytes,7,rep,name=jwt_params,json=jwtParams,proto3" json:"jwt_params,omitempty"`
	// List of trigger rules to decide if this JWT should be used to validate the
	// request. The JWT validation happens if any one of the rules matched.
	// If the list is not empty and none of the rules matched, authentication will
	// skip the JWT validation.
	// Leave this empty to always trigger the JWT validation.
	TriggerRules         []*Jwt_TriggerRule `protobuf:"bytes,9,rep,name=trigger_rules,json=triggerRules,proto3" json:"trigger_rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Jwt) Reset()         { *m = Jwt{} }
func (m *Jwt) String() string { return proto.CompactTextString(m) }
func (*Jwt) ProtoMessage()    {}
func (*Jwt) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{2}
}
func (m *Jwt) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Jwt) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Jwt.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Jwt) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Jwt.Merge(m, src)
}
func (m *Jwt) XXX_Size() int {
	return m.Size()
}
func (m *Jwt) XXX_DiscardUnknown() {
	xxx_messageInfo_Jwt.DiscardUnknown(m)
}

var xxx_messageInfo_Jwt proto.InternalMessageInfo

func (m *Jwt) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *Jwt) GetAudiences() []string {
	if m != nil {
		return m.Audiences
	}
	return nil
}

func (m *Jwt) GetJwksUri() string {
	if m != nil {
		return m.JwksUri
	}
	return ""
}

func (m *Jwt) GetJwks() string {
	if m != nil {
		return m.Jwks
	}
	return ""
}

func (m *Jwt) GetJwtHeaders() []string {
	if m != nil {
		return m.JwtHeaders
	}
	return nil
}

func (m *Jwt) GetJwtParams() []string {
	if m != nil {
		return m.JwtParams
	}
	return nil
}

func (m *Jwt) GetTriggerRules() []*Jwt_TriggerRule {
	if m != nil {
		return m.TriggerRules
	}
	return nil
}

// Trigger rule to match against a request. The trigger rule is satisfied if
// and only if both rules, excluded_paths and include_paths are satisfied.
type Jwt_TriggerRule struct {
	// List of paths to be excluded from the request. The rule is satisfied if
	// request path does not match to any of the path in this list.
	ExcludedPaths []*StringMatch `protobuf:"bytes,1,rep,name=excluded_paths,json=excludedPaths,proto3" json:"excluded_paths,omitempty"`
	// List of paths that the request must include. If the list is not empty, the
	// rule is satisfied if request path matches at least one of the path in the list.
	// If the list is empty, the rule is ignored, in other words the rule is always satisfied.
	IncludedPaths        []*StringMatch `protobuf:"bytes,2,rep,name=included_paths,json=includedPaths,proto3" json:"included_paths,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Jwt_TriggerRule) Reset()         { *m = Jwt_TriggerRule{} }
func (m *Jwt_TriggerRule) String() string { return proto.CompactTextString(m) }
func (*Jwt_TriggerRule) ProtoMessage()    {}
func (*Jwt_TriggerRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{2, 0}
}
func (m *Jwt_TriggerRule) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Jwt_TriggerRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Jwt_TriggerRule.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Jwt_TriggerRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Jwt_TriggerRule.Merge(m, src)
}
func (m *Jwt_TriggerRule) XXX_Size() int {
	return m.Size()
}
func (m *Jwt_TriggerRule) XXX_DiscardUnknown() {
	xxx_messageInfo_Jwt_TriggerRule.DiscardUnknown(m)
}

var xxx_messageInfo_Jwt_TriggerRule proto.InternalMessageInfo

func (m *Jwt_TriggerRule) GetExcludedPaths() []*StringMatch {
	if m != nil {
		return m.ExcludedPaths
	}
	return nil
}

func (m *Jwt_TriggerRule) GetIncludedPaths() []*StringMatch {
	if m != nil {
		return m.IncludedPaths
	}
	return nil
}

// PeerAuthenticationMethod defines one particular type of authentication, e.g
// mutual TLS, JWT etc, (no authentication is one type by itself) that can
// be used for peer authentication.
// The type can be progammatically determine by checking the type of the
// "params" field.
type PeerAuthenticationMethod struct {
	// Types that are valid to be assigned to Params:
	//	*PeerAuthenticationMethod_Mtls
	//	*PeerAuthenticationMethod_Jwt
	Params               isPeerAuthenticationMethod_Params `protobuf_oneof:"params"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *PeerAuthenticationMethod) Reset()         { *m = PeerAuthenticationMethod{} }
func (m *PeerAuthenticationMethod) String() string { return proto.CompactTextString(m) }
func (*PeerAuthenticationMethod) ProtoMessage()    {}
func (*PeerAuthenticationMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{3}
}
func (m *PeerAuthenticationMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PeerAuthenticationMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PeerAuthenticationMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PeerAuthenticationMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PeerAuthenticationMethod.Merge(m, src)
}
func (m *PeerAuthenticationMethod) XXX_Size() int {
	return m.Size()
}
func (m *PeerAuthenticationMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_PeerAuthenticationMethod.DiscardUnknown(m)
}

var xxx_messageInfo_PeerAuthenticationMethod proto.InternalMessageInfo

type isPeerAuthenticationMethod_Params interface {
	isPeerAuthenticationMethod_Params()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PeerAuthenticationMethod_Mtls struct {
	Mtls *MutualTls `protobuf:"bytes,1,opt,name=mtls,proto3,oneof"`
}
type PeerAuthenticationMethod_Jwt struct {
	Jwt *Jwt `protobuf:"bytes,2,opt,name=jwt,proto3,oneof"`
}

func (*PeerAuthenticationMethod_Mtls) isPeerAuthenticationMethod_Params() {}
func (*PeerAuthenticationMethod_Jwt) isPeerAuthenticationMethod_Params()  {}

func (m *PeerAuthenticationMethod) GetParams() isPeerAuthenticationMethod_Params {
	if m != nil {
		return m.Params
	}
	return nil
}

func (m *PeerAuthenticationMethod) GetMtls() *MutualTls {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Mtls); ok {
		return x.Mtls
	}
	return nil
}

func (m *PeerAuthenticationMethod) GetJwt() *Jwt {
	if x, ok := m.GetParams().(*PeerAuthenticationMethod_Jwt); ok {
		return x.Jwt
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PeerAuthenticationMethod) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PeerAuthenticationMethod_OneofMarshaler, _PeerAuthenticationMethod_OneofUnmarshaler, _PeerAuthenticationMethod_OneofSizer, []interface{}{
		(*PeerAuthenticationMethod_Mtls)(nil),
		(*PeerAuthenticationMethod_Jwt)(nil),
	}
}

func _PeerAuthenticationMethod_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PeerAuthenticationMethod)
	// params
	switch x := m.Params.(type) {
	case *PeerAuthenticationMethod_Mtls:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Mtls); err != nil {
			return err
		}
	case *PeerAuthenticationMethod_Jwt:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Jwt); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PeerAuthenticationMethod.Params has unexpected type %T", x)
	}
	return nil
}

func _PeerAuthenticationMethod_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PeerAuthenticationMethod)
	switch tag {
	case 1: // params.mtls
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MutualTls)
		err := b.DecodeMessage(msg)
		m.Params = &PeerAuthenticationMethod_Mtls{msg}
		return true, err
	case 2: // params.jwt
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Jwt)
		err := b.DecodeMessage(msg)
		m.Params = &PeerAuthenticationMethod_Jwt{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PeerAuthenticationMethod_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PeerAuthenticationMethod)
	// params
	switch x := m.Params.(type) {
	case *PeerAuthenticationMethod_Mtls:
		s := proto.Size(x.Mtls)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PeerAuthenticationMethod_Jwt:
		s := proto.Size(x.Jwt)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// OriginAuthenticationMethod defines authentication method/params for origin
// authentication. Origin could be end-user, device, delegate service etc.
// Currently, only JWT is supported for origin authentication.
type OriginAuthenticationMethod struct {
	// Jwt params for the method.
	Jwt                  *Jwt     `protobuf:"bytes,1,opt,name=jwt,proto3" json:"jwt,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *OriginAuthenticationMethod) Reset()         { *m = OriginAuthenticationMethod{} }
func (m *OriginAuthenticationMethod) String() string { return proto.CompactTextString(m) }
func (*OriginAuthenticationMethod) ProtoMessage()    {}
func (*OriginAuthenticationMethod) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{4}
}
func (m *OriginAuthenticationMethod) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *OriginAuthenticationMethod) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_OriginAuthenticationMethod.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *OriginAuthenticationMethod) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OriginAuthenticationMethod.Merge(m, src)
}
func (m *OriginAuthenticationMethod) XXX_Size() int {
	return m.Size()
}
func (m *OriginAuthenticationMethod) XXX_DiscardUnknown() {
	xxx_messageInfo_OriginAuthenticationMethod.DiscardUnknown(m)
}

var xxx_messageInfo_OriginAuthenticationMethod proto.InternalMessageInfo

func (m *OriginAuthenticationMethod) GetJwt() *Jwt {
	if m != nil {
		return m.Jwt
	}
	return nil
}

// Policy defines what authentication methods can be accepted on workload(s),
// and if authenticated, which method/certificate will set the request principal
// (i.e request.auth.principal attribute).
//
// Authentication policy is composed of 2-part authentication:
// - peer: verify caller service credentials. This part will set source.user
// (peer identity).
// - origin: verify the origin credentials. This part will set request.auth.user
// (origin identity), as well as other attributes like request.auth.presenter,
// request.auth.audiences and raw claims. Note that the identity could be
// end-user, service account, device etc.
//
// Last but not least, the principal binding rule defines which identity (peer
// or origin) should be used as principal. By default, it uses peer.
//
// Examples:
//
// Policy to enable mTLS for all services in namespace frod. The policy name must be
// `default`, and it contains no rule for `targets`.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: default
//   namespace: frod
// spec:
//   peers:
//   - mtls:
// ```
// Policy to disable mTLS for "productpage" service
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: productpage-mTLS-disable
//   namespace: frod
// spec:
//   targets:
//   - name: productpage
// ```
// Policy to require mTLS for peer authentication, and JWT for origin authentication
// for productpage:9000 except the path '/health_check' . Principal is set from origin identity.
//
// ```yaml
// apiVersion: authentication.istio.io/v1alpha1
// kind: Policy
// metadata:
//   name: productpage-mTLS-with-JWT
//   namespace: frod
// spec:
//   targets:
//   - name: productpage
//     ports:
//     - number: 9000
//   peers:
//   - mtls:
//   origins:
//   - jwt:
//       issuer: "https://securetoken.google.com"
//       audiences:
//       - "productpage"
//       jwksUri: "https://www.googleapis.com/oauth2/v1/certs"
//       jwt_headers:
//       - "x-goog-iap-jwt-assertion"
//       trigger_rules:
//       - excluded_paths:
//         - exact: /health_check
//   principalBinding: USE_ORIGIN
// ```
type Policy struct {
	// List rules to select workloads that the policy should be applied on.
	// If empty, policy will be used on all workloads in the same namespace.
	Targets []*TargetSelector `protobuf:"bytes,1,rep,name=targets,proto3" json:"targets,omitempty"`
	// List of authentication methods that can be used for peer authentication.
	// They will be evaluated in order; the first validate one will be used to
	// set peer identity (source.user) and other peer attributes. If none of
	// these methods pass, request will be rejected with authentication failed error (401).
	// Leave the list empty if peer authentication is not required
	Peers []*PeerAuthenticationMethod `protobuf:"bytes,2,rep,name=peers,proto3" json:"peers,omitempty"`
	// Set this flag to true to accept request (for peer authentication perspective),
	// even when none of the peer authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for peer (peers field is empty).
	PeerIsOptional bool `protobuf:"varint,3,opt,name=peer_is_optional,json=peerIsOptional,proto3" json:"peer_is_optional,omitempty"`
	// List of authentication methods that can be used for origin authentication.
	// Similar to peers, these will be evaluated in order; the first validate one
	// will be used to set origin identity and attributes (i.e request.auth.user,
	// request.auth.issuer etc). If none of these methods pass, request will be
	// rejected with authentication failed error (401).
	// A method may be skipped, depends on its trigger rule. If all of these methods
	// are skipped, origin authentication will be ignored, as if it is not defined.
	// Leave the list empty if origin authentication is not required.
	Origins []*OriginAuthenticationMethod `protobuf:"bytes,4,rep,name=origins,proto3" json:"origins,omitempty"`
	// Set this flag to true to accept request (for origin authentication perspective),
	// even when none of the origin authentication methods defined above satisfied.
	// Typically, this is used to delay the rejection decision to next layer (e.g
	// authorization).
	// This flag is ignored if no authentication defined for origin (origins field is empty).
	OriginIsOptional bool `protobuf:"varint,5,opt,name=origin_is_optional,json=originIsOptional,proto3" json:"origin_is_optional,omitempty"`
	// Define whether peer or origin identity should be use for principal. Default
	// value is USE_PEER.
	// If peer (or origin) identity is not available, either because of peer/origin
	// authentication is not defined, or failed, principal will be left unset.
	// In other words, binding rule does not affect the decision to accept or
	// reject request.
	PrincipalBinding     PrincipalBinding `protobuf:"varint,6,opt,name=principal_binding,json=principalBinding,proto3,enum=istio.authentication.v1alpha1.PrincipalBinding" json:"principal_binding,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *Policy) Reset()         { *m = Policy{} }
func (m *Policy) String() string { return proto.CompactTextString(m) }
func (*Policy) ProtoMessage()    {}
func (*Policy) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{5}
}
func (m *Policy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Policy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Policy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Policy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Policy.Merge(m, src)
}
func (m *Policy) XXX_Size() int {
	return m.Size()
}
func (m *Policy) XXX_DiscardUnknown() {
	xxx_messageInfo_Policy.DiscardUnknown(m)
}

var xxx_messageInfo_Policy proto.InternalMessageInfo

func (m *Policy) GetTargets() []*TargetSelector {
	if m != nil {
		return m.Targets
	}
	return nil
}

func (m *Policy) GetPeers() []*PeerAuthenticationMethod {
	if m != nil {
		return m.Peers
	}
	return nil
}

func (m *Policy) GetPeerIsOptional() bool {
	if m != nil {
		return m.PeerIsOptional
	}
	return false
}

func (m *Policy) GetOrigins() []*OriginAuthenticationMethod {
	if m != nil {
		return m.Origins
	}
	return nil
}

func (m *Policy) GetOriginIsOptional() bool {
	if m != nil {
		return m.OriginIsOptional
	}
	return false
}

func (m *Policy) GetPrincipalBinding() PrincipalBinding {
	if m != nil {
		return m.PrincipalBinding
	}
	return PrincipalBinding_USE_PEER
}

// TargetSelector defines a matching rule to a workload. A workload is selected
// if it is associated with the service name and service port(s) specified in the selector rule.
type TargetSelector struct {
	// REQUIRED. The name must be a short name from the service registry. The
	// fully qualified domain name will be resolved in a platform specific manner.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// $hide_from_docs
	// $not-implemented-hide
	// Select workload by labels.
	// Once implemented, this is the preferred way rather than using the service name.
	Labels map[string]string `protobuf:"bytes,3,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Specifies the ports. Note that this is the port(s) exposed by the service, not workload instance ports.
	// For example, if a service is defined as below, then `8000` should be used, not `9000`.
	// ```yaml
	// kind: Service
	// metadata:
	//   ...
	// spec:
	//   ports:
	//   - name: http
	//     port: 8000
	//     targetPort: 9000
	//   selector:
	//     app: backend
	// ```
	//Leave empty to match all ports that are exposed.
	Ports                []*PortSelector `protobuf:"bytes,2,rep,name=ports,proto3" json:"ports,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *TargetSelector) Reset()         { *m = TargetSelector{} }
func (m *TargetSelector) String() string { return proto.CompactTextString(m) }
func (*TargetSelector) ProtoMessage()    {}
func (*TargetSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{6}
}
func (m *TargetSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *TargetSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_TargetSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *TargetSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TargetSelector.Merge(m, src)
}
func (m *TargetSelector) XXX_Size() int {
	return m.Size()
}
func (m *TargetSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_TargetSelector.DiscardUnknown(m)
}

var xxx_messageInfo_TargetSelector proto.InternalMessageInfo

func (m *TargetSelector) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TargetSelector) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *TargetSelector) GetPorts() []*PortSelector {
	if m != nil {
		return m.Ports
	}
	return nil
}

// PortSelector specifies the name or number of a port to be used for
// matching targets for authentication policy. This is copied from
// networking API to avoid dependency.
type PortSelector struct {
	// Types that are valid to be assigned to Port:
	//	*PortSelector_Number
	//	*PortSelector_Name
	Port                 isPortSelector_Port `protobuf_oneof:"port"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *PortSelector) Reset()         { *m = PortSelector{} }
func (m *PortSelector) String() string { return proto.CompactTextString(m) }
func (*PortSelector) ProtoMessage()    {}
func (*PortSelector) Descriptor() ([]byte, []int) {
	return fileDescriptor_30ec3f7cef93301a, []int{7}
}
func (m *PortSelector) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *PortSelector) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_PortSelector.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *PortSelector) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PortSelector.Merge(m, src)
}
func (m *PortSelector) XXX_Size() int {
	return m.Size()
}
func (m *PortSelector) XXX_DiscardUnknown() {
	xxx_messageInfo_PortSelector.DiscardUnknown(m)
}

var xxx_messageInfo_PortSelector proto.InternalMessageInfo

type isPortSelector_Port interface {
	isPortSelector_Port()
	MarshalTo([]byte) (int, error)
	Size() int
}

type PortSelector_Number struct {
	Number uint32 `protobuf:"varint,1,opt,name=number,proto3,oneof"`
}
type PortSelector_Name struct {
	Name string `protobuf:"bytes,2,opt,name=name,proto3,oneof"`
}

func (*PortSelector_Number) isPortSelector_Port() {}
func (*PortSelector_Name) isPortSelector_Port()   {}

func (m *PortSelector) GetPort() isPortSelector_Port {
	if m != nil {
		return m.Port
	}
	return nil
}

func (m *PortSelector) GetNumber() uint32 {
	if x, ok := m.GetPort().(*PortSelector_Number); ok {
		return x.Number
	}
	return 0
}

func (m *PortSelector) GetName() string {
	if x, ok := m.GetPort().(*PortSelector_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PortSelector) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PortSelector_OneofMarshaler, _PortSelector_OneofUnmarshaler, _PortSelector_OneofSizer, []interface{}{
		(*PortSelector_Number)(nil),
		(*PortSelector_Name)(nil),
	}
}

func _PortSelector_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PortSelector)
	// port
	switch x := m.Port.(type) {
	case *PortSelector_Number:
		_ = b.EncodeVarint(1<<3 | proto.WireVarint)
		_ = b.EncodeVarint(uint64(x.Number))
	case *PortSelector_Name:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("PortSelector.Port has unexpected type %T", x)
	}
	return nil
}

func _PortSelector_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PortSelector)
	switch tag {
	case 1: // port.number
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Port = &PortSelector_Number{uint32(x)}
		return true, err
	case 2: // port.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Port = &PortSelector_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _PortSelector_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PortSelector)
	// port
	switch x := m.Port.(type) {
	case *PortSelector_Number:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Number))
	case *PortSelector_Name:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("istio.authentication.v1alpha1.PrincipalBinding", PrincipalBinding_name, PrincipalBinding_value)
	proto.RegisterEnum("istio.authentication.v1alpha1.MutualTls_Mode", MutualTls_Mode_name, MutualTls_Mode_value)
	proto.RegisterType((*StringMatch)(nil), "istio.authentication.v1alpha1.StringMatch")
	proto.RegisterType((*MutualTls)(nil), "istio.authentication.v1alpha1.MutualTls")
	proto.RegisterType((*Jwt)(nil), "istio.authentication.v1alpha1.Jwt")
	proto.RegisterType((*Jwt_TriggerRule)(nil), "istio.authentication.v1alpha1.Jwt.TriggerRule")
	proto.RegisterType((*PeerAuthenticationMethod)(nil), "istio.authentication.v1alpha1.PeerAuthenticationMethod")
	proto.RegisterType((*OriginAuthenticationMethod)(nil), "istio.authentication.v1alpha1.OriginAuthenticationMethod")
	proto.RegisterType((*Policy)(nil), "istio.authentication.v1alpha1.Policy")
	proto.RegisterType((*TargetSelector)(nil), "istio.authentication.v1alpha1.TargetSelector")
	proto.RegisterMapType((map[string]string)(nil), "istio.authentication.v1alpha1.TargetSelector.LabelsEntry")
	proto.RegisterType((*PortSelector)(nil), "istio.authentication.v1alpha1.PortSelector")
}

func init() {
	proto.RegisterFile("authentication/v1alpha1/policy.proto", fileDescriptor_30ec3f7cef93301a)
}

var fileDescriptor_30ec3f7cef93301a = []byte{
	// 847 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xc1, 0x6e, 0x23, 0x45,
	0x10, 0xcd, 0x64, 0xec, 0x89, 0x5d, 0x4e, 0x2c, 0xd3, 0x5a, 0xad, 0x86, 0xc0, 0x86, 0x68, 0xb4,
	0x07, 0x6b, 0x81, 0x31, 0x6b, 0x10, 0xb0, 0x1c, 0x90, 0x62, 0x64, 0x36, 0x5e, 0x61, 0xe2, 0x6d,
	0x7b, 0x39, 0x20, 0xa4, 0x51, 0xc7, 0xee, 0xb5, 0xdb, 0xdb, 0x9e, 0x19, 0x75, 0xf7, 0xac, 0xe3,
	0x13, 0x9f, 0xc0, 0x0f, 0xf0, 0x07, 0x1c, 0x11, 0xff, 0xc0, 0x91, 0x4f, 0x40, 0xf9, 0x07, 0xee,
	0xa8, 0xbb, 0x67, 0x88, 0xbd, 0x22, 0x4c, 0xb8, 0xd5, 0xab, 0x9a, 0x7a, 0x55, 0xf3, 0xba, 0xba,
	0x1a, 0x1e, 0x92, 0x4c, 0x2d, 0x68, 0xac, 0xd8, 0x94, 0x28, 0x96, 0xc4, 0x9d, 0xd7, 0x8f, 0x09,
	0x4f, 0x17, 0xe4, 0x71, 0x27, 0x4d, 0x38, 0x9b, 0x6e, 0xc2, 0x54, 0x24, 0x2a, 0x41, 0x0f, 0x98,
	0x54, 0x2c, 0x09, 0x77, 0xbf, 0x0d, 0x8b, 0x6f, 0x83, 0x1f, 0xa1, 0x31, 0x56, 0x82, 0xc5, 0xf3,
	0x21, 0x51, 0xd3, 0x05, 0xba, 0x0f, 0x55, 0x7a, 0x45, 0xa6, 0xca, 0x77, 0x4e, 0x9d, 0x76, 0xfd,
	0x7c, 0x0f, 0x5b, 0x88, 0x7c, 0xf0, 0x52, 0x41, 0x5f, 0xb2, 0x2b, 0x7f, 0x3f, 0x0f, 0xe4, 0x58,
	0x47, 0x64, 0xf6, 0x52, 0x47, 0xdc, 0x22, 0x62, 0xb1, 0xe6, 0x12, 0x74, 0x4e, 0xaf, 0xfc, 0x4a,
	0xc1, 0x65, 0x60, 0xef, 0x10, 0x60, 0xa5, 0x8b, 0x45, 0x6a, 0x93, 0xd2, 0xe0, 0x27, 0x07, 0xea,
	0xc3, 0x4c, 0x65, 0x84, 0x4f, 0xb8, 0x44, 0xef, 0x40, 0x9d, 0x70, 0x9e, 0xac, 0x23, 0xc5, 0xa5,
	0xe9, 0xa1, 0x86, 0x6b, 0xc6, 0xa1, 0x83, 0x67, 0x50, 0x59, 0x25, 0x33, 0x6a, 0x5a, 0x68, 0x76,
	0x3f, 0x0c, 0xff, 0xf3, 0xcf, 0xc2, 0x7f, 0x48, 0xc3, 0x61, 0x32, 0xa3, 0xd8, 0xa4, 0x06, 0x01,
	0x54, 0x34, 0x42, 0x00, 0xde, 0x78, 0x82, 0x07, 0x5f, 0x4d, 0x5a, 0x7b, 0xa8, 0x09, 0x30, 0xea,
	0xe3, 0xe1, 0x60, 0x3c, 0x1e, 0x7c, 0xd7, 0x6f, 0x39, 0xc1, 0x6f, 0x2e, 0xb8, 0xcf, 0xd6, 0x0a,
	0xdd, 0x07, 0x8f, 0x49, 0x99, 0x51, 0x61, 0xc5, 0xc0, 0x39, 0x42, 0xef, 0x42, 0x9d, 0x64, 0x33,
	0x46, 0xe3, 0x29, 0x95, 0xfe, 0xfe, 0xa9, 0xdb, 0xae, 0xe3, 0x1b, 0x07, 0x7a, 0x1b, 0x6a, 0xcb,
	0xf5, 0x2b, 0x19, 0x65, 0x82, 0x59, 0x45, 0xf0, 0x81, 0xc6, 0x2f, 0x04, 0x43, 0x08, 0x2a, 0xda,
	0xf4, 0xc1, 0xb8, 0x8d, 0x8d, 0xde, 0x83, 0xc6, 0x72, 0xad, 0xa2, 0x05, 0x25, 0x33, 0x2a, 0xa4,
	0xef, 0x19, 0x3a, 0x58, 0xae, 0xd5, 0xb9, 0xf5, 0xa0, 0x07, 0xa0, 0x51, 0x94, 0x12, 0x41, 0x56,
	0xd2, 0x3f, 0xb0, 0xe5, 0x96, 0x6b, 0x35, 0x32, 0x0e, 0x34, 0x86, 0x23, 0x25, 0xd8, 0x7c, 0x4e,
	0x45, 0x24, 0x32, 0x4e, 0xa5, 0x5f, 0x3f, 0x75, 0xdb, 0x8d, 0x6e, 0x58, 0x22, 0xce, 0xb3, 0xb5,
	0x0a, 0x27, 0x36, 0x0f, 0x67, 0x9c, 0xe2, 0x43, 0x75, 0x03, 0xe4, 0xf1, 0xaf, 0x0e, 0x34, 0xb6,
	0xa2, 0xe8, 0x39, 0x34, 0xe9, 0xd5, 0x94, 0x67, 0x33, 0x3a, 0x8b, 0x52, 0xa2, 0x16, 0xfa, 0x68,
	0x74, 0x95, 0x47, 0x25, 0x55, 0xb6, 0x26, 0x0b, 0x1f, 0x15, 0x0c, 0x23, 0x4d, 0xa0, 0x29, 0x59,
	0xbc, 0x43, 0xb9, 0xff, 0xff, 0x29, 0x0b, 0x06, 0x43, 0x19, 0xfc, 0xec, 0x80, 0x3f, 0xa2, 0x54,
	0x9c, 0xed, 0xa4, 0x0e, 0xa9, 0x5a, 0x24, 0x33, 0xf4, 0x25, 0x54, 0x56, 0xc5, 0x4c, 0x35, 0xba,
	0xed, 0xbb, 0xce, 0xce, 0xf9, 0x1e, 0x36, 0x79, 0xe8, 0x53, 0x70, 0x97, 0x6b, 0x65, 0x46, 0xaf,
	0xd1, 0x0d, 0xca, 0xd5, 0x3d, 0xdf, 0xc3, 0x3a, 0xa1, 0x57, 0x03, 0xcf, 0x1e, 0x5d, 0x80, 0xe1,
	0xf8, 0x42, 0xb0, 0x39, 0x8b, 0xff, 0xb5, 0xbf, 0x4f, 0x2c, 0xbf, 0x73, 0x57, 0x7e, 0xc3, 0x1e,
	0xfc, 0xe2, 0x82, 0x37, 0x32, 0xb7, 0x1d, 0x3d, 0x85, 0x03, 0x45, 0xc4, 0x9c, 0xaa, 0xe2, 0x70,
	0xca, 0xee, 0xc7, 0xc4, 0x7c, 0x3d, 0xa6, 0x9c, 0x4e, 0x55, 0x22, 0x70, 0x91, 0x8d, 0x86, 0x50,
	0x4d, 0xa9, 0x9e, 0x45, 0x7b, 0x20, 0x9f, 0x95, 0xd0, 0xdc, 0xa6, 0x38, 0xb6, 0x2c, 0xa8, 0x0d,
	0x2d, 0x6d, 0x44, 0x4c, 0x46, 0x49, 0xaa, 0xc3, 0x84, 0x9b, 0x7b, 0x51, 0xc3, 0x4d, 0xed, 0x1f,
	0xc8, 0x8b, 0xdc, 0x8b, 0xc6, 0x70, 0x90, 0x18, 0x81, 0xa4, 0x5f, 0x31, 0xa5, 0x9f, 0x94, 0x94,
	0xbe, 0x5d, 0x4e, 0x5c, 0x30, 0xa1, 0x0f, 0x00, 0x59, 0x73, 0xa7, 0x81, 0xaa, 0x69, 0xa0, 0x65,
	0x23, 0x5b, 0x2d, 0xfc, 0x00, 0x6f, 0xa5, 0x82, 0xc5, 0x53, 0x96, 0x12, 0x1e, 0x5d, 0xb2, 0x78,
	0xc6, 0xe2, 0xb9, 0xef, 0x99, 0x75, 0xd3, 0x29, 0xd3, 0xa1, 0xc8, 0xeb, 0xd9, 0x34, 0xdc, 0x4a,
	0xdf, 0xf0, 0x04, 0x7f, 0x39, 0xd0, 0xdc, 0x55, 0x5d, 0xaf, 0x84, 0x98, 0xac, 0x68, 0xbe, 0x61,
	0x8c, 0x8d, 0x9e, 0x83, 0xc7, 0xc9, 0x25, 0xe5, 0xd2, 0x77, 0xef, 0x24, 0xc3, 0x2e, 0x65, 0xf8,
	0x8d, 0xc9, 0xed, 0xc7, 0x4a, 0x6c, 0x70, 0x4e, 0x84, 0xce, 0xa0, 0x9a, 0x26, 0x42, 0x15, 0x67,
	0xfa, 0x7e, 0xd9, 0xbf, 0x24, 0xe2, 0x66, 0x30, 0x6c, 0xe6, 0xf1, 0x13, 0x68, 0x6c, 0x31, 0xa3,
	0x16, 0xb8, 0xaf, 0xe8, 0x26, 0xef, 0x5b, 0x9b, 0xe8, 0x1e, 0x54, 0x5f, 0x13, 0x9e, 0xd9, 0xf5,
	0x5c, 0xc7, 0x16, 0x7c, 0xb1, 0xff, 0xb9, 0x13, 0x7c, 0x0d, 0x87, 0xdb, 0x8c, 0xfa, 0xc9, 0x88,
	0xb3, 0xd5, 0x65, 0xbe, 0x58, 0x8f, 0xf4, 0x93, 0x61, 0x31, 0xba, 0x97, 0xcb, 0x51, 0x3c, 0x32,
	0x06, 0xf5, 0x3c, 0xa8, 0xe8, 0x1e, 0x1e, 0x7d, 0x04, 0xad, 0x37, 0x55, 0x46, 0x87, 0x50, 0x7b,
	0x31, 0xee, 0x47, 0xa3, 0x7e, 0x1f, 0xdb, 0x55, 0xae, 0xd1, 0x05, 0x1e, 0x3c, 0x1d, 0x7c, 0xdb,
	0x72, 0x7a, 0xdd, 0xdf, 0xaf, 0x4f, 0x9c, 0x3f, 0xae, 0x4f, 0x9c, 0x3f, 0xaf, 0x4f, 0x9c, 0xef,
	0x1f, 0xda, 0xbf, 0x66, 0x49, 0x87, 0xa4, 0xac, 0x73, 0xcb, 0xeb, 0x79, 0xe9, 0x99, 0x77, 0xf3,
	0xe3, 0xbf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xc9, 0x44, 0x8e, 0xc6, 0x5f, 0x07, 0x00, 0x00,
}

func (m *StringMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StringMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.MatchType != nil {
		nn1, err1 := m.MatchType.MarshalTo(dAtA[i:])
		if err1 != nil {
			return 0, err1
		}
		i += nn1
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *StringMatch_Exact) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Exact)))
	i += copy(dAtA[i:], m.Exact)
	return i, nil
}
func (m *StringMatch_Prefix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	return i, nil
}
func (m *StringMatch_Suffix) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x1a
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Suffix)))
	i += copy(dAtA[i:], m.Suffix)
	return i, nil
}
func (m *StringMatch_Regex) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x22
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Regex)))
	i += copy(dAtA[i:], m.Regex)
	return i, nil
}
func (m *MutualTls) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MutualTls) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.AllowTls {
		dAtA[i] = 0x8
		i++
		if m.AllowTls {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Mode != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Jwt) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Jwt) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Issuer) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Issuer)))
		i += copy(dAtA[i:], m.Issuer)
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.JwksUri) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.JwksUri)))
		i += copy(dAtA[i:], m.JwksUri)
	}
	if len(m.JwtHeaders) > 0 {
		for _, s := range m.JwtHeaders {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.JwtParams) > 0 {
		for _, s := range m.JwtParams {
			dAtA[i] = 0x3a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.TriggerRules) > 0 {
		for _, msg := range m.TriggerRules {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Jwks) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Jwks)))
		i += copy(dAtA[i:], m.Jwks)
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Jwt_TriggerRule) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Jwt_TriggerRule) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ExcludedPaths) > 0 {
		for _, msg := range m.ExcludedPaths {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.IncludedPaths) > 0 {
		for _, msg := range m.IncludedPaths {
			dAtA[i] = 0x12
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PeerAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PeerAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Params != nil {
		nn2, err2 := m.Params.MarshalTo(dAtA[i:])
		if err2 != nil {
			return 0, err2
		}
		i += nn2
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PeerAuthenticationMethod_Mtls) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Mtls != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Mtls.Size()))
		n3, err3 := m.Mtls.MarshalTo(dAtA[i:])
		if err3 != nil {
			return 0, err3
		}
		i += n3
	}
	return i, nil
}
func (m *PeerAuthenticationMethod_Jwt) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Jwt != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Jwt.Size()))
		n4, err4 := m.Jwt.MarshalTo(dAtA[i:])
		if err4 != nil {
			return 0, err4
		}
		i += n4
	}
	return i, nil
}
func (m *OriginAuthenticationMethod) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OriginAuthenticationMethod) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Jwt != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.Jwt.Size()))
		n5, err5 := m.Jwt.MarshalTo(dAtA[i:])
		if err5 != nil {
			return 0, err5
		}
		i += n5
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Policy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Policy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0xa
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Peers) > 0 {
		for _, msg := range m.Peers {
			dAtA[i] = 0x12
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.PeerIsOptional {
		dAtA[i] = 0x18
		i++
		if m.PeerIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.Origins) > 0 {
		for _, msg := range m.Origins {
			dAtA[i] = 0x22
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.OriginIsOptional {
		dAtA[i] = 0x28
		i++
		if m.OriginIsOptional {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.PrincipalBinding != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(m.PrincipalBinding))
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *TargetSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TargetSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Ports) > 0 {
		for _, msg := range m.Ports {
			dAtA[i] = 0x12
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Labels) > 0 {
		for k, _ := range m.Labels {
			dAtA[i] = 0x1a
			i++
			v := m.Labels[k]
			mapSize := 1 + len(k) + sovPolicy(uint64(len(k))) + 1 + len(v) + sovPolicy(uint64(len(v)))
			i = encodeVarintPolicy(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintPolicy(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PortSelector) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PortSelector) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Port != nil {
		nn6, err6 := m.Port.MarshalTo(dAtA[i:])
		if err6 != nil {
			return 0, err6
		}
		i += nn6
	}
	if m.XXX_unrecognized != nil {
		i += copy(dAtA[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *PortSelector_Number) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x8
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(m.Number))
	return i, nil
}
func (m *PortSelector_Name) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0x12
	i++
	i = encodeVarintPolicy(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	return i, nil
}
func encodeVarintPolicy(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StringMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.MatchType != nil {
		n += m.MatchType.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *StringMatch_Exact) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Exact)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Prefix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Prefix)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Suffix) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Suffix)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *StringMatch_Regex) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Regex)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}
func (m *MutualTls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.AllowTls {
		n += 2
	}
	if m.Mode != 0 {
		n += 1 + sovPolicy(uint64(m.Mode))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Jwt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Issuer)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Audiences) > 0 {
		for _, s := range m.Audiences {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	l = len(m.JwksUri)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.JwtHeaders) > 0 {
		for _, s := range m.JwtHeaders {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.JwtParams) > 0 {
		for _, s := range m.JwtParams {
			l = len(s)
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.TriggerRules) > 0 {
		for _, e := range m.TriggerRules {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	l = len(m.Jwks)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Jwt_TriggerRule) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.ExcludedPaths) > 0 {
		for _, e := range m.ExcludedPaths {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.IncludedPaths) > 0 {
		for _, e := range m.IncludedPaths {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerAuthenticationMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Params != nil {
		n += m.Params.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PeerAuthenticationMethod_Mtls) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Mtls != nil {
		l = m.Mtls.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *PeerAuthenticationMethod_Jwt) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	return n
}
func (m *OriginAuthenticationMethod) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Jwt != nil {
		l = m.Jwt.Size()
		n += 1 + l + sovPolicy(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Policy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.Peers) > 0 {
		for _, e := range m.Peers {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.PeerIsOptional {
		n += 2
	}
	if len(m.Origins) > 0 {
		for _, e := range m.Origins {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if m.OriginIsOptional {
		n += 2
	}
	if m.PrincipalBinding != 0 {
		n += 1 + sovPolicy(uint64(m.PrincipalBinding))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *TargetSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovPolicy(uint64(l))
	}
	if len(m.Ports) > 0 {
		for _, e := range m.Ports {
			l = e.Size()
			n += 1 + l + sovPolicy(uint64(l))
		}
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovPolicy(uint64(len(k))) + 1 + len(v) + sovPolicy(uint64(len(v)))
			n += mapEntrySize + 1 + sovPolicy(uint64(mapEntrySize))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PortSelector) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Port != nil {
		n += m.Port.Size()
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *PortSelector_Number) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	n += 1 + sovPolicy(uint64(m.Number))
	return n
}
func (m *PortSelector_Name) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovPolicy(uint64(l))
	return n
}

func sovPolicy(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozPolicy(x uint64) (n int) {
	return sovPolicy(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StringMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StringMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StringMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Exact", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Exact{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Prefix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Suffix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Suffix{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MatchType = &StringMatch_Regex{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MutualTls) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MutualTls: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MutualTls: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllowTls", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.AllowTls = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mode", wireType)
			}
			m.Mode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Mode |= MutualTls_Mode(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Jwt) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Jwt: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Jwt: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Issuer", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Issuer = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Audiences", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Audiences = append(m.Audiences, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwksUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwksUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtHeaders", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtHeaders = append(m.JwtHeaders, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JwtParams", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.JwtParams = append(m.JwtParams, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TriggerRules", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TriggerRules = append(m.TriggerRules, &Jwt_TriggerRule{})
			if err := m.TriggerRules[len(m.TriggerRules)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwks", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Jwks = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Jwt_TriggerRule) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TriggerRule: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TriggerRule: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExcludedPaths", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ExcludedPaths = append(m.ExcludedPaths, &StringMatch{})
			if err := m.ExcludedPaths[len(m.ExcludedPaths)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IncludedPaths", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IncludedPaths = append(m.IncludedPaths, &StringMatch{})
			if err := m.IncludedPaths[len(m.IncludedPaths)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PeerAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PeerAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mtls", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &MutualTls{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Mtls{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Jwt{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Params = &PeerAuthenticationMethod_Jwt{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OriginAuthenticationMethod) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OriginAuthenticationMethod: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Jwt", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Jwt == nil {
				m.Jwt = &Jwt{}
			}
			if err := m.Jwt.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Policy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Policy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Policy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, &TargetSelector{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Peers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Peers = append(m.Peers, &PeerAuthenticationMethod{})
			if err := m.Peers[len(m.Peers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.PeerIsOptional = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Origins", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Origins = append(m.Origins, &OriginAuthenticationMethod{})
			if err := m.Origins[len(m.Origins)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginIsOptional", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OriginIsOptional = bool(v != 0)
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrincipalBinding", wireType)
			}
			m.PrincipalBinding = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PrincipalBinding |= PrincipalBinding(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TargetSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TargetSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TargetSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ports", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ports = append(m.Ports, &PortSelector{})
			if err := m.Ports[len(m.Ports)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowPolicy
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPolicy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthPolicy
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthPolicy
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowPolicy
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthPolicy
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthPolicy
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipPolicy(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthPolicy
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PortSelector) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PortSelector: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PortSelector: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Number", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Port = &PortSelector_Number{v}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthPolicy
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthPolicy
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Port = &PortSelector_Name{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipPolicy(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthPolicy
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipPolicy(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowPolicy
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowPolicy
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthPolicy
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthPolicy
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowPolicy
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipPolicy(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthPolicy
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthPolicy = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowPolicy   = fmt.Errorf("proto: integer overflow")
)
