// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/v1/mixer.proto

// This package defines the Mixer API that the sidecar proxy uses to perform
// precondition checks, manage quotas, and report telemetry.

package v1

import (
	context "context"
	fmt "fmt"
	rpc "github.com/gogo/googleapis/google/rpc"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	io "io"
	math "math"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// How an attribute's value was matched
type ReferencedAttributes_Condition int32

const (
	CONDITION_UNSPECIFIED ReferencedAttributes_Condition = 0
	ABSENCE               ReferencedAttributes_Condition = 1
	EXACT                 ReferencedAttributes_Condition = 2
	REGEX                 ReferencedAttributes_Condition = 3
)

var ReferencedAttributes_Condition_name = map[int32]string{
	0: "CONDITION_UNSPECIFIED",
	1: "ABSENCE",
	2: "EXACT",
	3: "REGEX",
}

var ReferencedAttributes_Condition_value = map[string]int32{
	"CONDITION_UNSPECIFIED": 0,
	"ABSENCE":               1,
	"EXACT":                 2,
	"REGEX":                 3,
}

func (ReferencedAttributes_Condition) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{2, 0}
}

// Operation type.
type HeaderOperation_Operation int32

const (
	REPLACE HeaderOperation_Operation = 0
	REMOVE  HeaderOperation_Operation = 1
	APPEND  HeaderOperation_Operation = 2
)

var HeaderOperation_Operation_name = map[int32]string{
	0: "REPLACE",
	1: "REMOVE",
	2: "APPEND",
}

var HeaderOperation_Operation_value = map[string]int32{
	"REPLACE": 0,
	"REMOVE":  1,
	"APPEND":  2,
}

func (HeaderOperation_Operation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{3, 0}
}

// Used to signal how the sets of compressed attributes should be reconstitued server-side.
type ReportRequest_RepeatedAttributesSemantics int32

const (
	// Use delta encoding between sets of compressed attributes to reduce the overall on-wire
	// request size. Each individual set of attributes is used to modify the previous set.
	// NOTE: There is no way with this encoding to specify attribute value deletion. This
	// option should be used with extreme caution.
	DELTA_ENCODING ReportRequest_RepeatedAttributesSemantics = 0
	// Treat each set of compressed attributes as complete - independent from other sets
	// in this request. This will result in on-wire duplication of attributes and values, but
	// will allow for proper accounting of absent values in overall encoding.
	INDEPENDENT_ENCODING ReportRequest_RepeatedAttributesSemantics = 1
)

var ReportRequest_RepeatedAttributesSemantics_name = map[int32]string{
	0: "DELTA_ENCODING",
	1: "INDEPENDENT_ENCODING",
}

var ReportRequest_RepeatedAttributesSemantics_value = map[string]int32{
	"DELTA_ENCODING":       0,
	"INDEPENDENT_ENCODING": 1,
}

func (ReportRequest_RepeatedAttributesSemantics) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{5, 0}
}

// Used to get a thumbs-up/thumbs-down before performing an action.
type CheckRequest struct {
	// The attributes to use for this request.
	//
	// Mixer's configuration determines how these attributes are used to
	// establish the result returned in the response.
	Attributes CompressedAttributes `protobuf:"bytes,1,opt,name=attributes,proto3" json:"attributes"`
	// The number of words in the global dictionary, used with to populate the attributes.
	// This value is used as a quick way to determine whether the client is using a dictionary that
	// the server understands.
	GlobalWordCount uint32 `protobuf:"varint,2,opt,name=global_word_count,json=globalWordCount,proto3" json:"global_word_count,omitempty"`
	// Used for deduplicating `Check` calls in the case of failed RPCs and retries. This should be a UUID
	// per call, where the same UUID is used for retries of the same call.
	DeduplicationId string `protobuf:"bytes,3,opt,name=deduplication_id,json=deduplicationId,proto3" json:"deduplication_id,omitempty"`
	// The individual quotas to allocate
	Quotas map[string]CheckRequest_QuotaParams `protobuf:"bytes,4,rep,name=quotas,proto3" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *CheckRequest) Reset()      { *m = CheckRequest{} }
func (*CheckRequest) ProtoMessage() {}
func (*CheckRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{0}
}
func (m *CheckRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest.Merge(m, src)
}
func (m *CheckRequest) XXX_Size() int {
	return m.Size()
}
func (m *CheckRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest proto.InternalMessageInfo

// parameters for a quota allocation
type CheckRequest_QuotaParams struct {
	// Amount of quota to allocate
	Amount int64 `protobuf:"varint,1,opt,name=amount,proto3" json:"amount,omitempty"`
	// When true, supports returning less quota than what was requested.
	BestEffort bool `protobuf:"varint,2,opt,name=best_effort,json=bestEffort,proto3" json:"best_effort,omitempty"`
}

func (m *CheckRequest_QuotaParams) Reset()      { *m = CheckRequest_QuotaParams{} }
func (*CheckRequest_QuotaParams) ProtoMessage() {}
func (*CheckRequest_QuotaParams) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{0, 0}
}
func (m *CheckRequest_QuotaParams) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckRequest_QuotaParams) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckRequest_QuotaParams.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckRequest_QuotaParams) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckRequest_QuotaParams.Merge(m, src)
}
func (m *CheckRequest_QuotaParams) XXX_Size() int {
	return m.Size()
}
func (m *CheckRequest_QuotaParams) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckRequest_QuotaParams.DiscardUnknown(m)
}

var xxx_messageInfo_CheckRequest_QuotaParams proto.InternalMessageInfo

// The response generated by the Check method.
type CheckResponse struct {
	// The precondition check results.
	Precondition CheckResponse_PreconditionResult `protobuf:"bytes,2,opt,name=precondition,proto3" json:"precondition"`
	// The resulting quota, one entry per requested quota.
	Quotas map[string]CheckResponse_QuotaResult `protobuf:"bytes,3,rep,name=quotas,proto3" json:"quotas" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *CheckResponse) Reset()      { *m = CheckResponse{} }
func (*CheckResponse) ProtoMessage() {}
func (*CheckResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{1}
}
func (m *CheckResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse.Merge(m, src)
}
func (m *CheckResponse) XXX_Size() int {
	return m.Size()
}
func (m *CheckResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse proto.InternalMessageInfo

// Expresses the result of a precondition check.
type CheckResponse_PreconditionResult struct {
	// A status code of OK indicates all preconditions were satisfied. Any other code indicates not
	// all preconditions were satisfied and details describe why.
	Status rpc.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status"`
	// The amount of time for which this result can be considered valid.
	ValidDuration time.Duration `protobuf:"bytes,2,opt,name=valid_duration,json=validDuration,proto3,stdduration" json:"valid_duration"`
	// The number of uses for which this result can be considered valid.
	ValidUseCount int32 `protobuf:"varint,3,opt,name=valid_use_count,json=validUseCount,proto3" json:"valid_use_count,omitempty"`
	// The total set of attributes that were used in producing the result
	// along with matching conditions.
	ReferencedAttributes *ReferencedAttributes `protobuf:"bytes,5,opt,name=referenced_attributes,json=referencedAttributes,proto3" json:"referenced_attributes,omitempty"`
	// An optional routing directive, used to manipulate the traffic metadata
	// whenever all preconditions are satisfied.
	RouteDirective *RouteDirective `protobuf:"bytes,6,opt,name=route_directive,json=routeDirective,proto3" json:"route_directive,omitempty"`
}

func (m *CheckResponse_PreconditionResult) Reset()      { *m = CheckResponse_PreconditionResult{} }
func (*CheckResponse_PreconditionResult) ProtoMessage() {}
func (*CheckResponse_PreconditionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{1, 0}
}
func (m *CheckResponse_PreconditionResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckResponse_PreconditionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckResponse_PreconditionResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckResponse_PreconditionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse_PreconditionResult.Merge(m, src)
}
func (m *CheckResponse_PreconditionResult) XXX_Size() int {
	return m.Size()
}
func (m *CheckResponse_PreconditionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse_PreconditionResult.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse_PreconditionResult proto.InternalMessageInfo

// Expresses the result of a quota allocation.
type CheckResponse_QuotaResult struct {
	// The amount of time for which this result can be considered valid.
	ValidDuration time.Duration `protobuf:"bytes,1,opt,name=valid_duration,json=validDuration,proto3,stdduration" json:"valid_duration"`
	// The amount of granted quota. When `QuotaParams.best_effort` is true, this will be >= 0.
	// If `QuotaParams.best_effort` is false, this will be either 0 or >= `QuotaParams.amount`.
	GrantedAmount int64 `protobuf:"varint,2,opt,name=granted_amount,json=grantedAmount,proto3" json:"granted_amount,omitempty"`
	// The total set of attributes that were used in producing the result
	// along with matching conditions.
	ReferencedAttributes ReferencedAttributes `protobuf:"bytes,5,opt,name=referenced_attributes,json=referencedAttributes,proto3" json:"referenced_attributes"`
}

func (m *CheckResponse_QuotaResult) Reset()      { *m = CheckResponse_QuotaResult{} }
func (*CheckResponse_QuotaResult) ProtoMessage() {}
func (*CheckResponse_QuotaResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{1, 1}
}
func (m *CheckResponse_QuotaResult) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CheckResponse_QuotaResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CheckResponse_QuotaResult.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CheckResponse_QuotaResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckResponse_QuotaResult.Merge(m, src)
}
func (m *CheckResponse_QuotaResult) XXX_Size() int {
	return m.Size()
}
func (m *CheckResponse_QuotaResult) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckResponse_QuotaResult.DiscardUnknown(m)
}

var xxx_messageInfo_CheckResponse_QuotaResult proto.InternalMessageInfo

// Describes the attributes that were used to determine the response.
// This can be used to construct a response cache.
type ReferencedAttributes struct {
	// The message-level dictionary. Refer to [CompressedAttributes][istio.mixer.v1.CompressedAttributes] for information
	// on using dictionaries.
	Words []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
	// Describes a set of attributes.
	AttributeMatches []ReferencedAttributes_AttributeMatch `protobuf:"bytes,2,rep,name=attribute_matches,json=attributeMatches,proto3" json:"attribute_matches"`
}

func (m *ReferencedAttributes) Reset()      { *m = ReferencedAttributes{} }
func (*ReferencedAttributes) ProtoMessage() {}
func (*ReferencedAttributes) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{2}
}
func (m *ReferencedAttributes) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReferencedAttributes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReferencedAttributes.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReferencedAttributes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReferencedAttributes.Merge(m, src)
}
func (m *ReferencedAttributes) XXX_Size() int {
	return m.Size()
}
func (m *ReferencedAttributes) XXX_DiscardUnknown() {
	xxx_messageInfo_ReferencedAttributes.DiscardUnknown(m)
}

var xxx_messageInfo_ReferencedAttributes proto.InternalMessageInfo

// Describes a single attribute match.
type ReferencedAttributes_AttributeMatch struct {
	// The name of the attribute. This is a dictionary index encoded in a manner identical
	// to all strings in the [CompressedAttributes][istio.mixer.v1.CompressedAttributes] message.
	Name int32 `protobuf:"zigzag32,1,opt,name=name,proto3" json:"name,omitempty"`
	// The kind of match against the attribute value.
	Condition ReferencedAttributes_Condition `protobuf:"varint,2,opt,name=condition,proto3,enum=istio.mixer.v1.ReferencedAttributes_Condition" json:"condition,omitempty"`
	// If a REGEX condition is provided for a STRING_MAP attribute,
	// clients should use the regex value to match against map keys.
	Regex string `protobuf:"bytes,3,opt,name=regex,proto3" json:"regex,omitempty"`
	// A key in a STRING_MAP. When multiple keys from a STRING_MAP
	// attribute were referenced, there will be multiple AttributeMatch
	// messages with different map_key values. Values for map_key SHOULD
	// be ignored for attributes that are not STRING_MAP.
	//
	// Indices for the keys are used (taken either from the
	// message dictionary from the `words` field or the global dictionary).
	//
	// If no map_key value is provided for a STRING_MAP attribute, the
	// entire STRING_MAP will be used.
	MapKey int32 `protobuf:"zigzag32,4,opt,name=map_key,json=mapKey,proto3" json:"map_key,omitempty"`
}

func (m *ReferencedAttributes_AttributeMatch) Reset()      { *m = ReferencedAttributes_AttributeMatch{} }
func (*ReferencedAttributes_AttributeMatch) ProtoMessage() {}
func (*ReferencedAttributes_AttributeMatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{2, 0}
}
func (m *ReferencedAttributes_AttributeMatch) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReferencedAttributes_AttributeMatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReferencedAttributes_AttributeMatch.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReferencedAttributes_AttributeMatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReferencedAttributes_AttributeMatch.Merge(m, src)
}
func (m *ReferencedAttributes_AttributeMatch) XXX_Size() int {
	return m.Size()
}
func (m *ReferencedAttributes_AttributeMatch) XXX_DiscardUnknown() {
	xxx_messageInfo_ReferencedAttributes_AttributeMatch.DiscardUnknown(m)
}

var xxx_messageInfo_ReferencedAttributes_AttributeMatch proto.InternalMessageInfo

// Operation on HTTP headers to replace, append, or remove a header. Header
// names are normalized to lower-case with dashes, e.g.  "x-request-id".
// Pseudo-headers ":path", ":authority", and ":method" are supported to modify
// the request headers.
type HeaderOperation struct {
	// Header name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Header value.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Header operation.
	Operation HeaderOperation_Operation `protobuf:"varint,3,opt,name=operation,proto3,enum=istio.mixer.v1.HeaderOperation_Operation" json:"operation,omitempty"`
}

func (m *HeaderOperation) Reset()      { *m = HeaderOperation{} }
func (*HeaderOperation) ProtoMessage() {}
func (*HeaderOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{3}
}
func (m *HeaderOperation) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HeaderOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HeaderOperation.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HeaderOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HeaderOperation.Merge(m, src)
}
func (m *HeaderOperation) XXX_Size() int {
	return m.Size()
}
func (m *HeaderOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_HeaderOperation.DiscardUnknown(m)
}

var xxx_messageInfo_HeaderOperation proto.InternalMessageInfo

// Expresses the routing manipulation actions to be performed on behalf of
// Mixer in response to a precondition check.
type RouteDirective struct {
	// Operations on the request headers.
	RequestHeaderOperations []HeaderOperation `protobuf:"bytes,1,rep,name=request_header_operations,json=requestHeaderOperations,proto3" json:"request_header_operations"`
	// Operations on the response headers.
	ResponseHeaderOperations []HeaderOperation `protobuf:"bytes,2,rep,name=response_header_operations,json=responseHeaderOperations,proto3" json:"response_header_operations"`
	// If set, enables a direct response without proxying the request to the routing
	// destination. Required to be a value in the 2xx or 3xx range.
	DirectResponseCode uint32 `protobuf:"varint,3,opt,name=direct_response_code,json=directResponseCode,proto3" json:"direct_response_code,omitempty"`
	// Supplies the response body for the direct response.
	// If this setting is omitted, no body is included in the generated response.
	DirectResponseBody string `protobuf:"bytes,4,opt,name=direct_response_body,json=directResponseBody,proto3" json:"direct_response_body,omitempty"`
}

func (m *RouteDirective) Reset()      { *m = RouteDirective{} }
func (*RouteDirective) ProtoMessage() {}
func (*RouteDirective) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{4}
}
func (m *RouteDirective) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *RouteDirective) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_RouteDirective.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *RouteDirective) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RouteDirective.Merge(m, src)
}
func (m *RouteDirective) XXX_Size() int {
	return m.Size()
}
func (m *RouteDirective) XXX_DiscardUnknown() {
	xxx_messageInfo_RouteDirective.DiscardUnknown(m)
}

var xxx_messageInfo_RouteDirective proto.InternalMessageInfo

// Used to report telemetry after performing one or more actions.
type ReportRequest struct {
	// The attributes to use for this request.
	//
	// Each `Attributes` element represents the state of a single action. Multiple actions
	// can be provided in a single message in order to improve communication efficiency. The
	// client can accumulate a set of actions and send them all in one single message.
	Attributes []CompressedAttributes `protobuf:"bytes,1,rep,name=attributes,proto3" json:"attributes"`
	// Indicates how to decode the attributes sets in this request.
	RepeatedAttributesSemantics ReportRequest_RepeatedAttributesSemantics `protobuf:"varint,4,opt,name=repeated_attributes_semantics,json=repeatedAttributesSemantics,proto3,enum=istio.mixer.v1.ReportRequest_RepeatedAttributesSemantics" json:"repeated_attributes_semantics,omitempty"`
	// The default message-level dictionary for all the attributes.
	// Individual attribute messages can have their own dictionaries, but if they don't
	// then this set of words, if it is provided, is used instead.
	//
	// This makes it possible to share the same dictionary for all attributes in this
	// request, which can substantially reduce the overall request size.
	DefaultWords []string `protobuf:"bytes,2,rep,name=default_words,json=defaultWords,proto3" json:"default_words,omitempty"`
	// The number of words in the global dictionary.
	// To detect global dictionary out of sync between client and server.
	GlobalWordCount uint32 `protobuf:"varint,3,opt,name=global_word_count,json=globalWordCount,proto3" json:"global_word_count,omitempty"`
}

func (m *ReportRequest) Reset()      { *m = ReportRequest{} }
func (*ReportRequest) ProtoMessage() {}
func (*ReportRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{5}
}
func (m *ReportRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReportRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReportRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReportRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportRequest.Merge(m, src)
}
func (m *ReportRequest) XXX_Size() int {
	return m.Size()
}
func (m *ReportRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReportRequest proto.InternalMessageInfo

// Used to carry responses to telemetry reports
type ReportResponse struct {
}

func (m *ReportResponse) Reset()      { *m = ReportResponse{} }
func (*ReportResponse) ProtoMessage() {}
func (*ReportResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_f6f59c90bff4c1e2, []int{6}
}
func (m *ReportResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ReportResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ReportResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ReportResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReportResponse.Merge(m, src)
}
func (m *ReportResponse) XXX_Size() int {
	return m.Size()
}
func (m *ReportResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReportResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReportResponse proto.InternalMessageInfo

func init() {
	proto.RegisterEnum("istio.mixer.v1.ReferencedAttributes_Condition", ReferencedAttributes_Condition_name, ReferencedAttributes_Condition_value)
	proto.RegisterEnum("istio.mixer.v1.HeaderOperation_Operation", HeaderOperation_Operation_name, HeaderOperation_Operation_value)
	proto.RegisterEnum("istio.mixer.v1.ReportRequest_RepeatedAttributesSemantics", ReportRequest_RepeatedAttributesSemantics_name, ReportRequest_RepeatedAttributesSemantics_value)
	proto.RegisterType((*CheckRequest)(nil), "istio.mixer.v1.CheckRequest")
	proto.RegisterMapType((map[string]CheckRequest_QuotaParams)(nil), "istio.mixer.v1.CheckRequest.QuotasEntry")
	proto.RegisterType((*CheckRequest_QuotaParams)(nil), "istio.mixer.v1.CheckRequest.QuotaParams")
	proto.RegisterType((*CheckResponse)(nil), "istio.mixer.v1.CheckResponse")
	proto.RegisterMapType((map[string]CheckResponse_QuotaResult)(nil), "istio.mixer.v1.CheckResponse.QuotasEntry")
	proto.RegisterType((*CheckResponse_PreconditionResult)(nil), "istio.mixer.v1.CheckResponse.PreconditionResult")
	proto.RegisterType((*CheckResponse_QuotaResult)(nil), "istio.mixer.v1.CheckResponse.QuotaResult")
	proto.RegisterType((*ReferencedAttributes)(nil), "istio.mixer.v1.ReferencedAttributes")
	proto.RegisterType((*ReferencedAttributes_AttributeMatch)(nil), "istio.mixer.v1.ReferencedAttributes.AttributeMatch")
	proto.RegisterType((*HeaderOperation)(nil), "istio.mixer.v1.HeaderOperation")
	proto.RegisterType((*RouteDirective)(nil), "istio.mixer.v1.RouteDirective")
	proto.RegisterType((*ReportRequest)(nil), "istio.mixer.v1.ReportRequest")
	proto.RegisterType((*ReportResponse)(nil), "istio.mixer.v1.ReportResponse")
}

func init() { proto.RegisterFile("mixer/v1/mixer.proto", fileDescriptor_f6f59c90bff4c1e2) }

var fileDescriptor_f6f59c90bff4c1e2 = []byte{
	// 1218 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x56, 0x3b, 0x73, 0xdb, 0x46,
	0x10, 0x06, 0x08, 0x91, 0x36, 0x97, 0x26, 0x05, 0xdf, 0xd0, 0x31, 0x45, 0xc7, 0x90, 0x86, 0x79,
	0x8c, 0x9c, 0x02, 0x94, 0xe5, 0x26, 0x49, 0x91, 0x0c, 0x45, 0x42, 0x0a, 0xfd, 0xa0, 0x14, 0x48,
	0x8e, 0x1d, 0x37, 0x18, 0x08, 0x38, 0xd2, 0x18, 0x93, 0x3c, 0xf8, 0x00, 0x28, 0x56, 0x91, 0x19,
	0xcf, 0xe4, 0x0f, 0xa4, 0xcc, 0xa4, 0x4b, 0x93, 0xc9, 0x2f, 0x48, 0x95, 0x1f, 0xe0, 0xd2, 0xa5,
	0xab, 0x24, 0xa2, 0x93, 0x99, 0x94, 0x2e, 0x5d, 0x66, 0x70, 0x77, 0x00, 0x49, 0x91, 0x92, 0x95,
	0x47, 0x77, 0xb7, 0x8f, 0x6f, 0x77, 0x3f, 0xec, 0x2e, 0x0e, 0xca, 0x03, 0xef, 0x09, 0xa6, 0xf5,
	0x83, 0xeb, 0x75, 0x76, 0xd0, 0x7d, 0x4a, 0x42, 0x82, 0x4a, 0x5e, 0x10, 0x7a, 0x44, 0xe7, 0xa2,
	0x83, 0xeb, 0xd5, 0x72, 0x8f, 0xf4, 0x08, 0x53, 0xd5, 0xe3, 0x13, 0xb7, 0xaa, 0x6a, 0x3d, 0x42,
	0x7a, 0x7d, 0x5c, 0x67, 0xb7, 0xfd, 0xa8, 0x5b, 0x77, 0x23, 0x6a, 0x87, 0x1e, 0x19, 0x0a, 0xfd,
	0x65, 0xa1, 0xa7, 0xbe, 0x53, 0x0f, 0x42, 0x3b, 0x8c, 0x02, 0xa1, 0x58, 0x4a, 0x83, 0xda, 0x61,
	0x48, 0xbd, 0xfd, 0x28, 0xc4, 0x42, 0x55, 0xfb, 0x51, 0x81, 0x0b, 0xcd, 0x87, 0xd8, 0x79, 0x64,
	0xe2, 0xc7, 0x11, 0x0e, 0x42, 0x74, 0x13, 0x60, 0x6c, 0x54, 0x91, 0x57, 0xe4, 0xd5, 0xc2, 0xfa,
	0xbb, 0xfa, 0x74, 0x7e, 0x7a, 0x93, 0x0c, 0x7c, 0x8a, 0x83, 0x00, 0xbb, 0x8d, 0xd4, 0x76, 0x63,
	0xe1, 0xd9, 0xaf, 0xcb, 0x92, 0x39, 0xe1, 0x8d, 0x3e, 0x80, 0x8b, 0xbd, 0x3e, 0xd9, 0xb7, 0xfb,
	0xd6, 0x57, 0x84, 0xba, 0x96, 0x43, 0xa2, 0x61, 0x58, 0xc9, 0xac, 0xc8, 0xab, 0x45, 0x73, 0x91,
	0x2b, 0xee, 0x11, 0xea, 0x36, 0x63, 0x31, 0xba, 0x06, 0xaa, 0x8b, 0xdd, 0xc8, 0xef, 0x7b, 0x0e,
	0xab, 0xc9, 0xf2, 0xdc, 0x8a, 0xb2, 0x22, 0xaf, 0xe6, 0xcd, 0xc5, 0x29, 0x79, 0xdb, 0x45, 0x9b,
	0x90, 0x7b, 0x1c, 0x91, 0xd0, 0x0e, 0x2a, 0x0b, 0x2b, 0xca, 0x6a, 0x61, 0x7d, 0x75, 0x26, 0xbd,
	0x89, 0x82, 0xf4, 0xcf, 0x99, 0xa9, 0x31, 0x0c, 0xe9, 0xa1, 0x48, 0x51, 0x78, 0x57, 0x37, 0xa1,
	0xc0, 0x94, 0x3b, 0x36, 0xb5, 0x07, 0x01, 0x7a, 0x0b, 0x72, 0xf6, 0x80, 0xa5, 0x18, 0x57, 0xad,
	0x98, 0xe2, 0x86, 0x96, 0xa1, 0xb0, 0x8f, 0x83, 0xd0, 0xc2, 0xdd, 0x2e, 0xa1, 0x3c, 0xff, 0xf3,
	0x26, 0xc4, 0x22, 0x83, 0x49, 0xaa, 0x8e, 0xc0, 0xe1, 0x41, 0x90, 0x0a, 0xca, 0x23, 0x7c, 0xc8,
	0x40, 0xf2, 0x66, 0x7c, 0x44, 0x9f, 0x40, 0xf6, 0xc0, 0xee, 0x47, 0x98, 0xf9, 0x9e, 0x29, 0x5f,
	0x9e, 0x92, 0xc9, 0xdd, 0x3e, 0xce, 0x7c, 0x28, 0xd7, 0xfe, 0xcc, 0x41, 0x51, 0xd8, 0x05, 0x3e,
	0x19, 0x06, 0x18, 0x3d, 0x80, 0x0b, 0x3e, 0xc5, 0x0e, 0x19, 0xba, 0x5e, 0x4c, 0x8c, 0x00, 0x5f,
	0x3b, 0x01, 0x9c, 0x3b, 0xe9, 0x3b, 0x13, 0x1e, 0x26, 0x0e, 0xa2, 0x7e, 0x28, 0x48, 0x99, 0xc2,
	0x42, 0x5b, 0x29, 0xc5, 0x0a, 0xa3, 0xf8, 0xda, 0xe9, 0xa8, 0x27, 0x73, 0xfc, 0x47, 0x06, 0xd0,
	0x6c, 0x4c, 0xb4, 0x06, 0x39, 0xde, 0xa1, 0xa2, 0xc3, 0x90, 0xce, 0x7b, 0x57, 0xa7, 0xbe, 0xa3,
	0xef, 0x32, 0x4d, 0x02, 0xc4, 0xed, 0xd0, 0x4d, 0x28, 0x1d, 0xd8, 0x7d, 0xcf, 0xb5, 0x92, 0xa6,
	0x17, 0xf5, 0x2e, 0x25, 0x9e, 0xc9, 0x54, 0xe8, 0x2d, 0x61, 0xb0, 0x71, 0x3e, 0x06, 0xf8, 0xee,
	0xb7, 0x65, 0xd9, 0x2c, 0x32, 0xd7, 0x44, 0x81, 0xde, 0x87, 0x45, 0x8e, 0x15, 0x05, 0x58, 0x74,
	0x65, 0xdc, 0x6a, 0x59, 0x61, 0x77, 0x37, 0xc0, 0xbc, 0x27, 0xbf, 0x84, 0x4b, 0x14, 0x77, 0x31,
	0xc5, 0x43, 0x07, 0xbb, 0xd6, 0xc4, 0x58, 0x64, 0xe7, 0x8f, 0x85, 0x99, 0x1a, 0x8f, 0xc7, 0xc2,
	0x2c, 0xd3, 0x39, 0x52, 0xb4, 0x05, 0x8b, 0x94, 0x44, 0x21, 0xb6, 0x5c, 0x8f, 0x62, 0x27, 0xf4,
	0x0e, 0x70, 0x25, 0xc7, 0x40, 0xb5, 0x19, 0xd0, 0xd8, 0xac, 0x95, 0x58, 0x99, 0x25, 0x3a, 0x75,
	0xbf, 0xb9, 0x70, 0x7e, 0x41, 0xcd, 0x56, 0x8f, 0x64, 0xd1, 0x83, 0x82, 0xdf, 0x59, 0xb6, 0xe4,
	0x7f, 0xcd, 0xd6, 0x7b, 0x50, 0xea, 0x51, 0x7b, 0x18, 0xc6, 0x14, 0x0c, 0xd2, 0x11, 0x56, 0xcc,
	0xa2, 0x90, 0x36, 0xf8, 0x98, 0x58, 0xff, 0x03, 0x59, 0xe2, 0x9b, 0xcf, 0xa5, 0xac, 0xea, 0xbe,
	0x69, 0xcc, 0x3e, 0x9d, 0x1e, 0xb3, 0xb3, 0xf4, 0x2c, 0xa7, 0x6b, 0x72, 0xce, 0xbe, 0x51, 0xa0,
	0x3c, 0x2f, 0x35, 0x54, 0x86, 0x6c, 0xbc, 0xc5, 0xe2, 0x8e, 0x55, 0x56, 0xf3, 0x26, 0xbf, 0xa0,
	0x2e, 0x5c, 0x4c, 0x4b, 0xb5, 0x06, 0x76, 0xe8, 0x3c, 0xc4, 0x41, 0x25, 0xc3, 0x66, 0xe6, 0xc6,
	0x59, 0x2a, 0xd6, 0xd3, 0xe3, 0x9d, 0xd8, 0x59, 0x10, 0xa0, 0xda, 0x53, 0x52, 0x1c, 0x54, 0x7f,
	0x90, 0xa1, 0x34, 0x6d, 0x8a, 0x10, 0x2c, 0x0c, 0xed, 0x01, 0x66, 0x0c, 0x5c, 0x34, 0xd9, 0x19,
	0xdd, 0x86, 0xfc, 0xf4, 0x42, 0x28, 0xad, 0xeb, 0x67, 0x4a, 0xa3, 0x99, 0x0e, 0xe8, 0x18, 0x20,
	0x2e, 0x99, 0xe2, 0x1e, 0x7e, 0x22, 0x16, 0x31, 0xbf, 0xa0, 0xcb, 0x70, 0x6e, 0x60, 0xfb, 0x56,
	0x4c, 0xfe, 0x02, 0x0b, 0x9d, 0x1b, 0xd8, 0xfe, 0x2d, 0x7c, 0x58, 0x6b, 0x43, 0x3e, 0x85, 0x41,
	0x4b, 0x70, 0xa9, 0xb9, 0xdd, 0x69, 0xb5, 0xf7, 0xda, 0xdb, 0x1d, 0xeb, 0x6e, 0x67, 0x77, 0xc7,
	0x68, 0xb6, 0x37, 0xdb, 0x46, 0x4b, 0x95, 0x50, 0x01, 0xce, 0x35, 0x36, 0x76, 0x8d, 0x4e, 0xd3,
	0x50, 0x65, 0x94, 0x87, 0xac, 0x71, 0xbf, 0xd1, 0xdc, 0x53, 0x33, 0xf1, 0xd1, 0x34, 0xb6, 0x8c,
	0xfb, 0xaa, 0x52, 0xfb, 0x59, 0x86, 0xc5, 0xcf, 0xb0, 0xed, 0x62, 0xba, 0xed, 0x63, 0xd1, 0x87,
	0x93, 0xf5, 0xe6, 0x45, 0xbd, 0xe5, 0xc9, 0x4f, 0x9e, 0x17, 0xdf, 0x11, 0x6d, 0x41, 0x9e, 0x24,
	0x6e, 0x2c, 0xf7, 0xd2, 0x6c, 0x33, 0x1c, 0x43, 0xd7, 0xd3, 0x93, 0x39, 0xf6, 0xad, 0xad, 0x41,
	0x7e, 0x1c, 0xbf, 0x00, 0xe7, 0x4c, 0x63, 0xe7, 0x76, 0xa3, 0x69, 0xa8, 0x12, 0x02, 0xc8, 0x99,
	0xc6, 0x9d, 0xed, 0x2f, 0xe2, 0x12, 0x00, 0x72, 0x8d, 0x9d, 0x1d, 0xa3, 0xd3, 0x52, 0x33, 0xb5,
	0x5f, 0x32, 0x50, 0x9a, 0x9e, 0x58, 0x64, 0xc3, 0x12, 0xe5, 0xbb, 0xdd, 0x7a, 0xc8, 0x82, 0x5a,
	0x69, 0x00, 0xde, 0x4c, 0x85, 0xf5, 0xe5, 0x37, 0x64, 0x27, 0xda, 0xe2, 0xb2, 0xc0, 0x39, 0xa6,
	0x0d, 0x90, 0x03, 0x55, 0x2a, 0xfa, 0x7a, 0x4e, 0x8c, 0xcc, 0x3f, 0x89, 0x51, 0x49, 0x80, 0x66,
	0x82, 0xac, 0x41, 0x99, 0x2f, 0x2b, 0x2b, 0x8d, 0xe5, 0x10, 0x17, 0x33, 0x82, 0x8b, 0x26, 0xe2,
	0xba, 0x64, 0xbc, 0x9a, 0xc4, 0xc5, 0xf3, 0x3c, 0xf6, 0x89, 0xcb, 0xdb, 0x26, 0x7f, 0xdc, 0x63,
	0x83, 0xb8, 0x87, 0xb5, 0xd7, 0x19, 0x28, 0x9a, 0xd8, 0x27, 0x34, 0x3c, 0xe9, 0x3d, 0xa2, 0xfc,
	0x87, 0xf7, 0xc8, 0xd7, 0x70, 0x95, 0x62, 0x1f, 0xdb, 0xe1, 0xd4, 0x82, 0xb2, 0x02, 0x3c, 0xb0,
	0x87, 0xa1, 0xe7, 0x04, 0x2c, 0xb1, 0xd2, 0xfa, 0x47, 0xb3, 0x13, 0x33, 0x91, 0x51, 0x7c, 0x63,
	0x10, 0xe3, 0x50, 0xbb, 0x09, 0x80, 0x79, 0x85, 0x9e, 0xac, 0x44, 0xef, 0x40, 0xd1, 0xc5, 0x5d,
	0x3b, 0xea, 0x87, 0x16, 0xdf, 0x24, 0x19, 0xb6, 0x49, 0x2e, 0x08, 0xe1, 0x3d, 0xb6, 0x50, 0xe6,
	0xbe, 0x99, 0x94, 0xb9, 0x6f, 0xa6, 0xda, 0x2d, 0xb8, 0x72, 0x4a, 0x32, 0x08, 0x41, 0xa9, 0x65,
	0xdc, 0xde, 0x6b, 0x58, 0x46, 0xa7, 0xb9, 0xdd, 0x6a, 0x77, 0xb6, 0x54, 0x09, 0x55, 0xa0, 0xdc,
	0xee, 0xb4, 0x8c, 0xb8, 0x5b, 0x8d, 0xce, 0xde, 0x58, 0x23, 0xd7, 0x54, 0x28, 0x25, 0x75, 0xf2,
	0x0f, 0xb2, 0xfe, 0xbd, 0x0c, 0xd9, 0x3b, 0x31, 0x07, 0x68, 0x13, 0xb2, 0x6c, 0x79, 0xa2, 0xb7,
	0x4f, 0x7b, 0xba, 0x54, 0xaf, 0x9e, 0xba, 0x71, 0x6b, 0x12, 0x6a, 0x43, 0x8e, 0xc7, 0x40, 0x57,
	0x4f, 0xe5, 0xb8, 0xaa, 0x9d, 0xa4, 0x4e, 0xa0, 0x36, 0xee, 0x3e, 0x3b, 0xd2, 0xa4, 0xe7, 0x47,
	0x9a, 0xf4, 0xe2, 0x48, 0x93, 0x5e, 0x1d, 0x69, 0xd2, 0xd3, 0x91, 0x26, 0xff, 0x34, 0xd2, 0xa4,
	0x67, 0x23, 0x4d, 0x7e, 0x3e, 0xd2, 0xe4, 0xdf, 0x47, 0x9a, 0xfc, 0xd7, 0x48, 0x93, 0x5e, 0x8d,
	0x34, 0xf9, 0xdb, 0x97, 0x9a, 0xf4, 0xfc, 0xa5, 0x26, 0xbd, 0x78, 0xa9, 0x49, 0x0f, 0x2e, 0x71,
	0x68, 0x8f, 0xd4, 0x6d, 0xdf, 0xab, 0x27, 0x4f, 0xe3, 0xa7, 0xb2, 0xfc, 0x5a, 0x96, 0xf7, 0x73,
	0xec, 0xc7, 0x78, 0xe3, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0x02, 0xb5, 0x66, 0x8d, 0xa8, 0x0b,
	0x00, 0x00,
}

func (x ReferencedAttributes_Condition) String() string {
	s, ok := ReferencedAttributes_Condition_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x HeaderOperation_Operation) String() string {
	s, ok := HeaderOperation_Operation_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (x ReportRequest_RepeatedAttributesSemantics) String() string {
	s, ok := ReportRequest_RepeatedAttributesSemantics_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MixerClient is the client API for Mixer service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MixerClient interface {
	// Checks preconditions and allocate quota before performing an operation.
	// The preconditions enforced depend on the set of supplied attributes and
	// the active configuration.
	Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error)
	// Reports telemetry, such as logs and metrics.
	// The reported information depends on the set of supplied attributes and the
	// active configuration.
	Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error)
}

type mixerClient struct {
	cc *grpc.ClientConn
}

func NewMixerClient(cc *grpc.ClientConn) MixerClient {
	return &mixerClient{cc}
}

func (c *mixerClient) Check(ctx context.Context, in *CheckRequest, opts ...grpc.CallOption) (*CheckResponse, error) {
	out := new(CheckResponse)
	err := c.cc.Invoke(ctx, "/istio.mixer.v1.Mixer/Check", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *mixerClient) Report(ctx context.Context, in *ReportRequest, opts ...grpc.CallOption) (*ReportResponse, error) {
	out := new(ReportResponse)
	err := c.cc.Invoke(ctx, "/istio.mixer.v1.Mixer/Report", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MixerServer is the server API for Mixer service.
type MixerServer interface {
	// Checks preconditions and allocate quota before performing an operation.
	// The preconditions enforced depend on the set of supplied attributes and
	// the active configuration.
	Check(context.Context, *CheckRequest) (*CheckResponse, error)
	// Reports telemetry, such as logs and metrics.
	// The reported information depends on the set of supplied attributes and the
	// active configuration.
	Report(context.Context, *ReportRequest) (*ReportResponse, error)
}

func RegisterMixerServer(s *grpc.Server, srv MixerServer) {
	s.RegisterService(&_Mixer_serviceDesc, srv)
}

func _Mixer_Check_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MixerServer).Check(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.v1.Mixer/Check",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MixerServer).Check(ctx, req.(*CheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Mixer_Report_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MixerServer).Report(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/istio.mixer.v1.Mixer/Report",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MixerServer).Report(ctx, req.(*ReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Mixer_serviceDesc = grpc.ServiceDesc{
	ServiceName: "istio.mixer.v1.Mixer",
	HandlerType: (*MixerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Check",
			Handler:    _Mixer_Check_Handler,
		},
		{
			MethodName: "Report",
			Handler:    _Mixer_Report_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/v1/mixer.proto",
}

func (m *CheckRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMixer(dAtA, i, uint64(m.Attributes.Size()))
	n1, err1 := m.Attributes.MarshalTo(dAtA[i:])
	if err1 != nil {
		return 0, err1
	}
	i += n1
	if m.GlobalWordCount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.GlobalWordCount))
	}
	if len(m.DeduplicationId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMixer(dAtA, i, uint64(len(m.DeduplicationId)))
		i += copy(dAtA[i:], m.DeduplicationId)
	}
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0x22
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovMixer(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovMixer(uint64(len(k))) + msgSize
			i = encodeVarintMixer(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintMixer(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintMixer(dAtA, i, uint64((&v).Size()))
			n2, err2 := (&v).MarshalTo(dAtA[i:])
			if err2 != nil {
				return 0, err2
			}
			i += n2
		}
	}
	return i, nil
}

func (m *CheckRequest_QuotaParams) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckRequest_QuotaParams) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Amount != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.Amount))
	}
	if m.BestEffort {
		dAtA[i] = 0x10
		i++
		if m.BestEffort {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	return i, nil
}

func (m *CheckResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x12
	i++
	i = encodeVarintMixer(dAtA, i, uint64(m.Precondition.Size()))
	n3, err3 := m.Precondition.MarshalTo(dAtA[i:])
	if err3 != nil {
		return 0, err3
	}
	i += n3
	if len(m.Quotas) > 0 {
		for k, _ := range m.Quotas {
			dAtA[i] = 0x1a
			i++
			v := m.Quotas[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovMixer(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovMixer(uint64(len(k))) + msgSize
			i = encodeVarintMixer(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintMixer(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintMixer(dAtA, i, uint64((&v).Size()))
			n4, err4 := (&v).MarshalTo(dAtA[i:])
			if err4 != nil {
				return 0, err4
			}
			i += n4
		}
	}
	return i, nil
}

func (m *CheckResponse_PreconditionResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse_PreconditionResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMixer(dAtA, i, uint64(m.Status.Size()))
	n5, err5 := m.Status.MarshalTo(dAtA[i:])
	if err5 != nil {
		return 0, err5
	}
	i += n5
	dAtA[i] = 0x12
	i++
	i = encodeVarintMixer(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.ValidDuration)))
	n6, err6 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.ValidDuration, dAtA[i:])
	if err6 != nil {
		return 0, err6
	}
	i += n6
	if m.ValidUseCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.ValidUseCount))
	}
	if m.ReferencedAttributes != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.ReferencedAttributes.Size()))
		n7, err7 := m.ReferencedAttributes.MarshalTo(dAtA[i:])
		if err7 != nil {
			return 0, err7
		}
		i += n7
	}
	if m.RouteDirective != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.RouteDirective.Size()))
		n8, err8 := m.RouteDirective.MarshalTo(dAtA[i:])
		if err8 != nil {
			return 0, err8
		}
		i += n8
	}
	return i, nil
}

func (m *CheckResponse_QuotaResult) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckResponse_QuotaResult) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMixer(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.ValidDuration)))
	n9, err9 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.ValidDuration, dAtA[i:])
	if err9 != nil {
		return 0, err9
	}
	i += n9
	if m.GrantedAmount != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.GrantedAmount))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMixer(dAtA, i, uint64(m.ReferencedAttributes.Size()))
	n10, err10 := m.ReferencedAttributes.MarshalTo(dAtA[i:])
	if err10 != nil {
		return 0, err10
	}
	i += n10
	return i, nil
}

func (m *ReferencedAttributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReferencedAttributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.AttributeMatches) > 0 {
		for _, msg := range m.AttributeMatches {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMixer(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ReferencedAttributes_AttributeMatch) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReferencedAttributes_AttributeMatch) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Name != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintMixer(dAtA, i, uint64((uint32(m.Name)<<1)^uint32((m.Name>>31))))
	}
	if m.Condition != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.Condition))
	}
	if len(m.Regex) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMixer(dAtA, i, uint64(len(m.Regex)))
		i += copy(dAtA[i:], m.Regex)
	}
	if m.MapKey != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMixer(dAtA, i, uint64((uint32(m.MapKey)<<1)^uint32((m.MapKey>>31))))
	}
	return i, nil
}

func (m *HeaderOperation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeaderOperation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Name) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMixer(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	if len(m.Value) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMixer(dAtA, i, uint64(len(m.Value)))
		i += copy(dAtA[i:], m.Value)
	}
	if m.Operation != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.Operation))
	}
	return i, nil
}

func (m *RouteDirective) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RouteDirective) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.RequestHeaderOperations) > 0 {
		for _, msg := range m.RequestHeaderOperations {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMixer(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.ResponseHeaderOperations) > 0 {
		for _, msg := range m.ResponseHeaderOperations {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMixer(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DirectResponseCode != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.DirectResponseCode))
	}
	if len(m.DirectResponseBody) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintMixer(dAtA, i, uint64(len(m.DirectResponseBody)))
		i += copy(dAtA[i:], m.DirectResponseBody)
	}
	return i, nil
}

func (m *ReportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, msg := range m.Attributes {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMixer(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.DefaultWords) > 0 {
		for _, s := range m.DefaultWords {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.GlobalWordCount != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.GlobalWordCount))
	}
	if m.RepeatedAttributesSemantics != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintMixer(dAtA, i, uint64(m.RepeatedAttributesSemantics))
	}
	return i, nil
}

func (m *ReportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func encodeVarintMixer(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *CheckRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Attributes.Size()
	n += 1 + l + sovMixer(uint64(l))
	if m.GlobalWordCount != 0 {
		n += 1 + sovMixer(uint64(m.GlobalWordCount))
	}
	l = len(m.DeduplicationId)
	if l > 0 {
		n += 1 + l + sovMixer(uint64(l))
	}
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovMixer(uint64(len(k))) + 1 + l + sovMixer(uint64(l))
			n += mapEntrySize + 1 + sovMixer(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CheckRequest_QuotaParams) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Amount != 0 {
		n += 1 + sovMixer(uint64(m.Amount))
	}
	if m.BestEffort {
		n += 2
	}
	return n
}

func (m *CheckResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Precondition.Size()
	n += 1 + l + sovMixer(uint64(l))
	if len(m.Quotas) > 0 {
		for k, v := range m.Quotas {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovMixer(uint64(len(k))) + 1 + l + sovMixer(uint64(l))
			n += mapEntrySize + 1 + sovMixer(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *CheckResponse_PreconditionResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = m.Status.Size()
	n += 1 + l + sovMixer(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.ValidDuration)
	n += 1 + l + sovMixer(uint64(l))
	if m.ValidUseCount != 0 {
		n += 1 + sovMixer(uint64(m.ValidUseCount))
	}
	if m.ReferencedAttributes != nil {
		l = m.ReferencedAttributes.Size()
		n += 1 + l + sovMixer(uint64(l))
	}
	if m.RouteDirective != nil {
		l = m.RouteDirective.Size()
		n += 1 + l + sovMixer(uint64(l))
	}
	return n
}

func (m *CheckResponse_QuotaResult) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.ValidDuration)
	n += 1 + l + sovMixer(uint64(l))
	if m.GrantedAmount != 0 {
		n += 1 + sovMixer(uint64(m.GrantedAmount))
	}
	l = m.ReferencedAttributes.Size()
	n += 1 + l + sovMixer(uint64(l))
	return n
}

func (m *ReferencedAttributes) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Words) > 0 {
		for _, s := range m.Words {
			l = len(s)
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	if len(m.AttributeMatches) > 0 {
		for _, e := range m.AttributeMatches {
			l = e.Size()
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	return n
}

func (m *ReferencedAttributes_AttributeMatch) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Name != 0 {
		n += 1 + sozMixer(uint64(m.Name))
	}
	if m.Condition != 0 {
		n += 1 + sovMixer(uint64(m.Condition))
	}
	l = len(m.Regex)
	if l > 0 {
		n += 1 + l + sovMixer(uint64(l))
	}
	if m.MapKey != 0 {
		n += 1 + sozMixer(uint64(m.MapKey))
	}
	return n
}

func (m *HeaderOperation) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Name)
	if l > 0 {
		n += 1 + l + sovMixer(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovMixer(uint64(l))
	}
	if m.Operation != 0 {
		n += 1 + sovMixer(uint64(m.Operation))
	}
	return n
}

func (m *RouteDirective) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.RequestHeaderOperations) > 0 {
		for _, e := range m.RequestHeaderOperations {
			l = e.Size()
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	if len(m.ResponseHeaderOperations) > 0 {
		for _, e := range m.ResponseHeaderOperations {
			l = e.Size()
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	if m.DirectResponseCode != 0 {
		n += 1 + sovMixer(uint64(m.DirectResponseCode))
	}
	l = len(m.DirectResponseBody)
	if l > 0 {
		n += 1 + l + sovMixer(uint64(l))
	}
	return n
}

func (m *ReportRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Attributes) > 0 {
		for _, e := range m.Attributes {
			l = e.Size()
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	if len(m.DefaultWords) > 0 {
		for _, s := range m.DefaultWords {
			l = len(s)
			n += 1 + l + sovMixer(uint64(l))
		}
	}
	if m.GlobalWordCount != 0 {
		n += 1 + sovMixer(uint64(m.GlobalWordCount))
	}
	if m.RepeatedAttributesSemantics != 0 {
		n += 1 + sovMixer(uint64(m.RepeatedAttributesSemantics))
	}
	return n
}

func (m *ReportResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func sovMixer(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMixer(x uint64) (n int) {
	return sovMixer(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *CheckRequest) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]CheckRequest_QuotaParams{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&CheckRequest{`,
		`Attributes:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Attributes), "CompressedAttributes", "CompressedAttributes", 1), `&`, ``, 1) + `,`,
		`GlobalWordCount:` + fmt.Sprintf("%v", this.GlobalWordCount) + `,`,
		`DeduplicationId:` + fmt.Sprintf("%v", this.DeduplicationId) + `,`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckRequest_QuotaParams) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckRequest_QuotaParams{`,
		`Amount:` + fmt.Sprintf("%v", this.Amount) + `,`,
		`BestEffort:` + fmt.Sprintf("%v", this.BestEffort) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse) String() string {
	if this == nil {
		return "nil"
	}
	keysForQuotas := make([]string, 0, len(this.Quotas))
	for k, _ := range this.Quotas {
		keysForQuotas = append(keysForQuotas, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForQuotas)
	mapStringForQuotas := "map[string]CheckResponse_QuotaResult{"
	for _, k := range keysForQuotas {
		mapStringForQuotas += fmt.Sprintf("%v: %v,", k, this.Quotas[k])
	}
	mapStringForQuotas += "}"
	s := strings.Join([]string{`&CheckResponse{`,
		`Precondition:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Precondition), "CheckResponse_PreconditionResult", "CheckResponse_PreconditionResult", 1), `&`, ``, 1) + `,`,
		`Quotas:` + mapStringForQuotas + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse_PreconditionResult) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckResponse_PreconditionResult{`,
		`Status:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Status), "Status", "rpc.Status", 1), `&`, ``, 1) + `,`,
		`ValidDuration:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ValidDuration), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`ValidUseCount:` + fmt.Sprintf("%v", this.ValidUseCount) + `,`,
		`ReferencedAttributes:` + strings.Replace(this.ReferencedAttributes.String(), "ReferencedAttributes", "ReferencedAttributes", 1) + `,`,
		`RouteDirective:` + strings.Replace(this.RouteDirective.String(), "RouteDirective", "RouteDirective", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CheckResponse_QuotaResult) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CheckResponse_QuotaResult{`,
		`ValidDuration:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.ValidDuration), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`GrantedAmount:` + fmt.Sprintf("%v", this.GrantedAmount) + `,`,
		`ReferencedAttributes:` + strings.Replace(strings.Replace(this.ReferencedAttributes.String(), "ReferencedAttributes", "ReferencedAttributes", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReferencedAttributes) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributeMatches := "[]ReferencedAttributes_AttributeMatch{"
	for _, f := range this.AttributeMatches {
		repeatedStringForAttributeMatches += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAttributeMatches += "}"
	s := strings.Join([]string{`&ReferencedAttributes{`,
		`Words:` + fmt.Sprintf("%v", this.Words) + `,`,
		`AttributeMatches:` + repeatedStringForAttributeMatches + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReferencedAttributes_AttributeMatch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReferencedAttributes_AttributeMatch{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Condition:` + fmt.Sprintf("%v", this.Condition) + `,`,
		`Regex:` + fmt.Sprintf("%v", this.Regex) + `,`,
		`MapKey:` + fmt.Sprintf("%v", this.MapKey) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeaderOperation) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeaderOperation{`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`Operation:` + fmt.Sprintf("%v", this.Operation) + `,`,
		`}`,
	}, "")
	return s
}
func (this *RouteDirective) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForRequestHeaderOperations := "[]HeaderOperation{"
	for _, f := range this.RequestHeaderOperations {
		repeatedStringForRequestHeaderOperations += strings.Replace(strings.Replace(f.String(), "HeaderOperation", "HeaderOperation", 1), `&`, ``, 1) + ","
	}
	repeatedStringForRequestHeaderOperations += "}"
	repeatedStringForResponseHeaderOperations := "[]HeaderOperation{"
	for _, f := range this.ResponseHeaderOperations {
		repeatedStringForResponseHeaderOperations += strings.Replace(strings.Replace(f.String(), "HeaderOperation", "HeaderOperation", 1), `&`, ``, 1) + ","
	}
	repeatedStringForResponseHeaderOperations += "}"
	s := strings.Join([]string{`&RouteDirective{`,
		`RequestHeaderOperations:` + repeatedStringForRequestHeaderOperations + `,`,
		`ResponseHeaderOperations:` + repeatedStringForResponseHeaderOperations + `,`,
		`DirectResponseCode:` + fmt.Sprintf("%v", this.DirectResponseCode) + `,`,
		`DirectResponseBody:` + fmt.Sprintf("%v", this.DirectResponseBody) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReportRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForAttributes := "[]CompressedAttributes{"
	for _, f := range this.Attributes {
		repeatedStringForAttributes += fmt.Sprintf("%v", f) + ","
	}
	repeatedStringForAttributes += "}"
	s := strings.Join([]string{`&ReportRequest{`,
		`Attributes:` + repeatedStringForAttributes + `,`,
		`DefaultWords:` + fmt.Sprintf("%v", this.DefaultWords) + `,`,
		`GlobalWordCount:` + fmt.Sprintf("%v", this.GlobalWordCount) + `,`,
		`RepeatedAttributesSemantics:` + fmt.Sprintf("%v", this.RepeatedAttributesSemantics) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ReportResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ReportResponse{`,
		`}`,
	}, "")
	return s
}
func valueToStringMixer(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *CheckRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalWordCount", wireType)
			}
			m.GlobalWordCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GlobalWordCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeduplicationId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DeduplicationId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]CheckRequest_QuotaParams)
			}
			var mapkey string
			mapvalue := &CheckRequest_QuotaParams{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMixer
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMixer
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMixer
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMixer
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMixer
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMixer
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMixer
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CheckRequest_QuotaParams{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMixer(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMixer
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckRequest_QuotaParams) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaParams: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaParams: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Amount", wireType)
			}
			m.Amount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Amount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BestEffort", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.BestEffort = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Precondition", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Precondition.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Quotas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Quotas == nil {
				m.Quotas = make(map[string]CheckResponse_QuotaResult)
			}
			var mapkey string
			mapvalue := &CheckResponse_QuotaResult{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowMixer
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMixer
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthMixer
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthMixer
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowMixer
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthMixer
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthMixer
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &CheckResponse_QuotaResult{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipMixer(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthMixer
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Quotas[mapkey] = *mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse_PreconditionResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PreconditionResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PreconditionResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.ValidDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidUseCount", wireType)
			}
			m.ValidUseCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValidUseCount |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReferencedAttributes == nil {
				m.ReferencedAttributes = &ReferencedAttributes{}
			}
			if err := m.ReferencedAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RouteDirective", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RouteDirective == nil {
				m.RouteDirective = &RouteDirective{}
			}
			if err := m.RouteDirective.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckResponse_QuotaResult) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaResult: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaResult: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValidDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.ValidDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrantedAmount", wireType)
			}
			m.GrantedAmount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GrantedAmount |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedAttributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReferencedAttributes.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReferencedAttributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReferencedAttributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReferencedAttributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Words", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Words = append(m.Words, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeMatches", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AttributeMatches = append(m.AttributeMatches, ReferencedAttributes_AttributeMatch{})
			if err := m.AttributeMatches[len(m.AttributeMatches)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReferencedAttributes_AttributeMatch) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AttributeMatch: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AttributeMatch: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.Name = v
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Condition", wireType)
			}
			m.Condition = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Condition |= ReferencedAttributes_Condition(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Regex", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Regex = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MapKey", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			v = int32((uint32(v) >> 1) ^ uint32(((v&1)<<31)>>31))
			m.MapKey = v
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeaderOperation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeaderOperation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeaderOperation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Operation", wireType)
			}
			m.Operation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Operation |= HeaderOperation_Operation(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RouteDirective) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RouteDirective: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RouteDirective: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestHeaderOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestHeaderOperations = append(m.RequestHeaderOperations, HeaderOperation{})
			if err := m.RequestHeaderOperations[len(m.RequestHeaderOperations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeaderOperations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseHeaderOperations = append(m.ResponseHeaderOperations, HeaderOperation{})
			if err := m.ResponseHeaderOperations[len(m.ResponseHeaderOperations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirectResponseCode", wireType)
			}
			m.DirectResponseCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DirectResponseCode |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DirectResponseBody", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DirectResponseBody = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attributes = append(m.Attributes, CompressedAttributes{})
			if err := m.Attributes[len(m.Attributes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultWords", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMixer
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthMixer
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DefaultWords = append(m.DefaultWords, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GlobalWordCount", wireType)
			}
			m.GlobalWordCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GlobalWordCount |= uint32(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RepeatedAttributesSemantics", wireType)
			}
			m.RepeatedAttributesSemantics = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RepeatedAttributesSemantics |= ReportRequest_RepeatedAttributesSemantics(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipMixer(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthMixer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMixer(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMixer
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMixer
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthMixer
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthMixer
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMixer
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMixer(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthMixer
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMixer = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMixer   = fmt.Errorf("proto: integer overflow")
)
