// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/tracespan/tracespan_handler_service.proto

// The `tracespan` template represents an individual span within a distributed trace.
//
// Example config:
//
// ```yaml
// apiVersion: "config.istio.io/v1alpha2"
// kind: instance
// metadata:
//   name: default
//   namespace: istio-system
// spec:
//   compiledTemplate: tracespan
//   params:
//     traceId: request.headers["x-b3-traceid"]
//     spanId: request.headers["x-b3-spanid"] | ""
//     parentSpanId: request.headers["x-b3-parentspanid"] | ""
//     spanName: request.path | "/"
//     startTime: request.time
//     endTime: response.time
//     clientSpan: (context.reporter.kind | "inbound") == "outbound"
//     rewriteClientSpanId: false
//     spanTags:
//       http.method: request.method | ""
//       http.status_code: response.code | 200
//       http.url: request.path | ""
//       request.size: request.size | 0
//       response.size: response.size | 0
//       source.principal: source.principal | ""
//       source.version: source.labels["version"] | ""
// ```
//
// See also: [Distributed Tracing](https://istio.io/docs/tasks/telemetry/distributed-tracing/)
// for information on tracing within Istio.
//
// TraceSpan represents an individual span within a distributed trace.
//
// When writing the configuration, the value for the fields associated with this template can either be a
// literal or an [expression](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/). Please note that if the datatype of a field is not istio.policy.v1beta1.Value,
// then the expression's [inferred type](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/#type-checking) must match the datatype of the field.

package tracespan

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"
	types "github.com/gogo/protobuf/types"
	grpc "google.golang.org/grpc"
	io "io"
	v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
	v1beta1 "istio.io/api/policy/v1beta1"
	math "math"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleTraceSpan method.
type HandleTraceSpanRequest struct {
	// 'tracespan' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *types.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig,proto3" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleTraceSpanRequest) Reset()      { *m = HandleTraceSpanRequest{} }
func (*HandleTraceSpanRequest) ProtoMessage() {}
func (*HandleTraceSpanRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d7a88390fe13e73, []int{0}
}
func (m *HandleTraceSpanRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *HandleTraceSpanRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_HandleTraceSpanRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *HandleTraceSpanRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HandleTraceSpanRequest.Merge(m, src)
}
func (m *HandleTraceSpanRequest) XXX_Size() int {
	return m.Size()
}
func (m *HandleTraceSpanRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_HandleTraceSpanRequest.DiscardUnknown(m)
}

var xxx_messageInfo_HandleTraceSpanRequest proto.InternalMessageInfo

// Contains instance payload for 'tracespan' template. This is passed to infrastructure backends during request-time
// through HandleTraceSpanService.HandleTraceSpan.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime *v1beta1.TimeStamp `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime *v1beta1.TimeStamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]*v1beta1.Value `protobuf:"bytes,7,rep,name=span_tags,json=spanTags,proto3" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP status code used to set the span status. If unset or set to 0, the
	// span status will be assumed to be successful.
	HttpStatusCode int64 `protobuf:"varint,8,opt,name=httpStatusCode,proto3" json:"httpStatusCode,omitempty"`
	// client_span indicates the span kind. True for client spans and False or
	// not provided for server spans. Using bool instead of enum is a temporary
	// work around since mixer expression language does not yet support enum
	// type.
	//
	// Optional
	ClientSpan bool `protobuf:"varint,9,opt,name=client_span,json=clientSpan,proto3" json:"client_span,omitempty"`
	// rewrite_client_span_id is used to indicate whether to create a new client
	// span id to accommodate Zipkin shared span model. Some tracing systems like
	// Stackdriver separates a RPC into client span and server span. To solve this
	// incompatibility, deterministically rewriting both span id of client span and
	// parent span id of server span to the same newly generated id.
	//
	// Optional
	RewriteClientSpanId bool `protobuf:"varint,10,opt,name=rewrite_client_span_id,json=rewriteClientSpanId,proto3" json:"rewrite_client_span_id,omitempty"`
	// Identifies the source (client side) of this span.
	// Should usually be set to `source.workload.name`.
	//
	// Optional.
	SourceName string `protobuf:"bytes,11,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	// Client IP address. Should usually be set to `source.ip`.
	//
	// Optional.
	SourceIp *v1beta1.IPAddress `protobuf:"bytes,12,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Identifies the destination (server side) of this span.
	// Should usually be set to `destination.workload.name`.
	//
	// Optional.
	DestinationName string `protobuf:"bytes,13,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Server IP address. Should usually be set to `destination.ip`.
	//
	// Optional.
	DestinationIp *v1beta1.IPAddress `protobuf:"bytes,14,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Request body size. Should usually be set to `request.size`.
	//
	// Optional.
	RequestSize int64 `protobuf:"varint,15,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// Total request size (headers and body).
	// Should usually be set to `request.total_size`.
	//
	// Optional.
	RequestTotalSize int64 `protobuf:"varint,16,opt,name=request_total_size,json=requestTotalSize,proto3" json:"request_total_size,omitempty"`
	// Response body size. Should usually be set to `response.size`.
	//
	// Optional.
	ResponseSize int64 `protobuf:"varint,17,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Response total size (headers and body).
	// Should usually be set to `response.total_size`.
	//
	// Optional.
	ResponseTotalSize int64 `protobuf:"varint,18,opt,name=response_total_size,json=responseTotalSize,proto3" json:"response_total_size,omitempty"`
	// One of "http", "https", or "grpc" or any other value of
	// the `api.protocol` attribute. Should usually be set to `api.protocol`.
	//
	// Optional.
	ApiProtocol string `protobuf:"bytes,19,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d7a88390fe13e73, []int{1}
}
func (m *InstanceMsg) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceMsg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceMsg.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceMsg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceMsg.Merge(m, src)
}
func (m *InstanceMsg) XXX_Size() int {
	return m.Size()
}
func (m *InstanceMsg) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceMsg.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceMsg proto.InternalMessageInfo

// Contains inferred type information about specific instance of 'tracespan' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]v1beta1.ValueType `protobuf:"bytes,7,rep,name=span_tags,json=spanTags,proto3" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()      { *m = Type{} }
func (*Type) ProtoMessage() {}
func (*Type) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d7a88390fe13e73, []int{2}
}
func (m *Type) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Type) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Type.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Type) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Type.Merge(m, src)
}
func (m *Type) XXX_Size() int {
	return m.Size()
}
func (m *Type) XXX_DiscardUnknown() {
	xxx_messageInfo_Type.DiscardUnknown(m)
}

var xxx_messageInfo_Type proto.InternalMessageInfo

// Represents instance configuration schema for 'tracespan' template.
type InstanceParam struct {
	// Trace ID is the unique identifier for a trace. All spans from the same
	// trace share the same Trace ID.
	//
	// Required.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Span ID is the unique identifier for a span within a trace. It is assigned
	// when the span is created.
	//
	// Optional.
	SpanId string `protobuf:"bytes,2,opt,name=span_id,json=spanId,proto3" json:"span_id,omitempty"`
	// Parent Span ID is the unique identifier for a parent span of this span
	// instance. If this is a root span, then this field MUST be empty.
	//
	// Optional.
	ParentSpanId string `protobuf:"bytes,3,opt,name=parent_span_id,json=parentSpanId,proto3" json:"parent_span_id,omitempty"`
	// Span name is a description of the span's operation.
	//
	// For example, the name can be a qualified method name or a file name
	// and a line number where the operation is called. A best practice is to use
	// the same display name within an application and at the same call point.
	// This makes it easier to correlate spans in different traces.
	//
	// Required.
	SpanName string `protobuf:"bytes,4,opt,name=span_name,json=spanName,proto3" json:"span_name,omitempty"`
	// The start time of the span.
	//
	// Required.
	StartTime string `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the span.
	//
	// Required.
	EndTime string `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Span tags are a set of < key, value > pairs that provide metadata for the
	// entire span. The values can be specified in the form of expressions.
	//
	// Optional.
	SpanTags map[string]string `protobuf:"bytes,7,rep,name=span_tags,json=spanTags,proto3" json:"span_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// HTTP status code used to set the span status. If unset or set to 0, the
	// span status will be assumed to be successful.
	HttpStatusCode string `protobuf:"bytes,8,opt,name=httpStatusCode,proto3" json:"httpStatusCode,omitempty"`
	// client_span indicates the span kind. True for client spans and False or
	// not provided for server spans. Using bool instead of enum is a temporary
	// work around since mixer expression language does not yet support enum
	// type.
	//
	// Optional
	ClientSpan string `protobuf:"bytes,9,opt,name=client_span,json=clientSpan,proto3" json:"client_span,omitempty"`
	// rewrite_client_span_id is used to indicate whether to create a new client
	// span id to accommodate Zipkin shared span model. Some tracing systems like
	// Stackdriver separates a RPC into client span and server span. To solve this
	// incompatibility, deterministically rewriting both span id of client span and
	// parent span id of server span to the same newly generated id.
	//
	// Optional
	RewriteClientSpanId string `protobuf:"bytes,10,opt,name=rewrite_client_span_id,json=rewriteClientSpanId,proto3" json:"rewrite_client_span_id,omitempty"`
	// Identifies the source (client side) of this span.
	// Should usually be set to `source.workload.name`.
	//
	// Optional.
	SourceName string `protobuf:"bytes,11,opt,name=source_name,json=sourceName,proto3" json:"source_name,omitempty"`
	// Client IP address. Should usually be set to `source.ip`.
	//
	// Optional.
	SourceIp string `protobuf:"bytes,12,opt,name=source_ip,json=sourceIp,proto3" json:"source_ip,omitempty"`
	// Identifies the destination (server side) of this span.
	// Should usually be set to `destination.workload.name`.
	//
	// Optional.
	DestinationName string `protobuf:"bytes,13,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Server IP address. Should usually be set to `destination.ip`.
	//
	// Optional.
	DestinationIp string `protobuf:"bytes,14,opt,name=destination_ip,json=destinationIp,proto3" json:"destination_ip,omitempty"`
	// Request body size. Should usually be set to `request.size`.
	//
	// Optional.
	RequestSize string `protobuf:"bytes,15,opt,name=request_size,json=requestSize,proto3" json:"request_size,omitempty"`
	// Total request size (headers and body).
	// Should usually be set to `request.total_size`.
	//
	// Optional.
	RequestTotalSize string `protobuf:"bytes,16,opt,name=request_total_size,json=requestTotalSize,proto3" json:"request_total_size,omitempty"`
	// Response body size. Should usually be set to `response.size`.
	//
	// Optional.
	ResponseSize string `protobuf:"bytes,17,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Response total size (headers and body).
	// Should usually be set to `response.total_size`.
	//
	// Optional.
	ResponseTotalSize string `protobuf:"bytes,18,opt,name=response_total_size,json=responseTotalSize,proto3" json:"response_total_size,omitempty"`
	// One of "http", "https", or "grpc" or any other value of
	// the `api.protocol` attribute. Should usually be set to `api.protocol`.
	//
	// Optional.
	ApiProtocol string `protobuf:"bytes,19,opt,name=api_protocol,json=apiProtocol,proto3" json:"api_protocol,omitempty"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptor_4d7a88390fe13e73, []int{3}
}
func (m *InstanceParam) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *InstanceParam) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_InstanceParam.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *InstanceParam) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InstanceParam.Merge(m, src)
}
func (m *InstanceParam) XXX_Size() int {
	return m.Size()
}
func (m *InstanceParam) XXX_DiscardUnknown() {
	xxx_messageInfo_InstanceParam.DiscardUnknown(m)
}

var xxx_messageInfo_InstanceParam proto.InternalMessageInfo

func init() {
	proto.RegisterType((*HandleTraceSpanRequest)(nil), "tracespan.HandleTraceSpanRequest")
	proto.RegisterType((*InstanceMsg)(nil), "tracespan.InstanceMsg")
	proto.RegisterMapType((map[string]*v1beta1.Value)(nil), "tracespan.InstanceMsg.SpanTagsEntry")
	proto.RegisterType((*Type)(nil), "tracespan.Type")
	proto.RegisterMapType((map[string]v1beta1.ValueType)(nil), "tracespan.Type.SpanTagsEntry")
	proto.RegisterType((*InstanceParam)(nil), "tracespan.InstanceParam")
	proto.RegisterMapType((map[string]string)(nil), "tracespan.InstanceParam.SpanTagsEntry")
}

func init() {
	proto.RegisterFile("mixer/template/tracespan/tracespan_handler_service.proto", fileDescriptor_4d7a88390fe13e73)
}

var fileDescriptor_4d7a88390fe13e73 = []byte{
	// 989 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x56, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xf7, 0x26, 0x69, 0xec, 0x19, 0xff, 0x49, 0x3a, 0x09, 0x61, 0xe3, 0xa8, 0x1b, 0x27, 0x94,
	0xca, 0x48, 0xd5, 0x5a, 0x49, 0x41, 0xaa, 0x5a, 0x84, 0x14, 0x22, 0x10, 0x3e, 0x14, 0x45, 0x6b,
	0x0b, 0x71, 0x40, 0x5a, 0x4d, 0xbc, 0xaf, 0xee, 0x88, 0xf5, 0xee, 0xb0, 0x33, 0x0e, 0x75, 0x2f,
	0x20, 0x3e, 0x01, 0x52, 0x4f, 0xdc, 0x38, 0x21, 0x6e, 0x7c, 0x01, 0x3e, 0x40, 0x85, 0x84, 0x14,
	0x71, 0xea, 0x05, 0x89, 0x38, 0x3d, 0x70, 0xec, 0x91, 0x23, 0xda, 0xb7, 0x6b, 0x7b, 0x71, 0xdc,
	0xd6, 0xcd, 0x85, 0xdb, 0xcc, 0x7b, 0xbf, 0x79, 0x7f, 0xe7, 0xf7, 0xf4, 0xe8, 0xed, 0x9e, 0x78,
	0x08, 0x51, 0x43, 0x43, 0x4f, 0xfa, 0x5c, 0x43, 0x43, 0x47, 0xbc, 0x03, 0x4a, 0xf2, 0x60, 0x72,
	0x72, 0x1f, 0xf0, 0xc0, 0xf3, 0x21, 0x72, 0x15, 0x44, 0x27, 0xa2, 0x03, 0xb6, 0x8c, 0x42, 0x1d,
	0x32, 0x32, 0x06, 0x54, 0xd7, 0xbb, 0x61, 0x37, 0x44, 0x69, 0x23, 0x3e, 0x25, 0x80, 0xea, 0xcd,
	0xc4, 0x34, 0xf7, 0xb8, 0xd4, 0x10, 0x35, 0x7a, 0xa1, 0x07, 0x7e, 0xe3, 0x64, 0xef, 0x18, 0x34,
	0xdf, 0x6b, 0xc0, 0x43, 0x0d, 0x81, 0x12, 0x61, 0xa0, 0x52, 0xf4, 0x66, 0x37, 0x0c, 0xbb, 0x3e,
	0x34, 0xf0, 0x76, 0xdc, 0xbf, 0xdf, 0xe0, 0xc1, 0x20, 0x55, 0xd5, 0x5f, 0x66, 0x28, 0x02, 0x19,
	0x46, 0x7a, 0x64, 0x44, 0x86, 0xbe, 0xe8, 0x0c, 0xc6, 0x4a, 0x3d, 0x90, 0x69, 0xb8, 0xd5, 0xed,
	0x29, 0xd5, 0x09, 0xf7, 0xfb, 0xe0, 0x4e, 0x00, 0xbb, 0x3f, 0x19, 0x74, 0xe3, 0x13, 0xcc, 0xb4,
	0x1d, 0x27, 0xd6, 0x92, 0x3c, 0x70, 0xe0, 0xab, 0x3e, 0x28, 0xcd, 0xde, 0xa5, 0x44, 0x04, 0x4a,
	0xf3, 0xa0, 0x03, 0xca, 0x34, 0x6a, 0x8b, 0xf5, 0xe2, 0xfe, 0x86, 0x3d, 0x4e, 0xdf, 0x6e, 0xa6,
	0xba, 0x7b, 0xaa, 0xeb, 0x4c, 0x80, 0xec, 0x2e, 0xad, 0xa4, 0x21, 0xbb, 0x9d, 0x30, 0xb8, 0x2f,
	0xba, 0xe6, 0x42, 0xcd, 0xa8, 0x17, 0xf7, 0xd7, 0xed, 0x24, 0x55, 0x7b, 0x94, 0xaa, 0x7d, 0x10,
	0x0c, 0x9c, 0x72, 0x8a, 0x3d, 0x44, 0x28, 0xdb, 0xa4, 0x05, 0x0f, 0xbc, 0xbe, 0x74, 0x85, 0x67,
	0x2e, 0xd6, 0x8c, 0x3a, 0x71, 0xf2, 0x78, 0x6f, 0x7a, 0xbb, 0xbf, 0xe7, 0x69, 0x31, 0xe3, 0x92,
	0xbd, 0x41, 0x97, 0x02, 0xde, 0x03, 0xf3, 0x97, 0xdf, 0x7e, 0xdd, 0x45, 0x24, 0x5e, 0x63, 0x0b,
	0x18, 0x62, 0x6c, 0xc1, 0x48, 0x2c, 0xe0, 0xbd, 0xe9, 0xb1, 0x37, 0x69, 0x1e, 0x1b, 0x2b, 0x3c,
	0x0c, 0x89, 0x38, 0xcb, 0xf1, 0xb5, 0xe9, 0xb1, 0xeb, 0xb4, 0x22, 0x79, 0x04, 0x81, 0x76, 0x47,
	0xfa, 0xc4, 0x77, 0x29, 0x91, 0xb6, 0x12, 0xd4, 0x16, 0x25, 0xa8, 0x46, 0xaf, 0x4b, 0x08, 0x28,
	0xc4, 0x82, 0x4f, 0x63, 0xb7, 0x1f, 0x50, 0xaa, 0x34, 0x8f, 0xb4, 0xab, 0x45, 0x0f, 0xcc, 0x2b,
	0x98, 0xf1, 0xb6, 0x2d, 0x94, 0x16, 0xa1, 0x9d, 0xb4, 0xc0, 0x4e, 0x5b, 0x60, 0xb7, 0x45, 0x0f,
	0x5a, 0x9a, 0xf7, 0xa4, 0x43, 0xf0, 0x49, 0x7c, 0x67, 0x77, 0x68, 0x01, 0x02, 0x2f, 0x79, 0xbd,
	0x3c, 0xdf, 0xeb, 0x3c, 0x04, 0x1e, 0xbe, 0x3d, 0x48, 0x03, 0xd3, 0xbc, 0xab, 0xcc, 0x3c, 0xf6,
	0xe9, 0xfa, 0xec, 0x3e, 0xd9, 0x71, 0x2a, 0x6d, 0xde, 0x55, 0x1f, 0x05, 0x3a, 0x1a, 0x24, 0xe1,
	0xc7, 0x57, 0x76, 0x83, 0x56, 0x1e, 0x68, 0x2d, 0x5b, 0x9a, 0xeb, 0xbe, 0x3a, 0x0c, 0x3d, 0x30,
	0x0b, 0x35, 0xa3, 0xbe, 0xe8, 0x4c, 0x49, 0xd9, 0x36, 0x2d, 0x76, 0x7c, 0x31, 0xaa, 0x94, 0x49,
	0x6a, 0x46, 0xbd, 0xe0, 0xd0, 0x44, 0x14, 0xdb, 0x66, 0xb7, 0xe8, 0x46, 0x04, 0x5f, 0x47, 0x42,
	0x83, 0x9b, 0x01, 0xc6, 0x25, 0xa5, 0x88, 0x5d, 0x4b, 0xb5, 0x87, 0xe3, 0x27, 0x4d, 0x2f, 0xb6,
	0xaa, 0xc2, 0x7e, 0xd4, 0x81, 0xa4, 0xb6, 0x45, 0xac, 0x2d, 0x4d, 0x44, 0x58, 0xdd, 0xf7, 0x29,
	0x49, 0x01, 0x42, 0x9a, 0xa5, 0x97, 0x95, 0xa7, 0x79, 0x74, 0xe0, 0x79, 0x11, 0x28, 0xe5, 0x14,
	0x92, 0x17, 0x4d, 0xc9, 0xde, 0xa1, 0xab, 0x1e, 0x28, 0x2d, 0x02, 0xae, 0x45, 0x98, 0xf6, 0xaf,
	0x8c, 0x3e, 0x56, 0x32, 0x72, 0x74, 0xf4, 0x31, 0xad, 0x64, 0xa1, 0x42, 0x9a, 0x95, 0xf9, 0xbc,
	0x95, 0x33, 0xcf, 0x9a, 0x92, 0xed, 0xd0, 0x52, 0x94, 0xb0, 0xc8, 0x55, 0xe2, 0x11, 0x98, 0x2b,
	0x58, 0xcd, 0x62, 0x2a, 0x6b, 0x89, 0x47, 0xc0, 0x6e, 0x52, 0x36, 0x82, 0xe8, 0x50, 0x73, 0x3f,
	0x01, 0xae, 0x22, 0x70, 0x35, 0xd5, 0xb4, 0x63, 0x05, 0xa2, 0xdf, 0xa2, 0xe5, 0x08, 0x94, 0x0c,
	0x03, 0x05, 0x09, 0xf0, 0x2a, 0x02, 0x4b, 0x23, 0x21, 0x82, 0x6c, 0xba, 0x36, 0x06, 0x65, 0x6c,
	0x32, 0x84, 0x5e, 0x1d, 0xa9, 0x26, 0x46, 0x77, 0x68, 0x89, 0x4b, 0xe1, 0x22, 0x21, 0x3b, 0xa1,
	0x6f, 0xae, 0x61, 0x51, 0x8a, 0x5c, 0x8a, 0xa3, 0x54, 0x54, 0xfd, 0x9c, 0x96, 0xff, 0xf3, 0x67,
	0xd8, 0x2a, 0x5d, 0xfc, 0x12, 0x06, 0x29, 0xb5, 0xe2, 0x23, 0xdb, 0xa3, 0x57, 0x70, 0xaa, 0xa4,
	0x3c, 0xdf, 0x9a, 0x5d, 0xaa, 0xcf, 0x62, 0x88, 0x93, 0x20, 0xef, 0x2c, 0xdc, 0x36, 0x76, 0x7f,
	0x34, 0xe8, 0x52, 0x7b, 0x20, 0xe3, 0xaf, 0x7f, 0xe1, 0xfb, 0x5e, 0xcb, 0x7c, 0xdf, 0x18, 0xf3,
	0xa2, 0x7f, 0x5b, 0xfd, 0xe2, 0xd5, 0xe1, 0xbd, 0x97, 0x0d, 0xaf, 0xf2, 0xa2, 0x4e, 0x62, 0x78,
	0xb1, 0xab, 0x6c, 0x88, 0x3f, 0x2c, 0xd3, 0xf2, 0x88, 0x3d, 0x47, 0x3c, 0xe2, 0xbd, 0xff, 0x6b,
	0xba, 0x5c, 0xbb, 0x30, 0x5d, 0x48, 0x76, 0x78, 0x6c, 0x4e, 0x0d, 0x0f, 0x32, 0x99, 0x0d, 0x87,
	0x17, 0x8b, 0x7b, 0x63, 0xc6, 0x6c, 0xc0, 0xec, 0x5e, 0x73, 0x3a, 0x90, 0x79, 0xa6, 0x03, 0x79,
	0x8d, 0xe9, 0x40, 0x2e, 0x39, 0x1d, 0xb6, 0xa6, 0xa7, 0x03, 0xb9, 0x1c, 0xf9, 0xdf, 0x9e, 0x49,
	0x7e, 0x32, 0x0f, 0xb7, 0xc9, 0xbc, 0xdc, 0x26, 0xf3, 0x72, 0x9b, 0xcc, 0xcf, 0x6d, 0x72, 0x49,
	0x6e, 0xdf, 0x7d, 0x35, 0x79, 0xd6, 0xb3, 0xe4, 0x21, 0x19, 0x6e, 0xec, 0x7f, 0x73, 0x61, 0x6d,
	0x68, 0x25, 0x7b, 0x12, 0x03, 0xba, 0x32, 0xa5, 0x61, 0x3b, 0x99, 0x2f, 0x37, 0x7b, 0xd9, 0xa8,
	0x36, 0x52, 0x5e, 0xe2, 0xd2, 0x63, 0xa7, 0x5b, 0x81, 0x8d, 0x4b, 0xcf, 0x98, 0xa4, 0x0e, 0x2e,
	0x3d, 0x0e, 0xa8, 0xbe, 0xaf, 0x3f, 0xbc, 0xf7, 0xe4, 0xcc, 0xca, 0x9d, 0x9e, 0x59, 0xb9, 0xa7,
	0x67, 0x56, 0xee, 0xf9, 0x99, 0x95, 0xfb, 0x76, 0x68, 0x19, 0x3f, 0x0f, 0xad, 0xdc, 0x93, 0xa1,
	0x65, 0x9c, 0x0e, 0x2d, 0xe3, 0xaf, 0xa1, 0x65, 0xfc, 0x3d, 0xb4, 0x72, 0xcf, 0x87, 0x96, 0xf1,
	0xfd, 0xb9, 0x95, 0x3b, 0x3d, 0xb7, 0x72, 0x4f, 0xcf, 0xad, 0xdc, 0x3f, 0x7f, 0x3c, 0x7b, 0xbc,
	0x60, 0x7c, 0xf7, 0xe7, 0xb3, 0xc7, 0x0b, 0x93, 0x65, 0xee, 0x78, 0x19, 0x2b, 0x75, 0xeb, 0xdf,
	0x00, 0x00, 0x00, 0xff, 0xff, 0x50, 0xdf, 0x0e, 0x2c, 0x1a, 0x0a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// HandleTraceSpanServiceClient is the client API for HandleTraceSpanService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type HandleTraceSpanServiceClient interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error)
}

type handleTraceSpanServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleTraceSpanServiceClient(cc *grpc.ClientConn) HandleTraceSpanServiceClient {
	return &handleTraceSpanServiceClient{cc}
}

func (c *handleTraceSpanServiceClient) HandleTraceSpan(ctx context.Context, in *HandleTraceSpanRequest, opts ...grpc.CallOption) (*v1beta11.ReportResult, error) {
	out := new(v1beta11.ReportResult)
	err := c.cc.Invoke(ctx, "/tracespan.HandleTraceSpanService/HandleTraceSpan", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HandleTraceSpanServiceServer is the server API for HandleTraceSpanService service.
type HandleTraceSpanServiceServer interface {
	// HandleTraceSpan is called by Mixer at request-time to deliver 'tracespan' instances to the backend.
	HandleTraceSpan(context.Context, *HandleTraceSpanRequest) (*v1beta11.ReportResult, error)
}

func RegisterHandleTraceSpanServiceServer(s *grpc.Server, srv HandleTraceSpanServiceServer) {
	s.RegisterService(&_HandleTraceSpanService_serviceDesc, srv)
}

func _HandleTraceSpanService_HandleTraceSpan_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleTraceSpanRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/tracespan.HandleTraceSpanService/HandleTraceSpan",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleTraceSpanServiceServer).HandleTraceSpan(ctx, req.(*HandleTraceSpanRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleTraceSpanService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "tracespan.HandleTraceSpanService",
	HandlerType: (*HandleTraceSpanServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleTraceSpan",
			Handler:    _HandleTraceSpanService_HandleTraceSpan_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/tracespan/tracespan_handler_service.proto",
}

func (m *HandleTraceSpanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleTraceSpanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err1 := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err1 != nil {
			return 0, err1
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if m.StartTime != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.StartTime.Size()))
		n2, err2 := m.StartTime.MarshalTo(dAtA[i:])
		if err2 != nil {
			return 0, err2
		}
		i += n2
	}
	if m.EndTime != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.EndTime.Size()))
		n3, err3 := m.EndTime.MarshalTo(dAtA[i:])
		if err3 != nil {
			return 0, err3
		}
		i += n3
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTracespanHandlerService(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + msgSize
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v.Size()))
				n4, err4 := v.MarshalTo(dAtA[i:])
				if err4 != nil {
					return 0, err4
				}
				i += n4
			}
		}
	}
	if m.HttpStatusCode != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.HttpStatusCode))
	}
	if m.ClientSpan {
		dAtA[i] = 0x48
		i++
		if m.ClientSpan {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.RewriteClientSpanId {
		dAtA[i] = 0x50
		i++
		if m.RewriteClientSpanId {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.SourceName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceName)))
		i += copy(dAtA[i:], m.SourceName)
	}
	if m.SourceIp != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.SourceIp.Size()))
		n5, err5 := m.SourceIp.MarshalTo(dAtA[i:])
		if err5 != nil {
			return 0, err5
		}
		i += n5
	}
	if len(m.DestinationName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationName)))
		i += copy(dAtA[i:], m.DestinationName)
	}
	if m.DestinationIp != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.DestinationIp.Size()))
		n6, err6 := m.DestinationIp.MarshalTo(dAtA[i:])
		if err6 != nil {
			return 0, err6
		}
		i += n6
	}
	if m.RequestSize != 0 {
		dAtA[i] = 0x78
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.RequestSize))
	}
	if m.RequestTotalSize != 0 {
		dAtA[i] = 0x80
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.RequestTotalSize))
	}
	if m.ResponseSize != 0 {
		dAtA[i] = 0x88
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.ResponseSize))
	}
	if m.ResponseTotalSize != 0 {
		dAtA[i] = 0x90
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(m.ResponseTotalSize))
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TraceId) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.TraceId)))
		i += copy(dAtA[i:], m.TraceId)
	}
	if len(m.SpanId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanId)))
		i += copy(dAtA[i:], m.SpanId)
	}
	if len(m.ParentSpanId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ParentSpanId)))
		i += copy(dAtA[i:], m.ParentSpanId)
	}
	if len(m.SpanName) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SpanName)))
		i += copy(dAtA[i:], m.SpanName)
	}
	if len(m.StartTime) > 0 {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.StartTime)))
		i += copy(dAtA[i:], m.StartTime)
	}
	if len(m.EndTime) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.EndTime)))
		i += copy(dAtA[i:], m.EndTime)
	}
	if len(m.SpanTags) > 0 {
		for k, _ := range m.SpanTags {
			dAtA[i] = 0x3a
			i++
			v := m.SpanTags[k]
			mapSize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.HttpStatusCode) > 0 {
		dAtA[i] = 0x42
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.HttpStatusCode)))
		i += copy(dAtA[i:], m.HttpStatusCode)
	}
	if len(m.ClientSpan) > 0 {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ClientSpan)))
		i += copy(dAtA[i:], m.ClientSpan)
	}
	if len(m.RewriteClientSpanId) > 0 {
		dAtA[i] = 0x52
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RewriteClientSpanId)))
		i += copy(dAtA[i:], m.RewriteClientSpanId)
	}
	if len(m.SourceName) > 0 {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceName)))
		i += copy(dAtA[i:], m.SourceName)
	}
	if len(m.SourceIp) > 0 {
		dAtA[i] = 0x62
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.SourceIp)))
		i += copy(dAtA[i:], m.SourceIp)
	}
	if len(m.DestinationName) > 0 {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationName)))
		i += copy(dAtA[i:], m.DestinationName)
	}
	if len(m.DestinationIp) > 0 {
		dAtA[i] = 0x72
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.DestinationIp)))
		i += copy(dAtA[i:], m.DestinationIp)
	}
	if len(m.RequestSize) > 0 {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RequestSize)))
		i += copy(dAtA[i:], m.RequestSize)
	}
	if len(m.RequestTotalSize) > 0 {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.RequestTotalSize)))
		i += copy(dAtA[i:], m.RequestTotalSize)
	}
	if len(m.ResponseSize) > 0 {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ResponseSize)))
		i += copy(dAtA[i:], m.ResponseSize)
	}
	if len(m.ResponseTotalSize) > 0 {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ResponseTotalSize)))
		i += copy(dAtA[i:], m.ResponseTotalSize)
	}
	if len(m.ApiProtocol) > 0 {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintTracespanHandlerService(dAtA, i, uint64(len(m.ApiProtocol)))
		i += copy(dAtA[i:], m.ApiProtocol)
	}
	return i, nil
}

func encodeVarintTracespanHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleTraceSpanRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTracespanHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.StartTime != nil {
		l = m.StartTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.EndTime != nil {
		l = m.EndTime.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTracespanHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	if m.HttpStatusCode != 0 {
		n += 1 + sovTracespanHandlerService(uint64(m.HttpStatusCode))
	}
	if m.ClientSpan {
		n += 2
	}
	if m.RewriteClientSpanId {
		n += 2
	}
	l = len(m.SourceName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.SourceIp != nil {
		l = m.SourceIp.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.DestinationIp != nil {
		l = m.DestinationIp.Size()
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if m.RequestSize != 0 {
		n += 1 + sovTracespanHandlerService(uint64(m.RequestSize))
	}
	if m.RequestTotalSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.RequestTotalSize))
	}
	if m.ResponseSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.ResponseSize))
	}
	if m.ResponseTotalSize != 0 {
		n += 2 + sovTracespanHandlerService(uint64(m.ResponseTotalSize))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + sovTracespanHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.TraceId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ParentSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SpanName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.StartTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.EndTime)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	if len(m.SpanTags) > 0 {
		for k, v := range m.SpanTags {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTracespanHandlerService(uint64(len(k))) + 1 + len(v) + sovTracespanHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTracespanHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.HttpStatusCode)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ClientSpan)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RewriteClientSpanId)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SourceName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.SourceIp)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationName)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.DestinationIp)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RequestSize)
	if l > 0 {
		n += 1 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.RequestTotalSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ResponseSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ResponseTotalSize)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	l = len(m.ApiProtocol)
	if l > 0 {
		n += 2 + l + sovTracespanHandlerService(uint64(l))
	}
	return n
}

func sovTracespanHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTracespanHandlerService(x uint64) (n int) {
	return sovTracespanHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleTraceSpanRequest) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForInstances := "[]*InstanceMsg{"
	for _, f := range this.Instances {
		repeatedStringForInstances += strings.Replace(f.String(), "InstanceMsg", "InstanceMsg", 1) + ","
	}
	repeatedStringForInstances += "}"
	s := strings.Join([]string{`&HandleTraceSpanRequest{`,
		`Instances:` + repeatedStringForInstances + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "types.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]*v1beta1.Value{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + strings.Replace(fmt.Sprintf("%v", this.StartTime), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`EndTime:` + strings.Replace(fmt.Sprintf("%v", this.EndTime), "TimeStamp", "v1beta1.TimeStamp", 1) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`HttpStatusCode:` + fmt.Sprintf("%v", this.HttpStatusCode) + `,`,
		`ClientSpan:` + fmt.Sprintf("%v", this.ClientSpan) + `,`,
		`RewriteClientSpanId:` + fmt.Sprintf("%v", this.RewriteClientSpanId) + `,`,
		`SourceName:` + fmt.Sprintf("%v", this.SourceName) + `,`,
		`SourceIp:` + strings.Replace(fmt.Sprintf("%v", this.SourceIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`DestinationName:` + fmt.Sprintf("%v", this.DestinationName) + `,`,
		`DestinationIp:` + strings.Replace(fmt.Sprintf("%v", this.DestinationIp), "IPAddress", "v1beta1.IPAddress", 1) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`RequestTotalSize:` + fmt.Sprintf("%v", this.RequestTotalSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`ResponseTotalSize:` + fmt.Sprintf("%v", this.ResponseTotalSize) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]v1beta1.ValueType{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&Type{`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForSpanTags := make([]string, 0, len(this.SpanTags))
	for k, _ := range this.SpanTags {
		keysForSpanTags = append(keysForSpanTags, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForSpanTags)
	mapStringForSpanTags := "map[string]string{"
	for _, k := range keysForSpanTags {
		mapStringForSpanTags += fmt.Sprintf("%v: %v,", k, this.SpanTags[k])
	}
	mapStringForSpanTags += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`TraceId:` + fmt.Sprintf("%v", this.TraceId) + `,`,
		`SpanId:` + fmt.Sprintf("%v", this.SpanId) + `,`,
		`ParentSpanId:` + fmt.Sprintf("%v", this.ParentSpanId) + `,`,
		`SpanName:` + fmt.Sprintf("%v", this.SpanName) + `,`,
		`StartTime:` + fmt.Sprintf("%v", this.StartTime) + `,`,
		`EndTime:` + fmt.Sprintf("%v", this.EndTime) + `,`,
		`SpanTags:` + mapStringForSpanTags + `,`,
		`HttpStatusCode:` + fmt.Sprintf("%v", this.HttpStatusCode) + `,`,
		`ClientSpan:` + fmt.Sprintf("%v", this.ClientSpan) + `,`,
		`RewriteClientSpanId:` + fmt.Sprintf("%v", this.RewriteClientSpanId) + `,`,
		`SourceName:` + fmt.Sprintf("%v", this.SourceName) + `,`,
		`SourceIp:` + fmt.Sprintf("%v", this.SourceIp) + `,`,
		`DestinationName:` + fmt.Sprintf("%v", this.DestinationName) + `,`,
		`DestinationIp:` + fmt.Sprintf("%v", this.DestinationIp) + `,`,
		`RequestSize:` + fmt.Sprintf("%v", this.RequestSize) + `,`,
		`RequestTotalSize:` + fmt.Sprintf("%v", this.RequestTotalSize) + `,`,
		`ResponseSize:` + fmt.Sprintf("%v", this.ResponseSize) + `,`,
		`ResponseTotalSize:` + fmt.Sprintf("%v", this.ResponseTotalSize) + `,`,
		`ApiProtocol:` + fmt.Sprintf("%v", this.ApiProtocol) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTracespanHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleTraceSpanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleTraceSpanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &types.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StartTime == nil {
				m.StartTime = &v1beta1.TimeStamp{}
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTime == nil {
				m.EndTime = &v1beta1.TimeStamp{}
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]*v1beta1.Value)
			}
			var mapkey string
			var mapvalue *v1beta1.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= int(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if postmsgIndex < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &v1beta1.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpStatusCode", wireType)
			}
			m.HttpStatusCode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.HttpStatusCode |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSpan", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ClientSpan = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RewriteClientSpanId", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RewriteClientSpanId = bool(v != 0)
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SourceIp == nil {
				m.SourceIp = &v1beta1.IPAddress{}
			}
			if err := m.SourceIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DestinationIp == nil {
				m.DestinationIp = &v1beta1.IPAddress{}
			}
			if err := m.DestinationIp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			m.RequestSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTotalSize", wireType)
			}
			m.RequestTotalSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RequestTotalSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			m.ResponseSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTotalSize", wireType)
			}
			m.ResponseTotalSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ResponseTotalSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= v1beta1.ValueType(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TraceId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SpanName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndTime = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanTags", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SpanTags == nil {
				m.SpanTags = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTracespanHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTracespanHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.SpanTags[mapkey] = mapvalue
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpStatusCode", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.HttpStatusCode = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientSpan", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientSpan = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RewriteClientSpanId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RewriteClientSpanId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SourceIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DestinationIp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DestinationIp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestTotalSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestTotalSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseTotalSize", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResponseTotalSize = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiProtocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApiProtocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTracespanHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthTracespanHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTracespanHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTracespanHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTracespanHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthTracespanHandlerService
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthTracespanHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTracespanHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTracespanHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthTracespanHandlerService
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTracespanHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTracespanHandlerService   = fmt.Errorf("proto: integer overflow")
)
