// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/fluentd/config/config.proto

// The `fluentd` adapter is designed to deliver Istio log entries to a
// listening [fluentd](https://www.fluentd.org) daemon.
//
// This adapter supports the [logentry template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/logentry/).

package config

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	_ "github.com/gogo/protobuf/types"
	github_com_gogo_protobuf_types "github.com/gogo/protobuf/types"
	io "io"
	math "math"
	reflect "reflect"
	strings "strings"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration parameters for the fluentd adapter.
//
// This adapter accepts logentry instance. It then routes
// those logentries to a listening fluentd daemon with minimal
// transformation. Fluentd uses a "tag" for all logs. The "Name" of
// the logentry is used as the "tag", unless the logentry already has
// a variable "tag".
type Params struct {
	// Address of listening fluentd daemon. Example: fluentd-server:24224
	// Default value is localhost:24224
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Convert attributes of type duration to integers of unit ms in
	// logs. Default behaviour is a string representation including
	// unit.
	IntegerDuration bool `protobuf:"varint,2,opt,name=integer_duration,json=integerDuration,proto3" json:"integer_duration,omitempty"`
	// Controls the size of the queue of log entries awaiting processing by the
	// data push goroutine. This impacts the overall size of the backlog of
	// log entries that the handler will accept. If the handler falls behind and
	// the number of outstanding instances exceeds this limit, the handler will
	// begin to drop log entries.
	// Defaults to 1024.
	InstanceBufferSize int64 `protobuf:"varint,3,opt,name=instance_buffer_size,json=instanceBufferSize,proto3" json:"instance_buffer_size,omitempty"`
	// Controls the number of data bytes that are encoded and buffered by the handler before
	// they are pushed to the fluentd backend. This impacts the size and frequency of requests
	// sent to the fluentd backend. Once the buffer exceeds this limit, the handler will attempt to push
	// data to the backend.
	// Defaults to 8,388,608 (8 MiB).
	MaxBatchSizeBytes int64 `protobuf:"varint,4,opt,name=max_batch_size_bytes,json=maxBatchSizeBytes,proto3" json:"max_batch_size_bytes,omitempty"`
	// Duration interval for pushing batched data to the fluentd backend. At least once every duration,
	// the handler will attempt to push data.
	// Default to 1m.
	PushIntervalDuration time.Duration `protobuf:"bytes,5,opt,name=push_interval_duration,json=pushIntervalDuration,proto3,stdduration" json:"push_interval_duration"`
	// Timeout duration for pushing batched data to the fluentd backend. If a request takes longer than
	// the configured timeout, the request will be cancelled and dropped.
	// Default to 1m.
	PushTimeoutDuration time.Duration `protobuf:"bytes,6,opt,name=push_timeout_duration,json=pushTimeoutDuration,proto3,stdduration" json:"push_timeout_duration"`
}

func (m *Params) Reset()      { *m = Params{} }
func (*Params) ProtoMessage() {}
func (*Params) Descriptor() ([]byte, []int) {
	return fileDescriptor_b8ce6b52845040ff, []int{0}
}
func (m *Params) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Params) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Params.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalTo(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Params) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Params.Merge(m, src)
}
func (m *Params) XXX_Size() int {
	return m.Size()
}
func (m *Params) XXX_DiscardUnknown() {
	xxx_messageInfo_Params.DiscardUnknown(m)
}

var xxx_messageInfo_Params proto.InternalMessageInfo

func init() {
	proto.RegisterType((*Params)(nil), "adapter.fluentd.config.Params")
}

func init() {
	proto.RegisterFile("mixer/adapter/fluentd/config/config.proto", fileDescriptor_b8ce6b52845040ff)
}

var fileDescriptor_b8ce6b52845040ff = []byte{
	// 381 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x91, 0x3f, 0x4e, 0xe3, 0x40,
	0x14, 0x87, 0x67, 0x92, 0x5d, 0x6f, 0x76, 0xb6, 0xd8, 0x5d, 0xaf, 0x37, 0x32, 0x29, 0x26, 0x16,
	0x95, 0xd3, 0xd8, 0x08, 0x2e, 0x80, 0x2c, 0x1a, 0x3a, 0x64, 0x90, 0x10, 0x34, 0xd6, 0x38, 0x1e,
	0x3b, 0x23, 0xc5, 0x9e, 0x68, 0x3c, 0x46, 0x21, 0x15, 0x47, 0xa0, 0xe4, 0x08, 0x1c, 0x25, 0x65,
	0xca, 0x54, 0x80, 0x1d, 0x0a, 0xca, 0x1c, 0x01, 0xf9, 0x5f, 0xd2, 0x52, 0xd9, 0x33, 0xdf, 0xef,
	0x7d, 0xef, 0x3d, 0x0d, 0x1a, 0xc5, 0x6c, 0x4e, 0x85, 0x4d, 0x02, 0x32, 0x93, 0x54, 0xd8, 0xe1,
	0x34, 0xa3, 0x89, 0x0c, 0xec, 0x31, 0x4f, 0x42, 0x16, 0x35, 0x1f, 0x6b, 0x26, 0xb8, 0xe4, 0x6a,
	0xbf, 0x09, 0x59, 0x4d, 0xc8, 0xaa, 0xe9, 0x40, 0x8b, 0x78, 0xc4, 0xab, 0x88, 0x5d, 0xfe, 0xd5,
	0xe9, 0x01, 0x8e, 0x38, 0x8f, 0xa6, 0xd4, 0xae, 0x4e, 0x7e, 0x16, 0xda, 0x41, 0x26, 0x88, 0x64,
	0x3c, 0xa9, 0xf9, 0xe1, 0x7b, 0x07, 0x29, 0x17, 0x44, 0x90, 0x38, 0x55, 0x75, 0xf4, 0x83, 0x04,
	0x81, 0xa0, 0x69, 0xaa, 0x43, 0x03, 0x9a, 0x3f, 0xdd, 0xf6, 0xa8, 0x8e, 0xd0, 0x1f, 0x96, 0x48,
	0x1a, 0x51, 0xe1, 0xb5, 0xe5, 0x7a, 0xc7, 0x80, 0x66, 0xcf, 0xfd, 0xdd, 0xdc, 0x9f, 0x35, 0xd7,
	0xea, 0x11, 0xd2, 0x58, 0x92, 0x4a, 0x92, 0x8c, 0xa9, 0xe7, 0x67, 0x61, 0x48, 0x85, 0x97, 0xb2,
	0x05, 0xd5, 0xbb, 0x06, 0x34, 0xbb, 0xae, 0xda, 0x32, 0xa7, 0x42, 0x97, 0x6c, 0x41, 0x55, 0x1b,
	0x69, 0x31, 0x99, 0x7b, 0x3e, 0x91, 0xe3, 0x49, 0x95, 0xf5, 0xfc, 0x7b, 0x49, 0x53, 0xfd, 0x5b,
	0x55, 0xf1, 0x37, 0x26, 0x73, 0xa7, 0x44, 0x65, 0xd6, 0x29, 0x81, 0x7a, 0x83, 0xfa, 0xb3, 0x2c,
	0x9d, 0x78, 0x65, 0x6b, 0x71, 0x47, 0xa6, 0xfb, 0x99, 0xbe, 0x1b, 0xd0, 0xfc, 0x75, 0x7c, 0x60,
	0xd5, 0x3b, 0x5b, 0xed, 0xce, 0x56, 0x3b, 0x9d, 0xd3, 0x5b, 0xbe, 0x0c, 0xc1, 0xd3, 0xeb, 0x10,
	0xba, 0x5a, 0xa9, 0x38, 0x6f, 0x0c, 0xbb, 0xe9, 0xaf, 0xd1, 0xff, 0x4a, 0x2d, 0x59, 0x4c, 0x79,
	0x26, 0xf7, 0x66, 0xe5, 0xeb, 0xe6, 0x7f, 0xa5, 0xe1, 0xaa, 0x16, 0xec, 0xf0, 0xe9, 0x32, 0xc7,
	0x60, 0x95, 0x63, 0xb0, 0xce, 0x31, 0xd8, 0xe6, 0x18, 0x3c, 0x14, 0x18, 0x3e, 0x17, 0x18, 0x2c,
	0x0b, 0x0c, 0x57, 0x05, 0x86, 0x6f, 0x05, 0x86, 0x1f, 0x05, 0x06, 0xdb, 0x02, 0xc3, 0xc7, 0x0d,
	0x06, 0xab, 0x0d, 0x06, 0xeb, 0x0d, 0x06, 0xb7, 0x4a, 0xfd, 0xbc, 0xbe, 0x52, 0xf5, 0x3c, 0xf9,
	0x0c, 0x00, 0x00, 0xff, 0xff, 0xe0, 0xbe, 0xb0, 0xfc, 0x2a, 0x02, 0x00, 0x00,
}

func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Address) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.IntegerDuration {
		dAtA[i] = 0x10
		i++
		if m.IntegerDuration {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.InstanceBufferSize != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.InstanceBufferSize))
	}
	if m.MaxBatchSizeBytes != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintConfig(dAtA, i, uint64(m.MaxBatchSizeBytes))
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintConfig(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushIntervalDuration)))
	n1, err1 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.PushIntervalDuration, dAtA[i:])
	if err1 != nil {
		return 0, err1
	}
	i += n1
	dAtA[i] = 0x32
	i++
	i = encodeVarintConfig(dAtA, i, uint64(github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushTimeoutDuration)))
	n2, err2 := github_com_gogo_protobuf_types.StdDurationMarshalTo(m.PushTimeoutDuration, dAtA[i:])
	if err2 != nil {
		return 0, err2
	}
	i += n2
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	if m.IntegerDuration {
		n += 2
	}
	if m.InstanceBufferSize != 0 {
		n += 1 + sovConfig(uint64(m.InstanceBufferSize))
	}
	if m.MaxBatchSizeBytes != 0 {
		n += 1 + sovConfig(uint64(m.MaxBatchSizeBytes))
	}
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushIntervalDuration)
	n += 1 + l + sovConfig(uint64(l))
	l = github_com_gogo_protobuf_types.SizeOfStdDuration(m.PushTimeoutDuration)
	n += 1 + l + sovConfig(uint64(l))
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`Address:` + fmt.Sprintf("%v", this.Address) + `,`,
		`IntegerDuration:` + fmt.Sprintf("%v", this.IntegerDuration) + `,`,
		`InstanceBufferSize:` + fmt.Sprintf("%v", this.InstanceBufferSize) + `,`,
		`MaxBatchSizeBytes:` + fmt.Sprintf("%v", this.MaxBatchSizeBytes) + `,`,
		`PushIntervalDuration:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.PushIntervalDuration), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`PushTimeoutDuration:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.PushTimeoutDuration), "Duration", "types.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntegerDuration", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.IntegerDuration = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InstanceBufferSize", wireType)
			}
			m.InstanceBufferSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InstanceBufferSize |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxBatchSizeBytes", wireType)
			}
			m.MaxBatchSizeBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxBatchSizeBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushIntervalDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.PushIntervalDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTimeoutDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthConfig
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := github_com_gogo_protobuf_types.StdDurationUnmarshal(&m.PushTimeoutDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			iNdEx += length
			if iNdEx < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
				if iNdEx < 0 {
					return 0, ErrInvalidLengthConfig
				}
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)
