/***
	Copyright (c) 2008-2011 CommonsWare, LLC
	Licensed under the Apache License, Version 2.0 (the "License"); you may not
	use this file except in compliance with the License. You may obtain a copy
	of the License at http://www.apache.org/licenses/LICENSE-2.0. Unless required
	by applicable law or agreed to in writing, software distributed under the
	License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
	OF ANY KIND, either express or implied. See the License for the specific
	language governing permissions and limitations under the License.
	
	From _The Busy Coder's Guide to Android Development_
		http://commonsware.com/Android
*/

package com.commonsware.android.contacts.spinners;

import android.app.Activity;
import android.database.Cursor;
import android.provider.ContactsContract.Contacts;
import android.provider.ContactsContract.CommonDataKinds.Email;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.widget.ListAdapter;
import android.widget.SimpleCursorAdapter;

class NewContactsAdapterBridge extends ContactsAdapterBridge {
	ListAdapter buildNameAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts._ID,
																				Contacts.DISPLAY_NAME,
																			};
		Cursor c=a.managedQuery(Contacts.CONTENT_URI,
														PROJECTION, null, null, null);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_1,
																		c,
																		new String[] {
																			Contacts.DISPLAY_NAME
																		},
																		new int[] {
																			android.R.id.text1
																		}));
	}
	
	ListAdapter buildPhonesAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts._ID,
																				Contacts.DISPLAY_NAME,
																				Phone.NUMBER
																			};
		Cursor c=a.managedQuery(Phone.CONTENT_URI,
														PROJECTION, null, null, null);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_2,
																		c,
																		new String[] {
																			Contacts.DISPLAY_NAME,
																			Phone.NUMBER
																		},
																		new int[] {
																			android.R.id.text1,
																			android.R.id.text2
																		}));
	}
	
	ListAdapter buildEmailAdapter(Activity a) {
		String[] PROJECTION=new String[] {	Contacts._ID,
																				Contacts.DISPLAY_NAME,
																				Email.DATA
																			};
		Cursor c=a.managedQuery(Email.CONTENT_URI,
														PROJECTION, null, null, null);
		
		return(new SimpleCursorAdapter( a,
																		android.R.layout.simple_list_item_2,
																		c,
																		new String[] {
																			Contacts.DISPLAY_NAME,
																			Email.DATA
																		},
																		new int[] {
																			android.R.id.text1,
																			android.R.id.text2
																		}));
	}
}