/***
	Copyright (c) 2008-2011 CommonsWare, LLC
	Licensed under the Apache License, Version 2.0 (the "License"); you may not
	use this file except in compliance with the License. You may obtain a copy
	of the License at http://www.apache.org/licenses/LICENSE-2.0. Unless required
	by applicable law or agreed to in writing, software distributed under the
	License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
	OF ANY KIND, either express or implied. See the License for the specific
	language governing permissions and limitations under the License.
	
	From _The Busy Coder's Guide to Android Development_
		http://commonsware.com/Android
*/

package com.commonsware.android.contacts.spinners;

import android.app.Activity;
import android.os.Build;
import android.widget.ListAdapter;

abstract class ContactsAdapterBridge {
	abstract ListAdapter buildNameAdapter(Activity a);
	abstract ListAdapter buildPhonesAdapter(Activity a);
	abstract ListAdapter buildEmailAdapter(Activity a);
	
	public static final ContactsAdapterBridge INSTANCE=buildBridge();
	
	private static ContactsAdapterBridge buildBridge() {
		int sdk=new Integer(Build.VERSION.SDK).intValue();
		
		if (sdk<5) {
			return(new OldContactsAdapterBridge());
		}
		
		return(new NewContactsAdapterBridge());
	}
}