/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.app.Activity;
import android.os.Build;
import android.util.Log;
import android.webkit.WebView;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContactAccessor {
    private static ContactAccessor sInstance;
    protected final String LOG_TAG = "ContactsAccessor";
    protected Activity mApp;
    protected WebView mView;

    public static ContactAccessor getInstance(WebView view, Activity app) {
        if (sInstance == null) {
            String className = Build.VERSION.RELEASE.startsWith("1.") ? "com.phonegap.ContactAccessorSdk3_4" : "com.phonegap.ContactAccessorSdk5";
            try {
                Class<ContactAccessor> clazz = Class.forName(className).asSubclass(ContactAccessor.class);
                Constructor<ContactAccessor> classConstructor = clazz.getConstructor(Class.forName("android.webkit.WebView"), Class.forName("android.app.Activity"));
                sInstance = classConstructor.newInstance(view, app);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return sInstance;
    }

    protected boolean isRequired(String key, HashMap<String, Boolean> map) {
        Boolean retVal = map.get(key);
        return retVal == null ? false : retVal;
    }

    protected HashMap<String, Boolean> buildPopulationSet(JSONArray fields) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            for (int i = 0; i < fields.length(); ++i) {
                String key = fields.getString(i);
                if (key.startsWith("displayName")) {
                    map.put("displayName", true);
                    continue;
                }
                if (key.startsWith("name")) {
                    map.put("name", true);
                    continue;
                }
                if (key.startsWith("nickname")) {
                    map.put("nickname", true);
                    continue;
                }
                if (key.startsWith("phoneNumbers")) {
                    map.put("phoneNumbers", true);
                    continue;
                }
                if (key.startsWith("emails")) {
                    map.put("emails", true);
                    continue;
                }
                if (key.startsWith("addresses")) {
                    map.put("addresses", true);
                    continue;
                }
                if (key.startsWith("ims")) {
                    map.put("ims", true);
                    continue;
                }
                if (key.startsWith("organizations")) {
                    map.put("organizations", true);
                    continue;
                }
                if (key.startsWith("birthday")) {
                    map.put("birthday", true);
                    continue;
                }
                if (key.startsWith("anniversary")) {
                    map.put("anniversary", true);
                    continue;
                }
                if (key.startsWith("note")) {
                    map.put("note", true);
                    continue;
                }
                if (key.startsWith("relationships")) {
                    map.put("relationships", true);
                    continue;
                }
                if (key.startsWith("urls")) {
                    map.put("urls", true);
                    continue;
                }
                if (!key.startsWith("photos")) continue;
                map.put("photos", true);
            }
        }
        catch (JSONException e) {
            Log.e((String)"ContactsAccessor", (String)e.getMessage(), (Throwable)e);
        }
        return map;
    }

    protected String getJsonString(JSONObject obj, String property) {
        String value = null;
        try {
            value = obj.getString(property);
            if (value.equals("null")) {
                Log.d((String)"ContactsAccessor", (String)(property + " is string called 'null'"));
                value = null;
            }
        }
        catch (JSONException e) {
            Log.d((String)"ContactsAccessor", (String)("Could not get = " + e.getMessage()));
        }
        return value;
    }

    public abstract boolean save(JSONObject var1);

    public abstract JSONArray search(JSONArray var1, JSONObject var2);

    public abstract boolean remove(String var1);

    class WhereOptions {
        private String where;
        private String[] whereArgs;

        WhereOptions() {
        }

        public void setWhere(String where) {
            this.where = where;
        }

        public String getWhere() {
            return this.where;
        }

        public void setWhereArgs(String[] whereArgs) {
            this.whereArgs = whereArgs;
        }

        public String[] getWhereArgs() {
            return this.whereArgs;
        }
    }
}

