/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.loaderex.acl;

import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.AsyncTaskLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursorLoader
extends AsyncTaskLoader<Cursor> {
    Cursor lastCursor = null;

    protected abstract Cursor buildCursor();

    public AbstractCursorLoader(Context context) {
        super(context);
    }

    public Cursor loadInBackground() {
        Cursor cursor = this.buildCursor();
        if (cursor != null) {
            cursor.getCount();
        }
        return cursor;
    }

    public void deliverResult(Cursor cursor) {
        if (this.isReset()) {
            if (cursor != null) {
                cursor.close();
            }
            return;
        }
        Cursor oldCursor = this.lastCursor;
        this.lastCursor = cursor;
        if (this.isStarted()) {
            super.deliverResult((Object)cursor);
        }
        if (oldCursor != null && oldCursor != cursor && !oldCursor.isClosed()) {
            oldCursor.close();
        }
    }

    protected void onStartLoading() {
        if (this.lastCursor != null) {
            this.deliverResult(this.lastCursor);
        }
        if (this.takeContentChanged() || this.lastCursor == null) {
            this.forceLoad();
        }
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public void onCanceled(Cursor cursor) {
        if (cursor != null && !cursor.isClosed()) {
            cursor.close();
        }
    }

    protected void onReset() {
        super.onReset();
        this.onStopLoading();
        if (this.lastCursor != null && !this.lastCursor.isClosed()) {
            this.lastCursor.close();
        }
        this.lastCursor = null;
    }
}

