/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.loaderex.acl;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.support.v4.content.Loader;
import com.commonsware.cwac.loaderex.acl.AbstractCursorLoader;
import com.commonsware.cwac.loaderex.acl.ContentChangingTask;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Arrays;
import net.sqlcipher.database.SQLiteDatabase;

public class SQLCipherCursorLoader
extends AbstractCursorLoader {
    SQLiteDatabase db = null;
    String rawQuery = null;
    String[] args = null;

    public SQLCipherCursorLoader(Context context, SQLiteDatabase db, String rawQuery, String[] args) {
        super(context);
        this.db = db;
        this.rawQuery = rawQuery;
        this.args = args;
    }

    protected Cursor buildCursor() {
        return this.db.rawQuery(this.rawQuery, this.args);
    }

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        writer.print(prefix);
        writer.print("rawQuery=");
        writer.println(this.rawQuery);
        writer.print(prefix);
        writer.print("args=");
        writer.println(Arrays.toString(args));
    }

    public void insert(String table, String nullColumnHack, ContentValues values) {
        this.buildInsertTask(this).execute(new Object[]{this.db, table, nullColumnHack, values});
    }

    public void update(String table, ContentValues values, String whereClause, String[] whereArgs) {
        this.buildUpdateTask(this).execute(new Object[]{this.db, table, values, whereClause, whereArgs});
    }

    public void replace(String table, String nullColumnHack, ContentValues values) {
        this.buildReplaceTask(this).execute(new Object[]{this.db, table, nullColumnHack, values});
    }

    public void delete(String table, String whereClause, String[] whereArgs) {
        this.buildDeleteTask(this).execute(new Object[]{this.db, table, whereClause, whereArgs});
    }

    public void execSQL(String sql, Object[] bindArgs) {
        this.buildExecSQLTask(this).execute(new Object[]{this.db, sql, bindArgs});
    }

    protected ContentChangingTask buildInsertTask(SQLCipherCursorLoader loader) {
        return new InsertTask(loader);
    }

    protected ContentChangingTask buildUpdateTask(SQLCipherCursorLoader loader) {
        return new UpdateTask(loader);
    }

    protected ContentChangingTask buildReplaceTask(SQLCipherCursorLoader loader) {
        return new ReplaceTask(loader);
    }

    protected ContentChangingTask buildDeleteTask(SQLCipherCursorLoader loader) {
        return new DeleteTask(loader);
    }

    protected ContentChangingTask buildExecSQLTask(SQLCipherCursorLoader loader) {
        return new ExecSQLTask(loader);
    }

    protected static class ExecSQLTask
    extends ContentChangingTask {
        ExecSQLTask(SQLCipherCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteDatabase db = (SQLiteDatabase)params[0];
            String sql = (String)params[1];
            Object[] bindParams = (Object[])params[2];
            db.execSQL(sql, bindParams);
            return null;
        }
    }

    protected static class DeleteTask
    extends ContentChangingTask {
        DeleteTask(SQLCipherCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteDatabase db = (SQLiteDatabase)params[0];
            String table = (String)params[1];
            String where = (String)params[2];
            String[] whereParams = (String[])params[3];
            db.delete(table, where, whereParams);
            return null;
        }
    }

    protected static class ReplaceTask
    extends ContentChangingTask {
        ReplaceTask(SQLCipherCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteDatabase db = (SQLiteDatabase)params[0];
            String table = (String)params[1];
            String nullColumnHack = (String)params[2];
            ContentValues values = (ContentValues)params[3];
            db.replace(table, nullColumnHack, values);
            return null;
        }
    }

    protected static class UpdateTask
    extends ContentChangingTask {
        UpdateTask(SQLCipherCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteDatabase db = (SQLiteDatabase)params[0];
            String table = (String)params[1];
            ContentValues values = (ContentValues)params[2];
            String where = (String)params[3];
            String[] whereParams = (String[])params[4];
            db.update(table, values, where, whereParams);
            return null;
        }
    }

    protected static class InsertTask
    extends ContentChangingTask {
        InsertTask(SQLCipherCursorLoader loader) {
            super((Loader<?>)loader);
        }

        protected Void doInBackground(Object ... params) {
            SQLiteDatabase db = (SQLiteDatabase)params[0];
            String table = (String)params[1];
            String nullColumnHack = (String)params[2];
            ContentValues values = (ContentValues)params[3];
            db.insert(table, nullColumnHack, values);
            return null;
        }
    }
}

