/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.xml.impl.xmlbeans.LogicalEquality;
import org.mozilla.javascript.xml.impl.xmlbeans.Namespace;
import org.mozilla.javascript.xml.impl.xmlbeans.NamespaceHelper;
import org.mozilla.javascript.xml.impl.xmlbeans.QName;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLLibImpl;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLList;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLName;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLObjectImpl;

class XML
extends XMLObjectImpl {
    static final long serialVersionUID = -630969919086449092L;
    private XScriptAnnotation _anno;
    private static final int APPEND_CHILD = 1;
    private static final int PREPEND_CHILD = 2;

    private XML(XMLLibImpl xMLLibImpl, XScriptAnnotation xScriptAnnotation) {
        super(xMLLibImpl, xMLLibImpl.xmlPrototype);
        this._anno = xScriptAnnotation;
        this._anno._xScriptXML = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createEmptyXML(XMLLibImpl xMLLibImpl) {
        XScriptAnnotation xScriptAnnotation;
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        try {
            xScriptAnnotation = new XScriptAnnotation(xmlCursor);
            xmlCursor.setBookmark((XmlCursor.XmlBookmark)xScriptAnnotation);
        }
        finally {
            xmlCursor.dispose();
        }
        return new XML(xMLLibImpl, xScriptAnnotation);
    }

    private static XML createXML(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        if (xmlCursor.currentTokenType().isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        XScriptAnnotation xScriptAnnotation = XML.findAnnotation(xmlCursor);
        return new XML(xMLLibImpl, xScriptAnnotation);
    }

    private static XML createAttributeXML(XMLLibImpl xMLLibImpl, XmlCursor xmlCursor) {
        if (!xmlCursor.isAttr()) {
            throw new IllegalArgumentException();
        }
        XScriptAnnotation xScriptAnnotation = new XScriptAnnotation(xmlCursor);
        xmlCursor.setBookmark((XmlCursor.XmlBookmark)xScriptAnnotation);
        return new XML(xMLLibImpl, xScriptAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createTextElement(XMLLibImpl xMLLibImpl, javax.xml.namespace.QName qName, String string) {
        XScriptAnnotation xScriptAnnotation;
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        try {
            xmlCursor.toNextToken();
            xmlCursor.beginElement(qName.getLocalPart(), qName.getNamespaceURI());
            xmlCursor.insertChars(string);
            xmlCursor.toStartDoc();
            xmlCursor.toNextToken();
            xScriptAnnotation = new XScriptAnnotation(xmlCursor);
            xmlCursor.setBookmark((XmlCursor.XmlBookmark)xScriptAnnotation);
        }
        finally {
            xmlCursor.dispose();
        }
        return new XML(xMLLibImpl, xScriptAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createFromXmlObject(XMLLibImpl xMLLibImpl, XmlObject xmlObject) {
        XScriptAnnotation xScriptAnnotation;
        XmlCursor xmlCursor = xmlObject.newCursor();
        if (xmlCursor.currentTokenType().isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        try {
            xScriptAnnotation = new XScriptAnnotation(xmlCursor);
            xmlCursor.setBookmark((XmlCursor.XmlBookmark)xScriptAnnotation);
        }
        finally {
            xmlCursor.dispose();
        }
        return new XML(xMLLibImpl, xScriptAnnotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XML createFromJS(XMLLibImpl xMLLibImpl, Object object) {
        Object object2;
        Context context;
        XmlObject xmlObject;
        Object object3;
        String string;
        boolean bl = false;
        if (object == null || object == Undefined.instance) {
            string = "";
        } else if (object instanceof XMLObjectImpl) {
            string = ((XMLObjectImpl)object).toXMLString(0);
        } else {
            if (object instanceof Wrapper && (object3 = ((Wrapper)object).unwrap()) instanceof XmlObject) {
                return XML.createFromXmlObject(xMLLibImpl, (XmlObject)object3);
            }
            string = ScriptRuntime.toString(object);
        }
        if (string.trim().startsWith("<>")) {
            throw ScriptRuntime.typeError("Invalid use of XML object anonymous tags <></>.");
        }
        if (string.indexOf("<") == -1) {
            bl = true;
            string = "<textFragment>" + string + "</textFragment>";
        }
        object3 = new XmlOptions();
        if (xMLLibImpl.ignoreComments) {
            object3.put((Object)"LOAD_STRIP_COMMENTS");
        }
        if (xMLLibImpl.ignoreProcessingInstructions) {
            object3.put((Object)"LOAD_STRIP_PROCINSTS");
        }
        if (xMLLibImpl.ignoreWhitespace) {
            object3.put((Object)"LOAD_STRIP_WHITESPACE");
        }
        try {
            xmlObject = XmlObject.Factory.parse((String)string, (XmlOptions)object3);
            context = Context.getCurrentContext();
            object2 = xMLLibImpl.getDefaultNamespaceURI(context);
            if (((String)object2).length() > 0) {
                XmlCursor xmlCursor = xmlObject.newCursor();
                boolean bl2 = true;
                while (!xmlCursor.toNextToken().isEnddoc()) {
                    if (!xmlCursor.isStart()) continue;
                    boolean bl3 = false;
                    xmlCursor.push();
                    while (xmlCursor.toNextToken().isAnyAttr()) {
                        if (!xmlCursor.isNamespace() || xmlCursor.getName().getLocalPart().length() != 0) continue;
                        bl3 = true;
                        break;
                    }
                    xmlCursor.pop();
                    if (bl3) {
                        xmlCursor.toEndToken();
                        continue;
                    }
                    javax.xml.namespace.QName qName = xmlCursor.getName();
                    if (qName.getNamespaceURI().length() == 0) {
                        qName = new javax.xml.namespace.QName((String)object2, qName.getLocalPart());
                        xmlCursor.setName(qName);
                    }
                    if (!bl2) continue;
                    xmlCursor.push();
                    xmlCursor.toNextToken();
                    xmlCursor.insertNamespace("", (String)object2);
                    xmlCursor.pop();
                    bl2 = false;
                }
                xmlCursor.dispose();
            }
        }
        catch (XmlException xmlException) {
            object2 = xmlException.getMessage();
            if (((String)object2).equals("error: Unexpected end of file after null")) {
                xmlObject = XmlObject.Factory.newInstance();
            }
            throw ScriptRuntime.typeError(xmlException.getMessage());
        }
        catch (Throwable throwable) {
            throw ScriptRuntime.typeError("Not Parsable as XML");
        }
        context = xmlObject.newCursor();
        if (context.currentTokenType().isStartdoc()) {
            context.toFirstContentToken();
        }
        if (bl) {
            context.toFirstContentToken();
        }
        try {
            object2 = new XScriptAnnotation((XmlCursor)context);
            context.setBookmark((XmlCursor.XmlBookmark)object2);
        }
        finally {
            context.dispose();
        }
        return new XML(xMLLibImpl, (XScriptAnnotation)object2);
    }

    static XML getFromAnnotation(XMLLibImpl xMLLibImpl, XScriptAnnotation xScriptAnnotation) {
        if (xScriptAnnotation._xScriptXML == null) {
            xScriptAnnotation._xScriptXML = new XML(xMLLibImpl, xScriptAnnotation);
        }
        return xScriptAnnotation._xScriptXML;
    }

    private static XmlCursor.TokenType skipNonElements(XmlCursor xmlCursor) {
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        while (tokenType.isComment() || tokenType.isProcinst()) {
            tokenType = xmlCursor.toNextToken();
        }
        return tokenType;
    }

    protected static XScriptAnnotation findAnnotation(XmlCursor xmlCursor) {
        XmlCursor.XmlBookmark xmlBookmark = xmlCursor.getBookmark(XScriptAnnotation.class);
        if (xmlBookmark == null) {
            xmlBookmark = new XScriptAnnotation(xmlCursor);
            xmlCursor.setBookmark(xmlBookmark);
        }
        return (XScriptAnnotation)xmlBookmark;
    }

    private XmlOptions getOptions() {
        XmlOptions xmlOptions = new XmlOptions();
        if (this.lib.ignoreComments) {
            xmlOptions.put((Object)"LOAD_STRIP_COMMENTS");
        }
        if (this.lib.ignoreProcessingInstructions) {
            xmlOptions.put((Object)"LOAD_STRIP_PROCINSTS");
        }
        if (this.lib.ignoreWhitespace) {
            xmlOptions.put((Object)"LOAD_STRIP_WHITESPACE");
        }
        if (this.lib.prettyPrinting) {
            xmlOptions.put((Object)"SAVE_PRETTY_PRINT", null);
            xmlOptions.put((Object)"SAVE_PRETTY_PRINT_INDENT", (Object)new Integer(this.lib.prettyIndent));
        }
        return xmlOptions;
    }

    private static String dumpNode(XmlCursor xmlCursor, XmlOptions xmlOptions) {
        if (xmlCursor.isText()) {
            return xmlCursor.getChars();
        }
        if (xmlCursor.isFinish()) {
            return "";
        }
        xmlCursor.push();
        boolean bl = xmlCursor.isStartdoc() && !xmlCursor.toFirstChild();
        xmlCursor.pop();
        return bl ? xmlCursor.getTextValue() : xmlCursor.xmlText(xmlOptions);
    }

    private XmlCursor newCursor() {
        XmlCursor xmlCursor;
        if (this._anno != null) {
            xmlCursor = this._anno.createCursor();
            if (xmlCursor == null) {
                XmlObject xmlObject = XmlObject.Factory.newInstance();
                xmlCursor = xmlObject.newCursor();
                if (this._anno._name != null) {
                    xmlCursor.toNextToken();
                    xmlCursor.insertElement(this._anno._name);
                    xmlCursor.toPrevSibling();
                }
                xmlCursor.setBookmark((XmlCursor.XmlBookmark)this._anno);
            }
        } else {
            XmlObject xmlObject = XmlObject.Factory.newInstance();
            xmlCursor = xmlObject.newCursor();
        }
        return xmlCursor;
    }

    private boolean moveToChild(XmlCursor xmlCursor, long l, boolean bl, boolean bl2) {
        block11: {
            XmlCursor.TokenType tokenType;
            if (l < 0L) {
                throw new IllegalArgumentException();
            }
            long l2 = 0L;
            if (!bl2 && xmlCursor.currentTokenType().isStartdoc()) {
                xmlCursor.toFirstContentToken();
            }
            if (!(tokenType = xmlCursor.toFirstContentToken()).isNone() && !tokenType.isEnd()) {
                while (true) {
                    if (l == l2) {
                        return true;
                    }
                    tokenType = xmlCursor.currentTokenType();
                    if (tokenType.isText()) {
                        xmlCursor.toNextToken();
                    } else if (tokenType.isStart()) {
                        xmlCursor.toEndToken();
                        xmlCursor.toNextToken();
                    } else {
                        if (tokenType.isComment() || tokenType.isProcinst()) {
                            continue;
                        }
                        break block11;
                    }
                    ++l2;
                }
            }
            if (bl && l == 0L) {
                return true;
            }
        }
        return false;
    }

    XmlCursor.TokenType tokenType() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        xmlCursor.dispose();
        return tokenType;
    }

    private boolean moveSrcToDest(XmlCursor xmlCursor, XmlCursor xmlCursor2, boolean bl) {
        XmlCursor.TokenType tokenType;
        boolean bl2 = true;
        do {
            if (bl && xmlCursor.isInSameDocument(xmlCursor2) && xmlCursor.comparePosition(xmlCursor2) == 0) {
                bl2 = false;
                break;
            }
            if (xmlCursor2.currentTokenType().isStartdoc()) {
                xmlCursor2.toNextToken();
            }
            XmlCursor xmlCursor3 = this.copy(xmlCursor);
            xmlCursor3.moveXml(xmlCursor2);
            xmlCursor3.dispose();
        } while (!(tokenType = xmlCursor.currentTokenType()).isStart() && !tokenType.isEnd() && !tokenType.isEnddoc());
        return bl2;
    }

    /*
     * Unable to fully structure code
     */
    private XmlCursor copy(XmlCursor var1_1) {
        var2_2 = XmlObject.Factory.newInstance();
        var3_3 = null;
        if (var1_1.currentTokenType().isText()) {
            try {
                var3_3 = XmlObject.Factory.parse((String)("<x:fragment xmlns:x=\"http://www.openuri.org/fragment\">" + var1_1.getChars() + "</x:fragment>")).newCursor();
                if (var1_1.toNextSibling() || !var1_1.currentTokenType().isText()) ** GOTO lbl23
                var1_1.toNextToken();
            }
            catch (Exception var4_4) {
                throw ScriptRuntime.typeError(var4_4.getMessage());
            }
        } else {
            var3_3 = var2_2.newCursor();
            var3_3.toFirstContentToken();
            if (var1_1.currentTokenType() == XmlCursor.TokenType.STARTDOC) {
                var1_1.toNextToken();
            }
            var1_1.copyXml(var3_3);
            if (!var1_1.toNextSibling() && var1_1.currentTokenType().isText()) {
                var1_1.toNextToken();
            }
        }
lbl23:
        // 5 sources

        var3_3.toStartDoc();
        var3_3.toFirstContentToken();
        return var3_3;
    }

    private void insertChild(XmlCursor xmlCursor, Object object) {
        if (object != null && !(object instanceof Undefined)) {
            if (object instanceof XmlCursor) {
                this.moveSrcToDest((XmlCursor)object, xmlCursor, true);
            } else if (object instanceof XML) {
                XML xML = (XML)object;
                if (xML.tokenType() == XmlCursor.TokenType.ATTR) {
                    this.insertChild(xmlCursor, xML.toString());
                } else {
                    XmlCursor xmlCursor2 = ((XML)object).newCursor();
                    this.moveSrcToDest(xmlCursor2, xmlCursor, true);
                    xmlCursor2.dispose();
                }
            } else if (object instanceof XMLList) {
                XMLList xMLList = (XMLList)object;
                for (int i = 0; i < xMLList.length(); ++i) {
                    this.insertChild(xmlCursor, xMLList.item(i));
                }
            } else {
                String string = ScriptRuntime.toString(object);
                XmlObject xmlObject = XmlObject.Factory.newInstance();
                XmlCursor xmlCursor3 = xmlObject.newCursor();
                xmlCursor3.toNextToken();
                xmlCursor3.insertChars(string);
                xmlCursor3.toPrevToken();
                this.moveSrcToDest(xmlCursor3, xmlCursor, true);
            }
        }
    }

    private void insertChild(XML xML, Object object, int n) {
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        XmlCursor xmlCursor2 = xML.newCursor();
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isContainer()) {
            tokenType = xmlCursor.toNextToken();
            while (!tokenType.isEnd()) {
                if (tokenType.isStart() && xmlCursor.comparePosition(xmlCursor2) == 0) {
                    if (n == 1) {
                        xmlCursor.toEndToken();
                        xmlCursor.toNextToken();
                    }
                    this.insertChild(xmlCursor, object);
                    break;
                }
                if (tokenType.isStart()) {
                    tokenType = xmlCursor.toEndToken();
                }
                tokenType = xmlCursor.toNextToken();
            }
        }
        xmlCursor2.dispose();
        xmlCursor.dispose();
    }

    protected void removeToken(XmlCursor xmlCursor) {
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor2 = xmlObject.newCursor();
        xmlCursor2.toFirstContentToken();
        xmlCursor.moveXml(xmlCursor2);
        xmlCursor2.dispose();
    }

    protected void removeChild(long l) {
        XmlCursor xmlCursor = this.newCursor();
        if (this.moveToChild(xmlCursor, l, false, false)) {
            this.removeToken(xmlCursor);
        }
        xmlCursor.dispose();
    }

    protected static javax.xml.namespace.QName computeQName(Object object) {
        if (object instanceof String) {
            int n;
            String string;
            String string2 = null;
            String string3 = null;
            string3 = string = (String)object;
            if (string.startsWith("\"") && (n = string.indexOf(":")) != -1) {
                string2 = string.substring(1, n - 1);
                string3 = string.substring(n + 1);
            }
            if (string2 == null) {
                return new javax.xml.namespace.QName(string3);
            }
            return new javax.xml.namespace.QName(string2, string3);
        }
        return null;
    }

    private void replace(XmlCursor xmlCursor, XML xML) {
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        this.removeToken(xmlCursor);
        XmlCursor xmlCursor2 = xML.newCursor();
        if (xmlCursor2.currentTokenType().isStartdoc()) {
            xmlCursor2.toFirstContentToken();
        }
        this.moveSrcToDest(xmlCursor2, xmlCursor, false);
        if (!xmlCursor.toPrevSibling()) {
            xmlCursor.toPrevToken();
        }
        xmlCursor.setBookmark((XmlCursor.XmlBookmark)new XScriptAnnotation(xmlCursor));
        xmlCursor.toEndToken();
        xmlCursor.toNextToken();
        xmlCursor2.dispose();
    }

    private boolean doPut(XMLName xMLName, XML xML, XMLObjectImpl xMLObjectImpl) {
        boolean bl = false;
        XmlCursor xmlCursor = xML.newCursor();
        try {
            int n = xMLObjectImpl.length();
            for (int i = 0; i < n; ++i) {
                XML xML2 = xMLObjectImpl instanceof XMLList ? ((XMLList)xMLObjectImpl).item(i) : (XML)xMLObjectImpl;
                XmlCursor.TokenType tokenType = xML2.tokenType();
                if (tokenType == XmlCursor.TokenType.ATTR || tokenType == XmlCursor.TokenType.TEXT) {
                    xML2 = this.makeXmlFromString(this.lib, xMLName, xML2.toString());
                }
                if (i == 0) {
                    this.replace(xmlCursor, xML2);
                    continue;
                }
                this.insertChild(xmlCursor, xML2);
            }
            bl = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw ScriptRuntime.typeError(exception.getMessage());
        }
        finally {
            xmlCursor.dispose();
        }
        return bl;
    }

    private XML makeXmlFromString(XMLLibImpl xMLLibImpl, XMLName xMLName, String string) {
        javax.xml.namespace.QName qName;
        try {
            qName = new javax.xml.namespace.QName(xMLName.uri(), xMLName.localName());
        }
        catch (Exception exception) {
            throw ScriptRuntime.typeError(exception.getMessage());
        }
        XML xML = XML.createTextElement(xMLLibImpl, qName, string);
        return xML;
    }

    private XMLList matchAttributes(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.currentTokenType().isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        if (xmlCursor.isStart() && xmlCursor.toFirstAttribute()) {
            do {
                if (!this.qnameMatches(xMLName, xmlCursor.getName())) continue;
                xMLList.addToList(this.createAttributeObject(xmlCursor));
            } while (xmlCursor.toNextAttribute());
        }
        xmlCursor.dispose();
        return xMLList;
    }

    private XML createAttributeObject(XmlCursor xmlCursor) {
        XML xML = null;
        if (xmlCursor.currentTokenType().isAttr()) {
            xML = XML.createAttributeXML(this.lib, xmlCursor);
        }
        return xML;
    }

    public String getClassName() {
        return "XML";
    }

    public Object get(int n, Scriptable scriptable) {
        if (n == 0) {
            return this;
        }
        return Scriptable.NOT_FOUND;
    }

    boolean hasXMLProperty(XMLName xMLName) {
        boolean bl = false;
        if (this.prototypeFlag) {
            String string = xMLName.localName();
            if (this.getMethod(string) != NOT_FOUND) {
                bl = true;
            }
        } else {
            String string = xMLName.localName();
            if (this.getPropertyList(xMLName).length() > 0 || this.getMethod(string) != NOT_FOUND) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean has(int n, Scriptable scriptable) {
        return n == 0;
    }

    public Object[] getIds() {
        Object[] objectArray = this.prototypeFlag ? new Object[]{} : new Object[]{new Integer(0)};
        return objectArray;
    }

    public Object[] getIdsForDebug() {
        return this.getIds();
    }

    Object getXMLProperty(XMLName xMLName) {
        Object object = NOT_FOUND;
        if (this.prototypeFlag) {
            String string = xMLName.localName();
            object = this.getMethod(string);
        } else {
            object = this.getPropertyList(xMLName);
        }
        return object;
    }

    void putXMLProperty(XMLName xMLName, Object object) {
        if (!this.prototypeFlag) {
            if (object == null) {
                object = "null";
            } else if (object instanceof Undefined) {
                object = "undefined";
            }
            if (xMLName.isAttributeName()) {
                this.setAttribute(xMLName, object);
            } else if (xMLName.uri() == null && xMLName.localName().equals("*")) {
                this.setChildren(object);
            } else {
                XMLList xMLList;
                XMLObjectImpl xMLObjectImpl = null;
                if (object instanceof XMLObjectImpl) {
                    xMLObjectImpl = (XMLObjectImpl)object;
                    if (xMLObjectImpl instanceof XML && ((XML)xMLObjectImpl).tokenType() == XmlCursor.TokenType.ATTR) {
                        xMLObjectImpl = this.makeXmlFromString(this.lib, xMLName, xMLObjectImpl.toString());
                    }
                    if (xMLObjectImpl instanceof XMLList) {
                        for (int i = 0; i < xMLObjectImpl.length(); ++i) {
                            XML xML = ((XMLList)xMLObjectImpl).item(i);
                            if (xML.tokenType() != XmlCursor.TokenType.ATTR) continue;
                            ((XMLList)xMLObjectImpl).replace(i, this.makeXmlFromString(this.lib, xMLName, xML.toString()));
                        }
                    }
                } else {
                    xMLObjectImpl = this.makeXmlFromString(this.lib, xMLName, ScriptRuntime.toString(object));
                }
                if ((xMLList = this.getPropertyList(xMLName)).length() == 0) {
                    this.appendChild(xMLObjectImpl);
                } else {
                    for (int i = 1; i < xMLList.length(); ++i) {
                        this.removeChild(xMLList.item(i).childIndex());
                    }
                    this.doPut(xMLName, xMLList.item(0), xMLObjectImpl);
                }
            }
        }
    }

    public void put(int n, Scriptable scriptable, Object object) {
        throw ScriptRuntime.typeError("Assignment to indexed XML is not allowed");
    }

    void deleteXMLProperty(XMLName xMLName) {
        if (!xMLName.isDescendants() && xMLName.isAttributeName()) {
            XmlCursor xmlCursor = this.newCursor();
            if (xMLName.localName().equals("*")) {
                if (xmlCursor.toFirstAttribute()) {
                    while (xmlCursor.currentTokenType().isAttr()) {
                        xmlCursor.removeXml();
                    }
                }
            } else {
                javax.xml.namespace.QName qName = new javax.xml.namespace.QName(xMLName.uri(), xMLName.localName());
                xmlCursor.removeAttribute(qName);
            }
            xmlCursor.dispose();
        } else {
            XMLList xMLList = this.getPropertyList(xMLName);
            xMLList.remove();
        }
    }

    public void delete(int n) {
        if (n == 0) {
            this.remove();
        }
    }

    protected XScriptAnnotation getAnnotation() {
        return this._anno;
    }

    protected void changeNS(String string, String string2) {
        XmlCursor xmlCursor = this.newCursor();
        while (xmlCursor.toParent()) {
        }
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isStart()) {
            do {
                javax.xml.namespace.QName qName;
                if (!tokenType.isStart() && !tokenType.isAttr() && !tokenType.isNamespace() || !string.equals((qName = xmlCursor.getName()).getNamespaceURI())) continue;
                xmlCursor.setName(new javax.xml.namespace.QName(string2, qName.getLocalPart()));
            } while (!(tokenType = xmlCursor.toNextToken()).isEnddoc() && !tokenType.isNone());
        }
        xmlCursor.dispose();
    }

    void remove() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.currentTokenType().isStartdoc()) {
            XmlCursor.TokenType tokenType = xmlCursor.toFirstContentToken();
            while (!tokenType.isEnd() && !tokenType.isEnddoc()) {
                this.removeToken(xmlCursor);
                tokenType = xmlCursor.currentTokenType();
            }
        } else {
            this.removeToken(xmlCursor);
        }
        xmlCursor.dispose();
    }

    void replaceAll(XML xML) {
        XmlCursor xmlCursor = this.newCursor();
        this.replace(xmlCursor, xML);
        this._anno = xML._anno;
        xmlCursor.dispose();
    }

    void setAttribute(XMLName xMLName, Object object) {
        javax.xml.namespace.QName qName;
        if (xMLName.uri() == null && xMLName.localName().equals("*")) {
            throw ScriptRuntime.typeError("@* assignment not supported.");
        }
        XmlCursor xmlCursor = this.newCursor();
        String string = ScriptRuntime.toString(object);
        if (xmlCursor.currentTokenType().isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        try {
            qName = new javax.xml.namespace.QName(xMLName.uri(), xMLName.localName());
        }
        catch (Exception exception) {
            throw ScriptRuntime.typeError(exception.getMessage());
        }
        if (!xmlCursor.setAttributeText(qName, string)) {
            if (xmlCursor.currentTokenType().isStart()) {
                xmlCursor.toNextToken();
            }
            xmlCursor.insertAttributeWithValue(qName, string);
        }
        xmlCursor.dispose();
    }

    private XMLList allChildNodes(String string) {
        XMLList xMLList = new XMLList(this.lib);
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        javax.xml.namespace.QName qName = new javax.xml.namespace.QName(string, "*");
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isContainer()) {
            tokenType = xmlCursor.toFirstContentToken();
            while (!tokenType.isEnd()) {
                if (!tokenType.isStart()) {
                    xMLList.addToList(XML.findAnnotation(xmlCursor));
                    qName = null;
                } else if (string == null || string.length() == 0 || string.equals("*") || xmlCursor.getName().getNamespaceURI().equals(string)) {
                    xMLList.addToList(XML.findAnnotation(xmlCursor));
                    if (qName != null) {
                        if (qName.getLocalPart().equals("*")) {
                            qName = xmlCursor.getName();
                        } else if (!qName.getLocalPart().equals(xmlCursor.getName().getLocalPart())) {
                            qName = null;
                        }
                    }
                }
                if (tokenType.isStart()) {
                    tokenType = xmlCursor.toEndToken();
                }
                tokenType = xmlCursor.toNextToken();
            }
        }
        xmlCursor.dispose();
        xMLList.setTargets(this, qName);
        return xMLList;
    }

    private XMLList matchDescendantAttributes(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        xMLList.setTargets(this, null);
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isContainer()) {
            int n = 1;
            while (n > 0) {
                tokenType = xmlCursor.toNextToken();
                if (tokenType.isAttr() && this.qnameMatches(xMLName, xmlCursor.getName())) {
                    xMLList.addToList(XML.findAnnotation(xmlCursor));
                }
                if (tokenType.isStart()) {
                    ++n;
                    continue;
                }
                if (tokenType.isEnd()) {
                    --n;
                    continue;
                }
                if (!tokenType.isEnddoc()) continue;
            }
        }
        xmlCursor.dispose();
        return xMLList;
    }

    private XMLList matchDescendantChildren(XMLName xMLName) {
        XMLList xMLList = new XMLList(this.lib);
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        xMLList.setTargets(this, null);
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isContainer()) {
            int n = 1;
            while (n > 0) {
                tokenType = xmlCursor.toNextToken();
                if (!(tokenType.isAttr() || tokenType.isEnd() || tokenType.isEnddoc())) {
                    if (!tokenType.isStart() && !tokenType.isProcinst()) {
                        if (xMLName.localName().equals("*")) {
                            xMLList.addToList(XML.findAnnotation(xmlCursor));
                        }
                    } else if (this.qnameMatches(xMLName, xmlCursor.getName())) {
                        xMLList.addToList(XML.findAnnotation(xmlCursor));
                    }
                }
                if (tokenType.isStart()) {
                    ++n;
                    continue;
                }
                if (tokenType.isEnd()) {
                    --n;
                    continue;
                }
                if (!tokenType.isEnddoc()) continue;
            }
        }
        xmlCursor.dispose();
        return xMLList;
    }

    private XMLList matchChildren(XmlCursor.TokenType tokenType) {
        return this.matchChildren(tokenType, XMLName.formStar());
    }

    private XMLList matchChildren(XmlCursor.TokenType tokenType, XMLName xMLName) {
        javax.xml.namespace.QName qName;
        XMLList xMLList = new XMLList(this.lib);
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType2 = xmlCursor.currentTokenType();
        javax.xml.namespace.QName qName2 = qName = new javax.xml.namespace.QName(xMLName.uri(), xMLName.localName());
        if (tokenType2.isStartdoc()) {
            tokenType2 = xmlCursor.toFirstContentToken();
        }
        if (tokenType2.isContainer()) {
            tokenType2 = xmlCursor.toFirstContentToken();
            while (!tokenType2.isEnd()) {
                if (tokenType2 == tokenType) {
                    if (!tokenType2.isStart() && !tokenType2.isProcinst()) {
                        xMLList.addToList(XML.findAnnotation(xmlCursor));
                        qName2 = null;
                    } else if (this.qnameMatches(xMLName, xmlCursor.getName())) {
                        xMLList.addToList(XML.findAnnotation(xmlCursor));
                        if (qName2 != null) {
                            if (qName2.getLocalPart().equals("*")) {
                                qName2 = xmlCursor.getName();
                            } else if (!qName2.getLocalPart().equals(xmlCursor.getName().getLocalPart())) {
                                qName2 = null;
                            }
                        }
                    }
                }
                if (tokenType2.isStart()) {
                    tokenType2 = xmlCursor.toEndToken();
                }
                tokenType2 = xmlCursor.toNextToken();
            }
        }
        xmlCursor.dispose();
        if (tokenType == XmlCursor.TokenType.START) {
            xMLList.setTargets(this, qName2);
        }
        return xMLList;
    }

    private boolean qnameMatches(XMLName xMLName, javax.xml.namespace.QName qName) {
        boolean bl = false;
        if ((xMLName.uri() == null || xMLName.uri().equals(qName.getNamespaceURI())) && (xMLName.localName().equals("*") || xMLName.localName().equals(qName.getLocalPart()))) {
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XML addNamespace(Namespace namespace) {
        String string = namespace.prefix();
        if (string == null) {
            return this;
        }
        XmlCursor xmlCursor = this.newCursor();
        try {
            if (!xmlCursor.isContainer()) {
                XML xML = this;
                return xML;
            }
            javax.xml.namespace.QName qName = xmlCursor.getName();
            if (qName.getNamespaceURI().equals("") && string.equals("")) {
                XML xML = this;
                return xML;
            }
            Map map = NamespaceHelper.getAllNamespaces(this.lib, xmlCursor);
            String string2 = (String)map.get(string);
            if (string2 != null) {
                if (string2.equals(namespace.uri())) {
                    XML xML = this;
                    return xML;
                }
                xmlCursor.push();
                while (xmlCursor.toNextToken().isAnyAttr()) {
                    String string3;
                    if (!xmlCursor.isNamespace() || !(string3 = (qName = xmlCursor.getName()).getLocalPart()).equals(string)) continue;
                    xmlCursor.removeXml();
                    break;
                }
                xmlCursor.pop();
            }
            xmlCursor.toNextToken();
            xmlCursor.insertNamespace(string, namespace.uri());
        }
        finally {
            xmlCursor.dispose();
        }
        return this;
    }

    XML appendChild(Object object) {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        if (xmlCursor.isStart()) {
            xmlCursor.toEndToken();
        }
        this.insertChild(xmlCursor, object);
        xmlCursor.dispose();
        return this;
    }

    XMLList attribute(XMLName xMLName) {
        return this.matchAttributes(xMLName);
    }

    XMLList attributes() {
        XMLName xMLName = XMLName.formStar();
        return this.matchAttributes(xMLName);
    }

    XMLList child(long l) {
        XMLList xMLList = new XMLList(this.lib);
        xMLList.setTargets(this, null);
        xMLList.addToList(this.getXmlChild(l));
        return xMLList;
    }

    XMLList child(XMLName xMLName) {
        if (xMLName == null) {
            return new XMLList(this.lib);
        }
        XMLList xMLList = xMLName.localName().equals("*") ? this.allChildNodes(xMLName.uri()) : this.matchChildren(XmlCursor.TokenType.START, xMLName);
        return xMLList;
    }

    XML getXmlChild(long l) {
        XML xML = null;
        XmlCursor xmlCursor = this.newCursor();
        if (this.moveToChild(xmlCursor, l, false, true)) {
            xML = XML.createXML(this.lib, xmlCursor);
        }
        xmlCursor.dispose();
        return xML;
    }

    int childIndex() {
        int n = 0;
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        while (true) {
            if (tokenType.isText()) {
                ++n;
                if (!xmlCursor.toPrevSibling()) {
                    break;
                }
            } else if (tokenType.isStart()) {
                tokenType = xmlCursor.toPrevToken();
                if (!tokenType.isEnd()) break;
                xmlCursor.toNextToken();
                if (!xmlCursor.toPrevSibling()) break;
                ++n;
            } else {
                if (!tokenType.isComment() && !tokenType.isProcinst()) break;
                xmlCursor.toPrevToken();
            }
            tokenType = xmlCursor.currentTokenType();
        }
        n = xmlCursor.currentTokenType().isStartdoc() ? -1 : n;
        xmlCursor.dispose();
        return n;
    }

    XMLList children() {
        return this.allChildNodes(null);
    }

    XMLList comments() {
        return this.matchChildren(XmlCursor.TokenType.COMMENT);
    }

    boolean contains(Object object) {
        boolean bl = false;
        if (object instanceof XML) {
            bl = this.equivalentXml(object);
        }
        return bl;
    }

    Object copy() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        XML xML = XML.createEmptyXML(this.lib);
        XmlCursor xmlCursor2 = xML.newCursor();
        xmlCursor2.toFirstContentToken();
        xmlCursor.copyXml(xmlCursor2);
        xmlCursor2.dispose();
        xmlCursor.dispose();
        return xML;
    }

    XMLList descendants(XMLName xMLName) {
        XMLList xMLList = xMLName.isAttributeName() ? this.matchDescendantAttributes(xMLName) : this.matchDescendantChildren(xMLName);
        return xMLList;
    }

    Object[] inScopeNamespaces() {
        XmlCursor xmlCursor = this.newCursor();
        Object[] objectArray = NamespaceHelper.inScopeNamespaces(this.lib, xmlCursor);
        xmlCursor.dispose();
        return objectArray;
    }

    XML insertChildAfter(Object object, Object object2) {
        if (object == null) {
            this.prependChild(object2);
        } else if (object instanceof XML) {
            this.insertChild((XML)object, object2, 1);
        }
        return this;
    }

    XML insertChildBefore(Object object, Object object2) {
        if (object == null) {
            this.appendChild(object2);
        } else if (object instanceof XML) {
            this.insertChild((XML)object, object2, 2);
        }
        return this;
    }

    boolean hasOwnProperty(XMLName xMLName) {
        String string;
        boolean bl = false;
        bl = this.prototypeFlag ? 0 != this.findPrototypeId(string = xMLName.localName()) : this.getPropertyList(xMLName).length() > 0;
        return bl;
    }

    boolean hasComplexContent() {
        return !this.hasSimpleContent();
    }

    boolean hasSimpleContent() {
        boolean bl = false;
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isAttr() || xmlCursor.isText()) {
            return true;
        }
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        bl = !xmlCursor.toFirstChild();
        xmlCursor.dispose();
        return bl;
    }

    int length() {
        return 1;
    }

    String localName() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        String string = null;
        if (xmlCursor.isStart() || xmlCursor.isAttr() || xmlCursor.isProcinst()) {
            javax.xml.namespace.QName qName = xmlCursor.getName();
            string = qName.getLocalPart();
        }
        xmlCursor.dispose();
        return string;
    }

    QName name() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        QName qName = null;
        if (xmlCursor.isStart() || xmlCursor.isAttr() || xmlCursor.isProcinst()) {
            javax.xml.namespace.QName qName2 = xmlCursor.getName();
            if (xmlCursor.isProcinst()) {
                qName = new QName(this.lib, "", qName2.getLocalPart(), "");
            } else {
                String string = qName2.getNamespaceURI();
                String string2 = qName2.getPrefix();
                qName = new QName(this.lib, string, qName2.getLocalPart(), string2);
            }
        }
        xmlCursor.dispose();
        return qName;
    }

    Object namespace(String string) {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        Object object = null;
        if (string == null) {
            if (xmlCursor.isStart() || xmlCursor.isAttr()) {
                Object[] objectArray = NamespaceHelper.inScopeNamespaces(this.lib, xmlCursor);
                XmlCursor xmlCursor2 = this.newCursor();
                if (xmlCursor2.isStartdoc()) {
                    xmlCursor2.toFirstContentToken();
                }
                object = NamespaceHelper.getNamespace(this.lib, xmlCursor2, objectArray);
                xmlCursor2.dispose();
            }
        } else {
            Map map = NamespaceHelper.getAllNamespaces(this.lib, xmlCursor);
            String string2 = (String)map.get(string);
            object = string2 == null ? Undefined.instance : new Namespace(this.lib, string, string2);
        }
        xmlCursor.dispose();
        return object;
    }

    Object[] namespaceDeclarations() {
        XmlCursor xmlCursor = this.newCursor();
        Object[] objectArray = NamespaceHelper.namespaceDeclarations(this.lib, xmlCursor);
        xmlCursor.dispose();
        return objectArray;
    }

    Object nodeKind() {
        XmlCursor.TokenType tokenType = this.tokenType();
        String string = tokenType == XmlCursor.TokenType.ATTR ? "attribute" : (tokenType == XmlCursor.TokenType.TEXT ? "text" : (tokenType == XmlCursor.TokenType.COMMENT ? "comment" : (tokenType == XmlCursor.TokenType.PROCINST ? "processing-instruction" : (tokenType == XmlCursor.TokenType.START ? "element" : "text"))));
        return string;
    }

    void normalize() {
        XmlCursor xmlCursor = this.newCursor();
        XmlCursor.TokenType tokenType = xmlCursor.currentTokenType();
        if (tokenType.isStartdoc()) {
            tokenType = xmlCursor.toFirstContentToken();
        }
        if (tokenType.isContainer()) {
            int n = 1;
            String string = null;
            while (n > 0) {
                tokenType = xmlCursor.toNextToken();
                if (tokenType == XmlCursor.TokenType.TEXT) {
                    String string2 = xmlCursor.getChars().trim();
                    if (string2.trim().length() == 0) {
                        this.removeToken(xmlCursor);
                        xmlCursor.toPrevToken();
                    } else if (string == null) {
                        string = string2;
                    } else {
                        String string3 = string + string2;
                        xmlCursor.toPrevToken();
                        this.removeToken(xmlCursor);
                        this.removeToken(xmlCursor);
                        xmlCursor.insertChars(string3);
                    }
                } else {
                    string = null;
                }
                if (tokenType.isStart()) {
                    ++n;
                    continue;
                }
                if (tokenType.isEnd()) {
                    --n;
                    continue;
                }
                if (!tokenType.isEnddoc()) continue;
            }
        }
        xmlCursor.dispose();
    }

    Object parent() {
        XmlCursor xmlCursor = this.newCursor();
        Object object = xmlCursor.isStartdoc() ? Undefined.instance : (xmlCursor.toParent() ? (xmlCursor.isStartdoc() ? Undefined.instance : XML.getFromAnnotation(this.lib, XML.findAnnotation(xmlCursor))) : Undefined.instance);
        xmlCursor.dispose();
        return object;
    }

    XML prependChild(Object object) {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        xmlCursor.toFirstContentToken();
        this.insertChild(xmlCursor, object);
        xmlCursor.dispose();
        return this;
    }

    Object processingInstructions(XMLName xMLName) {
        return this.matchChildren(XmlCursor.TokenType.PROCINST, xMLName);
    }

    boolean propertyIsEnumerable(Object object) {
        double d;
        boolean bl = object instanceof Integer ? (Integer)object == 0 : (object instanceof Number ? (d = ((Number)object).doubleValue()) == 0.0 && 1.0 / d > 0.0 : ScriptRuntime.toString(object).equals("0"));
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XML removeNamespace(Namespace namespace) {
        XmlCursor xmlCursor = this.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstContentToken();
            }
            if (!xmlCursor.isStart()) {
                XML xML = this;
                return xML;
            }
            String string = namespace.prefix();
            String string2 = namespace.uri();
            HashMap hashMap = new HashMap();
            int n = 1;
            while (!xmlCursor.isEnd() || n != 0) {
                if (xmlCursor.isStart()) {
                    hashMap.clear();
                    NamespaceHelper.getNamespaces(xmlCursor, hashMap);
                    ObjArray objArray = new ObjArray();
                    for (Map.Entry entry : hashMap.entrySet()) {
                        namespace = new Namespace(this.lib, (String)entry.getKey(), (String)entry.getValue());
                        objArray.add(namespace);
                    }
                    namespace = new Namespace(this.lib, string2);
                    objArray.add(namespace);
                    Object[] objectArray2 = objArray.toArray();
                    Namespace namespace2 = NamespaceHelper.getNamespace(this.lib, xmlCursor, objectArray2);
                    if (string2.equals(namespace2.uri()) && (string == null || string.equals(namespace2.prefix()))) {
                        XML xML = this;
                        return xML;
                    }
                    xmlCursor.push();
                    boolean bl = xmlCursor.toFirstAttribute();
                    while (bl) {
                        namespace2 = NamespaceHelper.getNamespace(this.lib, xmlCursor, objectArray2);
                        if (string2.equals(namespace2.uri()) && (string == null || string.equals(namespace2.prefix()))) {
                            Map.Entry entry = this;
                            return entry;
                        }
                        bl = xmlCursor.toNextAttribute();
                    }
                    xmlCursor.pop();
                    if (string == null) {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            if (!entry.getValue().equals(string2)) continue;
                            NamespaceHelper.removeNamespace(xmlCursor, (String)entry.getKey());
                        }
                    } else if (string2.equals(hashMap.get(string))) {
                        NamespaceHelper.removeNamespace(xmlCursor, String.valueOf(string));
                    }
                }
                switch (xmlCursor.toNextToken().intValue()) {
                    case 3: {
                        ++n;
                        break;
                    }
                    case 4: {
                        --n;
                    }
                }
            }
        }
        finally {
            xmlCursor.dispose();
        }
        return this;
    }

    XML replace(long l, Object object) {
        XMLList xMLList = this.child(l);
        if (xMLList.length() > 0) {
            XML xML = xMLList.item(0);
            this.insertChildAfter(xML, object);
            this.removeChild(l);
        }
        return this;
    }

    XML replace(XMLName xMLName, Object object) {
        this.putXMLProperty(xMLName, object);
        return this;
    }

    XML setChildren(Object object) {
        XMLName xMLName = XMLName.formStar();
        XMLList xMLList = this.getPropertyList(xMLName);
        xMLList.remove();
        this.appendChild(object);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocalName(String string) {
        XmlCursor xmlCursor = this.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstContentToken();
            }
            if (xmlCursor.isText() || xmlCursor.isComment()) {
                return;
            }
            javax.xml.namespace.QName qName = xmlCursor.getName();
            xmlCursor.setName(new javax.xml.namespace.QName(qName.getNamespaceURI(), string, qName.getPrefix()));
        }
        finally {
            xmlCursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setName(QName qName) {
        XmlCursor xmlCursor = this.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstContentToken();
            }
            if (xmlCursor.isText() || xmlCursor.isComment()) {
                return;
            }
            if (xmlCursor.isProcinst()) {
                String string = qName.localName();
                xmlCursor.setName(new javax.xml.namespace.QName(string));
            } else {
                String string = qName.prefix();
                if (string == null) {
                    string = "";
                }
                xmlCursor.setName(new javax.xml.namespace.QName(qName.uri(), qName.localName(), string));
            }
        }
        finally {
            xmlCursor.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNamespace(Namespace namespace) {
        XmlCursor xmlCursor = this.newCursor();
        try {
            if (xmlCursor.isStartdoc()) {
                xmlCursor.toFirstContentToken();
            }
            if (xmlCursor.isText() || xmlCursor.isComment() || xmlCursor.isProcinst()) {
                return;
            }
            String string = namespace.prefix();
            if (string == null) {
                string = "";
            }
            xmlCursor.setName(new javax.xml.namespace.QName(namespace.uri(), this.localName(), string));
        }
        finally {
            xmlCursor.dispose();
        }
    }

    XMLList text() {
        return this.matchChildren(XmlCursor.TokenType.TEXT);
    }

    public String toString() {
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        String string = xmlCursor.isText() ? xmlCursor.getChars() : (xmlCursor.isStart() && this.hasSimpleContent() ? xmlCursor.getTextValue() : this.toXMLString(0));
        return string;
    }

    String toSource(int n) {
        return this.toXMLString(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toXMLString(int n) {
        String string;
        XmlCursor xmlCursor = this.newCursor();
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        try {
            if (xmlCursor.isText()) {
                string = xmlCursor.getChars();
            } else if (xmlCursor.isAttr()) {
                string = xmlCursor.getTextValue();
            } else if (xmlCursor.isComment() || xmlCursor.isProcinst()) {
                string = XML.dumpNode(xmlCursor, this.getOptions());
                String string2 = "<xml-fragment>";
                String string3 = "</xml-fragment>";
                if (string.startsWith(string2)) {
                    string = string.substring(string2.length());
                }
                if (string.endsWith(string3)) {
                    string = string.substring(0, string.length() - string3.length());
                }
            } else {
                string = XML.dumpNode(xmlCursor, this.getOptions());
            }
        }
        finally {
            xmlCursor.dispose();
        }
        return string;
    }

    Object valueOf() {
        return this;
    }

    boolean equivalentXml(Object object) {
        boolean bl = false;
        if (object instanceof XML) {
            XML xML = (XML)object;
            XmlCursor.TokenType tokenType = this.tokenType();
            XmlCursor.TokenType tokenType2 = xML.tokenType();
            if (tokenType == XmlCursor.TokenType.ATTR || tokenType2 == XmlCursor.TokenType.ATTR || tokenType == XmlCursor.TokenType.TEXT || tokenType2 == XmlCursor.TokenType.TEXT) {
                bl = this.toString().equals(xML.toString());
            } else {
                XmlCursor xmlCursor = this.newCursor();
                XmlCursor xmlCursor2 = xML.newCursor();
                bl = LogicalEquality.nodesEqual(xmlCursor, xmlCursor2);
                xmlCursor.dispose();
                xmlCursor2.dispose();
            }
        } else if (object instanceof XMLList) {
            XMLList xMLList = (XMLList)object;
            if (xMLList.length() == 1) {
                bl = this.equivalentXml(xMLList.getXmlFromAnnotation(0));
            }
        } else if (this.hasSimpleContent()) {
            String string = ScriptRuntime.toString(object);
            bl = this.toString().equals(string);
        }
        return bl;
    }

    XMLList getPropertyList(XMLName xMLName) {
        XMLList xMLList = xMLName.isDescendants() ? this.descendants(xMLName) : (xMLName.isAttributeName() ? this.attribute(xMLName) : this.child(xMLName));
        return xMLList;
    }

    protected Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (objectArray.length == 0) {
            return XML.createFromJS(this.lib, "");
        }
        Object object = objectArray[0];
        if (!bl && object instanceof XML) {
            return object;
        }
        return XML.createFromJS(this.lib, object);
    }

    public Scriptable getExtraMethodSource(Context context) {
        if (this.hasSimpleContent()) {
            String string = this.toString();
            return ScriptRuntime.toObjectOrNull(context, string);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XmlObject getXmlObject() {
        XmlObject xmlObject;
        XmlCursor xmlCursor = this.newCursor();
        try {
            xmlObject = xmlCursor.getObject();
        }
        finally {
            xmlCursor.dispose();
        }
        return xmlObject;
    }

    static final class NamespaceDeclarations {
        private int _prefixIdx = 0;
        private StringBuffer _namespaceDecls = new StringBuffer();
        private String _defaultNSURI;

        NamespaceDeclarations(XmlCursor xmlCursor) {
            XML.skipNonElements(xmlCursor);
            this._defaultNSURI = xmlCursor.namespaceForPrefix("");
            if (this.isAnyDefaultNamespace()) {
                this.addDecl("", this._defaultNSURI);
            }
        }

        private void addDecl(String string, String string2) {
            this._namespaceDecls.append((string.length() > 0 ? "declare namespace " + string : "default element namespace") + " = \"" + string2 + "\"" + "\n");
        }

        String getNextPrefix(String string) {
            String string2 = "NS" + this._prefixIdx++;
            this._namespaceDecls.append("declare namespace " + string2 + " = " + "\"" + string + "\"" + "\n");
            return string2;
        }

        boolean isAnyDefaultNamespace() {
            return this._defaultNSURI != null ? this._defaultNSURI.length() > 0 : false;
        }

        String getDeclarations() {
            return this._namespaceDecls.toString();
        }
    }

    static final class XScriptAnnotation
    extends XmlCursor.XmlBookmark
    implements Serializable {
        private static final long serialVersionUID = 1L;
        javax.xml.namespace.QName _name;
        XML _xScriptXML;

        XScriptAnnotation(XmlCursor xmlCursor) {
            this._name = xmlCursor.getName();
        }
    }
}

