/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xml.impl.xmlbeans.Namespace;
import org.mozilla.javascript.xml.impl.xmlbeans.XMLLibImpl;

final class QName
extends IdScriptableObject {
    static final long serialVersionUID = 416745167693026750L;
    private static final Object QNAME_TAG = "QName";
    XMLLibImpl lib;
    private String prefix;
    private String localName;
    private String uri;
    private static final int Id_localName = 1;
    private static final int Id_uri = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toSource = 3;
    private static final int MAX_PROTOTYPE_ID = 3;

    QName(XMLLibImpl xMLLibImpl, String string, String string2, String string3) {
        super(xMLLibImpl.globalScope(), xMLLibImpl.qnamePrototype);
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        this.lib = xMLLibImpl;
        this.uri = string;
        this.prefix = string3;
        this.localName = string2;
    }

    void exportAsJSClass(boolean bl) {
        this.exportAsJSClass(3, this.lib.globalScope(), bl);
    }

    public String toString() {
        String string = this.uri == null ? "*::".concat(this.localName) : (this.uri.length() == 0 ? this.localName : this.uri + "::" + this.localName);
        return string;
    }

    public String localName() {
        return this.localName;
    }

    String prefix() {
        return this.prefix == null ? this.prefix : "";
    }

    String uri() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QName)) {
            return false;
        }
        return this.equals((QName)object);
    }

    protected Object equivalentValues(Object object) {
        if (!(object instanceof QName)) {
            return Scriptable.NOT_FOUND;
        }
        boolean bl = this.equals((QName)object);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    private boolean equals(QName qName) {
        boolean bl = this.uri == null ? qName.uri == null && this.localName.equals(qName.localName) : this.uri.equals(qName.uri) && this.localName.equals(qName.localName);
        return bl;
    }

    public String getClassName() {
        return "QName";
    }

    public Object getDefaultValue(Class clazz) {
        return this.toString();
    }

    protected int getMaxInstanceId() {
        return super.getMaxInstanceId() + 2;
    }

    protected int findInstanceIdInfo(String string) {
        int n;
        int n2 = 0;
        String string2 = null;
        int n3 = string.length();
        if (n3 == 3) {
            string2 = "uri";
            n2 = 2;
        } else if (n3 == 9) {
            string2 = "localName";
            n2 = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n2 = 0;
        }
        if (n2 == 0) {
            return super.findInstanceIdInfo(string);
        }
        switch (n2) {
            case 1: 
            case 2: {
                n = 5;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return QName.instanceIdInfo(n, super.getMaxInstanceId() + n2);
    }

    protected String getInstanceIdName(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return "localName";
            }
            case 2: {
                return "uri";
            }
        }
        return super.getInstanceIdName(n);
    }

    protected Object getInstanceIdValue(int n) {
        switch (n - super.getMaxInstanceId()) {
            case 1: {
                return this.localName;
            }
            case 2: {
                return this.uri;
            }
        }
        return super.getInstanceIdValue(n);
    }

    protected int findPrototypeId(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 8) {
            char c = string.charAt(3);
            if (c == 'o') {
                string2 = "toSource";
                n = 3;
            } else if (c == 't') {
                string2 = "toString";
                n = 2;
            }
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }

    protected void initPrototypeId(int n) {
        String string;
        int n2;
        switch (n) {
            case 1: {
                n2 = 2;
                string = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(QNAME_TAG, n, string, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(QNAME_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                return this.jsConstructor(context, scriptable2 == null, objectArray);
            }
            case 2: {
                return this.realThis(scriptable2, idFunctionObject).toString();
            }
            case 3: {
                return this.realThis(scriptable2, idFunctionObject).js_toSource();
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    private QName realThis(Scriptable scriptable, IdFunctionObject idFunctionObject) {
        if (!(scriptable instanceof QName)) {
            throw QName.incompatibleCallError(idFunctionObject);
        }
        return (QName)scriptable;
    }

    private Object jsConstructor(Context context, boolean bl, Object[] objectArray) {
        if (!bl && objectArray.length == 1) {
            return this.lib.castToQName(context, objectArray[0]);
        }
        if (objectArray.length == 0) {
            return this.lib.constructQName(context, Undefined.instance);
        }
        if (objectArray.length == 1) {
            return this.lib.constructQName(context, objectArray[0]);
        }
        return this.lib.constructQName(context, objectArray[0], objectArray[1]);
    }

    private String js_toSource() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        QName.toSourceImpl(this.uri, this.localName, this.prefix, stringBuffer);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static void toSourceImpl(String string, String string2, String string3, StringBuffer stringBuffer) {
        stringBuffer.append("new QName(");
        if (string == null && string3 == null) {
            if (!"*".equals(string2)) {
                stringBuffer.append("null, ");
            }
        } else {
            Namespace.toSourceImpl(string3, string, stringBuffer);
            stringBuffer.append(", ");
        }
        stringBuffer.append('\'');
        stringBuffer.append(ScriptRuntime.escapeString(string2, '\''));
        stringBuffer.append("')");
    }
}

