/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.util.Properties;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Environment
extends ScriptableObject {
    static final long serialVersionUID = -430727378460177065L;
    private Environment thePrototypeInstance = null;

    public static void defineClass(ScriptableObject scriptableObject) {
        try {
            ScriptableObject.defineClass(scriptableObject, Environment.class);
        }
        catch (Exception exception) {
            throw new Error(exception.getMessage());
        }
    }

    public String getClassName() {
        return "Environment";
    }

    public Environment() {
        if (this.thePrototypeInstance == null) {
            this.thePrototypeInstance = this;
        }
    }

    public Environment(ScriptableObject scriptableObject) {
        this.setParentScope(scriptableObject);
        Object object = ScriptRuntime.getTopLevelProp(scriptableObject, "Environment");
        if (object != null && object instanceof Scriptable) {
            Scriptable scriptable = (Scriptable)object;
            this.setPrototype((Scriptable)scriptable.get("prototype", scriptable));
        }
    }

    public boolean has(String string, Scriptable scriptable) {
        if (this == this.thePrototypeInstance) {
            return super.has(string, scriptable);
        }
        return System.getProperty(string) != null;
    }

    public Object get(String string, Scriptable scriptable) {
        if (this == this.thePrototypeInstance) {
            return super.get(string, scriptable);
        }
        String string2 = System.getProperty(string);
        if (string2 != null) {
            return ScriptRuntime.toObject(this.getParentScope(), string2);
        }
        return Scriptable.NOT_FOUND;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        if (this == this.thePrototypeInstance) {
            super.put(string, scriptable, object);
        } else {
            System.getProperties().put(string, ScriptRuntime.toString(object));
        }
    }

    private Object[] collectIds() {
        Properties properties = System.getProperties();
        return properties.keySet().toArray();
    }

    public Object[] getIds() {
        if (this == this.thePrototypeInstance) {
            return super.getIds();
        }
        return this.collectIds();
    }

    public Object[] getAllIds() {
        if (this == this.thePrototypeInstance) {
            return super.getAllIds();
        }
        return this.collectIds();
    }
}

