/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.image;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.loopj.android.image.SmartImage;
import com.loopj.android.image.WebImageCache;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class WebImage
implements SmartImage {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 10000;
    private static WebImageCache webImageCache;
    private String url;

    public WebImage(String string) {
        this.url = string;
    }

    @Override
    public Bitmap getBitmap(Context context) {
        if (webImageCache == null) {
            webImageCache = new WebImageCache(context);
        }
        Bitmap bitmap = null;
        if (this.url != null && (bitmap = webImageCache.get(this.url)) == null && (bitmap = this.getBitmapFromUrl(this.url)) != null) {
            webImageCache.put(this.url, bitmap);
        }
        return bitmap;
    }

    private Bitmap getBitmapFromUrl(String string) {
        Bitmap bitmap = null;
        try {
            URLConnection uRLConnection = new URL(string).openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(10000);
            bitmap = BitmapFactory.decodeStream((InputStream)((InputStream)uRLConnection.getContent()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bitmap;
    }

    public static void removeFromCache(String string) {
        if (webImageCache != null) {
            webImageCache.remove(string);
        }
    }
}

