/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.pager;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import com.commonsware.cwac.pager.PageDescriptor;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class ArrayPagerAdapter<T extends Fragment>
extends PagerAdapter {
    private static final String KEY_DESCRIPTORS = "descriptors";
    private final FragmentManager fm;
    private ArrayList<PageEntry> entries = new ArrayList();
    private FragmentTransaction currTransaction = null;
    private T currPrimaryItem = null;
    private HashMap<Fragment, Integer> positionDelta = new HashMap();
    private RetentionStrategy retentionStrategy = null;
    public static final RetentionStrategy KEEP = new RetentionStrategy(){

        @Override
        @TargetApi(value=13)
        public void attach(Fragment fragment, FragmentTransaction currTransaction) {
            currTransaction.attach(fragment);
        }

        @Override
        @TargetApi(value=13)
        public void detach(Fragment fragment, FragmentTransaction currTransaction) {
            currTransaction.detach(fragment);
        }
    };

    protected abstract T createFragment(PageDescriptor var1);

    public ArrayPagerAdapter(FragmentManager fragmentManager, ArrayList<PageDescriptor> descriptors) {
        this(fragmentManager, descriptors, null);
    }

    public ArrayPagerAdapter(FragmentManager fragmentManager, ArrayList<PageDescriptor> descriptors, RetentionStrategy retentionStrategy) {
        this.fm = fragmentManager;
        this.entries = new ArrayList();
        for (PageDescriptor desc : descriptors) {
            this.validatePageDescriptor(desc);
            this.entries.add(new PageEntry(desc));
        }
        this.retentionStrategy = retentionStrategy;
        if (this.retentionStrategy == null) {
            this.retentionStrategy = KEEP;
        }
    }

    public int getCount() {
        return this.entries.size();
    }

    public void startUpdate(ViewGroup container) {
    }

    @TargetApi(value=15)
    public Object instantiateItem(ViewGroup container, int position) {
        T fragment;
        if (this.currTransaction == null) {
            this.currTransaction = this.fm.beginTransaction();
        }
        if ((fragment = this.getExistingFragment(position)) != null) {
            this.retentionStrategy.attach((Fragment)fragment, this.currTransaction);
        } else {
            fragment = this.createFragment(this.entries.get(position).getDescriptor());
            this.currTransaction.add(container.getId(), fragment, this.getFragmentTag(position));
        }
        if (fragment != this.currPrimaryItem) {
            fragment.setMenuVisibility(false);
            if (Build.VERSION.SDK_INT >= 15) {
                fragment.setUserVisibleHint(false);
            }
        }
        return fragment;
    }

    @TargetApi(value=11)
    public void destroyItem(ViewGroup container, int position, Object object) {
        if (this.currTransaction == null) {
            this.currTransaction = this.fm.beginTransaction();
        }
        this.retentionStrategy.detach((Fragment)object, this.currTransaction);
    }

    @TargetApi(value=15)
    public void setPrimaryItem(ViewGroup container, int position, Object object) {
        Fragment fragment = (Fragment)object;
        if (fragment != this.currPrimaryItem) {
            if (this.currPrimaryItem != null) {
                this.currPrimaryItem.setMenuVisibility(false);
                if (Build.VERSION.SDK_INT >= 15) {
                    this.currPrimaryItem.setUserVisibleHint(false);
                }
            }
            if (fragment != null) {
                fragment.setMenuVisibility(true);
                if (Build.VERSION.SDK_INT >= 15) {
                    fragment.setUserVisibleHint(true);
                }
            }
            this.currPrimaryItem = fragment;
        }
    }

    @TargetApi(value=11)
    public void finishUpdate(ViewGroup container) {
        if (this.currTransaction != null) {
            this.currTransaction.commitAllowingStateLoss();
            this.currTransaction = null;
            this.fm.executePendingTransactions();
        }
    }

    @TargetApi(value=11)
    public boolean isViewFromObject(View view, Object object) {
        return ((Fragment)object).getView() == view;
    }

    public Parcelable saveState() {
        Bundle state = new Bundle();
        state.putParcelableArrayList(KEY_DESCRIPTORS, this.entries);
        return state;
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        Bundle b = (Bundle)state;
        b.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        this.entries = ((Bundle)state).getParcelableArrayList(KEY_DESCRIPTORS);
        this.notifyDataSetChanged();
    }

    public String getPageTitle(int position) {
        return this.entries.get(position).getDescriptor().getTitle();
    }

    public int getItemPosition(Object o) {
        Integer result = this.positionDelta.get(o);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public void add(PageDescriptor desc) {
        this.validatePageDescriptor(desc);
        this.positionDelta.clear();
        this.entries.add(new PageEntry(desc));
        this.notifyDataSetChanged();
    }

    public void insert(PageDescriptor desc, int position) {
        this.validatePageDescriptor(desc);
        this.positionDelta.clear();
        for (int i = position; i < this.entries.size(); ++i) {
            T f = this.getExistingFragment(i);
            if (f == null) continue;
            this.positionDelta.put((Fragment)f, i + 1);
        }
        this.entries.add(position, new PageEntry(desc));
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.positionDelta.clear();
        T f = this.getExistingFragment(position);
        if (f != null) {
            this.positionDelta.put((Fragment)f, -2);
        }
        for (int i = position + 1; i < this.entries.size(); ++i) {
            f = this.getExistingFragment(i);
            if (f == null) continue;
            this.positionDelta.put((Fragment)f, i - 1);
        }
        this.entries.remove(position);
        this.notifyDataSetChanged();
    }

    public void move(int oldPosition, int newPosition) {
        if (oldPosition != newPosition) {
            PageDescriptor desc = this.entries.get(oldPosition).getDescriptor();
            this.remove(oldPosition);
            this.insert(desc, newPosition);
        }
    }

    @TargetApi(value=11)
    public T getExistingFragment(int position) {
        return (T)this.fm.findFragmentByTag(this.getFragmentTag(position));
    }

    public T getCurrentFragment() {
        return this.currPrimaryItem;
    }

    private String getFragmentTag(int position) {
        return this.entries.get(position).getDescriptor().getFragmentTag();
    }

    private void validatePageDescriptor(PageDescriptor desc) {
        for (PageEntry entry : this.entries) {
            if (!desc.getFragmentTag().equals(entry.getDescriptor().getFragmentTag())) continue;
            throw new IllegalArgumentException("PageDescriptor tag not unique: " + desc.getFragmentTag());
        }
    }

    private static class PageEntry
    implements Parcelable {
        private PageDescriptor descriptor = null;
        private Fragment.SavedState state = null;
        public static final Parcelable.Creator<PageEntry> CREATOR = new Parcelable.Creator<PageEntry>(){

            public PageEntry createFromParcel(Parcel in) {
                return new PageEntry(in);
            }

            public PageEntry[] newArray(int size) {
                return new PageEntry[size];
            }
        };

        PageEntry(PageDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        PageEntry(Parcel in) {
            this.descriptor = (PageDescriptor)in.readParcelable(this.getClass().getClassLoader());
            this.state = (Fragment.SavedState)in.readParcelable(this.getClass().getClassLoader());
        }

        PageDescriptor getDescriptor() {
            return this.descriptor;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeParcelable((Parcelable)this.descriptor, 0);
            out.writeParcelable((Parcelable)this.state, 0);
        }
    }

    public static interface RetentionStrategy {
        public void attach(Fragment var1, FragmentTransaction var2);

        public void detach(Fragment var1, FragmentTransaction var2);
    }
}

