/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.provider.ContactsContract;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class ContactsPhotoBitmapHunter
extends BitmapHunter {
    final Context context;

    ContactsPhotoBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bitmap decode(Request data) throws IOException {
        InputStream is = null;
        try {
            is = this.getInputStream();
            Bitmap bitmap = this.decodeStream(is, data);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    private InputStream getInputStream() throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        Uri uri = this.getData().uri;
        if (uri.toString().startsWith(ContactsContract.Contacts.CONTENT_LOOKUP_URI.toString()) && (uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri)) == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 14) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri);
        }
        return ContactPhotoStreamIcs.get(contentResolver, uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap decodeStream(InputStream stream, Request data) throws IOException {
        if (stream == null) {
            return null;
        }
        BitmapFactory.Options options = null;
        if (data.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            InputStream is = this.getInputStream();
            try {
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            ContactsPhotoBitmapHunter.calculateInSampleSize(data.targetWidth, data.targetHeight, options);
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
    }

    @TargetApi(value=14)
    private static class ContactPhotoStreamIcs {
        private ContactPhotoStreamIcs() {
        }

        static InputStream get(ContentResolver contentResolver, Uri uri) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
    }
}

