/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.squareup.picasso.Action;
import com.squareup.picasso.BitmapHunter;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Dispatcher;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Request;
import com.squareup.picasso.Stats;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.io.InputStream;

class AssetBitmapHunter
extends BitmapHunter {
    private AssetManager assetManager;

    public AssetBitmapHunter(Context context, Picasso picasso, Dispatcher dispatcher, Cache cache, Stats stats, Action action) {
        super(picasso, dispatcher, cache, stats, action);
        this.assetManager = context.getAssets();
    }

    @Override
    Bitmap decode(Request data) throws IOException {
        String filePath = data.uri.toString().substring(ASSET_PREFIX_LENGTH);
        return this.decodeAsset(filePath);
    }

    @Override
    Picasso.LoadedFrom getLoadedFrom() {
        return Picasso.LoadedFrom.DISK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bitmap decodeAsset(String filePath) throws IOException {
        InputStream is;
        BitmapFactory.Options options = null;
        if (this.data.hasSize()) {
            options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = null;
            try {
                is = this.assetManager.open(filePath);
                BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            }
            finally {
                Utils.closeQuietly(is);
            }
            AssetBitmapHunter.calculateInSampleSize(this.data.targetWidth, this.data.targetHeight, options);
        }
        is = this.assetManager.open(filePath);
        try {
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            return bitmap;
        }
        finally {
            Utils.closeQuietly(is);
        }
    }
}

