/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.gson;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.ByteBufferListParser;
import com.koushikdutta.async.stream.ByteBufferListInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;

public class GsonSerializer<T>
implements AsyncParser<T> {
    Gson gson;
    Type type;

    public GsonSerializer(Gson gson, Class<T> clazz) {
        this.gson = gson;
        this.type = clazz;
    }

    public GsonSerializer(Gson gson, TypeToken<T> token) {
        this.gson = gson;
        this.type = token.getType();
    }

    public Future<T> parse(DataEmitter emitter) {
        return new TransformFuture<T, ByteBufferList>(){

            protected void transform(ByteBufferList result) throws Exception {
                ByteBufferListInputStream bin = new ByteBufferListInputStream(result);
                Object ret = GsonSerializer.this.gson.fromJson(new JsonReader((Reader)new InputStreamReader((InputStream)bin)), GsonSerializer.this.type);
                this.setComplete(ret);
            }
        }.from(new ByteBufferListParser().parse(emitter));
    }

    public void write(DataSink sink, T pojo, CompletedCallback completed) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(bout);
        this.gson.toJson(pojo, this.type, (Appendable)out);
        Util.writeAll((DataSink)sink, (byte[])bout.toByteArray(), (CompletedCallback)completed);
    }
}

