/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.koushikdutta.async.ByteBufferList;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.TransformFuture;
import com.koushikdutta.async.parser.AsyncParser;
import com.koushikdutta.async.parser.ByteBufferListParser;
import com.koushikdutta.async.parser.StringParser;
import com.koushikdutta.async.stream.ByteBufferListInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class GsonParser<T extends JsonElement>
implements AsyncParser<T> {
    public Future<T> parse(DataEmitter emitter) {
        return new TransformFuture<T, ByteBufferList>(){

            protected void transform(ByteBufferList result) throws Exception {
                JsonParser parser = new JsonParser();
                JsonElement parsed = parser.parse(new JsonReader((Reader)new InputStreamReader((InputStream)new ByteBufferListInputStream(result))));
                if (parsed.isJsonNull() || parsed.isJsonPrimitive()) {
                    throw new JsonParseException("unable to parse json");
                }
                this.setComplete(null, parsed);
            }
        }.from(new ByteBufferListParser().parse(emitter));
    }

    public void write(DataSink sink, T value, CompletedCallback completed) {
        new StringParser().write(sink, value.toString(), completed);
    }
}

