/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion.gson;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.koushikdutta.async.DataEmitter;
import com.koushikdutta.async.DataSink;
import com.koushikdutta.async.Util;
import com.koushikdutta.async.callback.CompletedCallback;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.body.AsyncHttpRequestBody;
import com.koushikdutta.ion.gson.GsonParser;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;

public class GsonBody<T extends JsonElement>
implements AsyncHttpRequestBody<T> {
    byte[] mBodyBytes;
    T json;
    Gson gson;
    public static final String CONTENT_TYPE = "application/json";

    public GsonBody(Gson gson, T json) {
        this.json = json;
        this.gson = gson;
    }

    public void parse(DataEmitter emitter, final CompletedCallback completed) {
        new GsonParser().parse(emitter).setCallback(new FutureCallback<T>(){

            public void onCompleted(Exception e, T result) {
                GsonBody.this.json = result;
                completed.onCompleted(e);
            }
        });
    }

    public void write(AsyncHttpRequest request, DataSink sink, CompletedCallback completed) {
        if (this.mBodyBytes == null) {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(bout);
            this.gson.toJson(this.json, (Appendable)out);
            this.mBodyBytes = bout.toByteArray();
        }
        Util.writeAll((DataSink)sink, (byte[])this.mBodyBytes, (CompletedCallback)completed);
    }

    public String getContentType() {
        return CONTENT_TYPE;
    }

    public boolean readFullyOnRequest() {
        return true;
    }

    public int length() {
        if (this.mBodyBytes == null) {
            this.mBodyBytes = this.json.toString().getBytes();
        }
        return this.mBodyBytes.length;
    }

    public T get() {
        return this.json;
    }
}

