/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.widget.ImageView;
import com.google.gson.Gson;
import com.koushikdutta.async.AsyncServer;
import com.koushikdutta.async.future.Future;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.http.AsyncHttpClient;
import com.koushikdutta.async.http.AsyncHttpClientMiddleware;
import com.koushikdutta.async.http.AsyncHttpRequest;
import com.koushikdutta.async.http.ResponseCacheMiddleware;
import com.koushikdutta.async.http.libcore.RawHeaders;
import com.koushikdutta.async.util.HashList;
import com.koushikdutta.ion.IonBitmapRequestBuilder;
import com.koushikdutta.ion.IonLog;
import com.koushikdutta.ion.IonRequestBuilder;
import com.koushikdutta.ion.Loader;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import com.koushikdutta.ion.bitmap.IonBitmapCache;
import com.koushikdutta.ion.builder.Builders;
import com.koushikdutta.ion.builder.FutureBuilder;
import com.koushikdutta.ion.builder.LoadBuilder;
import com.koushikdutta.ion.cookie.CookieMiddleware;
import com.koushikdutta.ion.loader.AsyncHttpRequestFactory;
import com.koushikdutta.ion.loader.ContentLoader;
import com.koushikdutta.ion.loader.FileLoader;
import com.koushikdutta.ion.loader.HttpLoader;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class Ion {
    public static final Handler mainHandler = new Handler(Looper.getMainLooper());
    IonBitmapRequestBuilder bitmapBuilder = new IonBitmapRequestBuilder(this);
    AsyncHttpClient httpClient;
    CookieMiddleware cookieMiddleware;
    ResponseCacheMiddleware responseCache;
    WeakHashMap<Object, FutureSet> inFlight = new WeakHashMap();
    HttpLoader httpLoader;
    ContentLoader contentLoader;
    FileLoader fileLoader;
    String name;
    Context context;
    String LOGTAG;
    int logLevel;
    Config config = new Config();
    HashList<FutureCallback<BitmapInfo>> bitmapsPending = new HashList();
    IonBitmapCache bitmapCache;
    static Ion instance;

    public static Builders.Any.B with(Context context, String uri) {
        return Ion.getDefault(context).build(context, uri);
    }

    public static LoadBuilder<Builders.Any.B> with(Context context) {
        return Ion.getDefault(context).build(context);
    }

    public static FutureBuilder with(Context context, File file) {
        return Ion.getDefault(context).build(context, file);
    }

    public FutureBuilder build(Context context, File file) {
        return new IonRequestBuilder(context, this).load(file);
    }

    public static Ion getDefault(Context context) {
        if (instance == null) {
            instance = new Ion(context, "ion");
        }
        return instance;
    }

    public static Builders.ImageView.F<? extends Builders.ImageView.F<?>> with(ImageView imageView) {
        Ion ion = Ion.getDefault(imageView.getContext());
        return ion.build(imageView);
    }

    public Builders.Any.B build(Context context, String uri) {
        return new IonRequestBuilder(context, this).load(uri);
    }

    public LoadBuilder<Builders.Any.B> build(Context context) {
        return new IonRequestBuilder(context, this);
    }

    public Builders.ImageView.F<? extends Builders.ImageView.F<?>> build(ImageView imageView) {
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new IllegalStateException("must be called from UI thread");
        }
        this.bitmapBuilder.reset();
        this.bitmapBuilder.ion = this;
        return this.bitmapBuilder.withImageView(imageView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll(Object group) {
        FutureSet members;
        Ion ion = this;
        synchronized (ion) {
            members = this.inFlight.remove(group);
        }
        if (members == null) {
            return;
        }
        for (Future future : members.keySet()) {
            if (future == null) continue;
            future.cancel();
        }
    }

    public void proxy(String host, int port) {
        this.httpClient.getSocketMiddleware().enableProxy(host, port);
    }

    public void proxySecure(String host, int port) {
        this.httpClient.getSSLSocketMiddleware().enableProxy(host, port);
    }

    public void disableProxy() {
        this.httpClient.getSocketMiddleware().disableProxy();
    }

    public void disableSecureProxy() {
        this.httpClient.getSocketMiddleware().disableProxy();
    }

    void removeFutureInFlight(Future future, Object group) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFutureInFlight(Future future, Object group) {
        FutureSet members;
        if (group == null || future == null || future.isDone() || future.isCancelled()) {
            return;
        }
        Ion ion = this;
        synchronized (ion) {
            members = this.inFlight.get(group);
            if (members == null) {
                members = new FutureSet();
                this.inFlight.put(group, members);
            }
        }
        members.put(future, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        ArrayList<Object> groups;
        Ion ion = this;
        synchronized (ion) {
            groups = new ArrayList<Object>(this.inFlight.keySet());
        }
        for (Object group : groups) {
            this.cancelAll(group);
        }
    }

    public void cancelAll(Context context) {
        this.cancelAll((Object)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingRequestCount(Object group) {
        Ion ion = this;
        synchronized (ion) {
            FutureSet members = this.inFlight.get(group);
            if (members == null) {
                return 0;
            }
            int ret = 0;
            for (Future future : members.keySet()) {
                if (future.isCancelled() || future.isDone()) continue;
                ++ret;
            }
            return ret;
        }
    }

    public void dump() {
        this.bitmapCache.dump();
        Log.i((String)this.LOGTAG, (String)("Pending bitmaps: " + this.bitmapsPending.size()));
        Log.i((String)this.LOGTAG, (String)("Groups: " + this.inFlight.size()));
        for (FutureSet futures : this.inFlight.values()) {
            Log.i((String)this.LOGTAG, (String)("Group size: " + futures.size()));
        }
    }

    public Context getContext() {
        return this.context;
    }

    private void addCookieMiddleware() {
        this.cookieMiddleware = new CookieMiddleware(this.context, this.name);
        this.httpClient.insertMiddleware((AsyncHttpClientMiddleware)this.cookieMiddleware);
    }

    public HttpLoader getHttpLoader() {
        return this.httpLoader;
    }

    public ContentLoader getContentLoader() {
        return this.contentLoader;
    }

    public FileLoader getFileLoader() {
        return this.fileLoader;
    }

    public ResponseCacheMiddleware getResponseCache() {
        return this.responseCache;
    }

    public String getName() {
        return this.name;
    }

    private Ion(Context context, String name) {
        this.httpClient = new AsyncHttpClient(new AsyncServer());
        this.context = context = context.getApplicationContext();
        this.name = name;
        try {
            this.responseCache = ResponseCacheMiddleware.addCache((AsyncHttpClient)this.httpClient, (File)new File(context.getCacheDir(), name), (long)0xA00000L);
        }
        catch (Exception e) {
            IonLog.w("unable to set up response cache", e);
        }
        if (Build.VERSION.SDK_INT >= 9) {
            this.addCookieMiddleware();
        }
        this.httpClient.getSocketMiddleware().setConnectAllAddresses(true);
        this.httpClient.getSSLSocketMiddleware().setConnectAllAddresses(true);
        this.bitmapCache = new IonBitmapCache(this);
        this.httpLoader = new HttpLoader();
        this.contentLoader = new ContentLoader();
        this.fileLoader = new FileLoader();
        this.configure().addLoader(this.httpLoader).addLoader(this.contentLoader).addLoader(this.fileLoader);
    }

    public CookieMiddleware getCookieMiddleware() {
        return this.cookieMiddleware;
    }

    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public AsyncServer getServer() {
        return this.httpClient.getServer();
    }

    public void setLogging(String logtag, int logLevel) {
        this.LOGTAG = logtag;
        this.logLevel = logLevel;
    }

    public Config configure() {
        return this.config;
    }

    public IonBitmapCache getBitmapCache() {
        return this.bitmapCache;
    }

    public static class Config {
        private Gson gson = new Gson();
        AsyncHttpRequestFactory asyncHttpRequestFactory = new AsyncHttpRequestFactoryImpl();
        ArrayList<Loader> loaders = new ArrayList();

        public Gson getGson() {
            return this.gson;
        }

        public void setGson(Gson gson) {
            this.gson = gson;
        }

        public AsyncHttpRequestFactory getAsyncHttpRequestFactory() {
            return this.asyncHttpRequestFactory;
        }

        public Config setAsyncHttpRequestFactory(AsyncHttpRequestFactory asyncHttpRequestFactory) {
            this.asyncHttpRequestFactory = asyncHttpRequestFactory;
            return this;
        }

        public Config addLoader(int index, Loader loader) {
            this.loaders.add(index, loader);
            return this;
        }

        public Config insertLoader(Loader loader) {
            this.loaders.add(0, loader);
            return this;
        }

        public Config addLoader(Loader loader) {
            this.loaders.add(loader);
            return this;
        }

        public List<Loader> getLoaders() {
            return this.loaders;
        }
    }

    static class FutureSet
    extends WeakHashMap<Future, Boolean> {
        FutureSet() {
        }
    }

    private static class AsyncHttpRequestFactoryImpl
    implements AsyncHttpRequestFactory {
        private AsyncHttpRequestFactoryImpl() {
        }

        @Override
        public AsyncHttpRequest createAsyncHttpRequest(URI uri, String method, RawHeaders headers) {
            return new AsyncHttpRequest(uri, method, headers);
        }
    }
}

