/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.RectF;
import com.koushikdutta.ion.ScaleMode;
import com.koushikdutta.ion.bitmap.Transform;

class DefaultTransform
implements Transform {
    ScaleMode scaleMode;
    int resizeWidth;
    int resizeHeight;

    public DefaultTransform(int width, int height, ScaleMode scaleMode) {
        this.resizeWidth = width;
        this.resizeHeight = height;
        this.scaleMode = scaleMode;
    }

    @Override
    public Bitmap transform(Bitmap b) {
        Bitmap ret = Bitmap.createBitmap((int)this.resizeWidth, (int)this.resizeHeight, (Bitmap.Config)b.getConfig());
        Canvas canvas = new Canvas(ret);
        RectF destination = new RectF(0.0f, 0.0f, (float)this.resizeWidth, (float)this.resizeHeight);
        if (this.scaleMode != ScaleMode.FitXY) {
            float xratio = (float)this.resizeWidth / (float)b.getWidth();
            float yratio = (float)this.resizeHeight / (float)b.getHeight();
            float ratio = this.scaleMode == ScaleMode.CenterCrop ? Math.max(xratio, yratio) : Math.min(xratio, yratio);
            float postx = (float)b.getWidth() * ratio;
            float posty = (float)b.getHeight() * ratio;
            float transx = ((float)this.resizeWidth - postx) / 2.0f;
            float transy = ((float)this.resizeHeight - posty) / 2.0f;
            destination.set(transx, transy, postx, posty);
        }
        canvas.drawBitmap(b, null, destination, null);
        return ret;
    }

    @Override
    public String key() {
        return this.scaleMode.name() + this.resizeWidth + "x" + this.resizeHeight;
    }
}

