/*
 * Decompiled with CFR 0.152.
 */
package com.koushikdutta.ion;

import android.graphics.Bitmap;
import com.koushikdutta.async.future.FutureCallback;
import com.koushikdutta.async.http.libcore.DiskLruCache;
import com.koushikdutta.ion.BitmapCallback;
import com.koushikdutta.ion.Ion;
import com.koushikdutta.ion.LoadBitmapStream;
import com.koushikdutta.ion.bitmap.BitmapInfo;
import com.koushikdutta.ion.bitmap.Transform;
import java.io.OutputStream;
import java.util.ArrayList;

class BitmapToBitmapInfo
extends BitmapCallback
implements FutureCallback<BitmapInfo> {
    ArrayList<Transform> transforms;

    public static void getBitmapSnapshot(final Ion ion, final String transformKey) {
        ion.getServer().getExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LoadBitmapStream callback = new LoadBitmapStream(ion, transformKey, true, 0, 0);
                try {
                    DiskLruCache.Snapshot snapshot = ion.getResponseCache().getDiskLruCache().get(transformKey);
                    try {
                        callback.loadInputStream(snapshot.getInputStream(0));
                    }
                    finally {
                        snapshot.close();
                    }
                }
                catch (Exception e) {
                    callback.report(e, null);
                    try {
                        ion.getResponseCache().getDiskLruCache().remove(transformKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public BitmapToBitmapInfo(Ion ion, String transformKey, ArrayList<Transform> transforms) {
        super(ion, transformKey, true);
        this.transforms = transforms;
    }

    public void onCompleted(Exception e, final BitmapInfo result) {
        if (e != null) {
            this.report(e, null);
            return;
        }
        this.ion.getServer().getExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                BitmapInfo info = new BitmapInfo();
                try {
                    Bitmap tmpBitmap = result.bitmap;
                    for (Transform transform : BitmapToBitmapInfo.this.transforms) {
                        tmpBitmap = transform.transform(tmpBitmap);
                    }
                    info.loadedFrom = result.loadedFrom;
                    info.bitmap = tmpBitmap;
                    info.key = BitmapToBitmapInfo.this.key;
                    BitmapToBitmapInfo.this.report(null, info);
                }
                catch (Exception e) {
                    BitmapToBitmapInfo.this.report(e, null);
                    return;
                }
                try {
                    DiskLruCache cache = BitmapToBitmapInfo.this.ion.getResponseCache().getDiskLruCache();
                    if (cache == null) {
                        return;
                    }
                    DiskLruCache.Editor editor = cache.edit(BitmapToBitmapInfo.this.key);
                    if (editor == null) {
                        return;
                    }
                    try {
                        for (int i = 1; i < 2; ++i) {
                            editor.set(i, BitmapToBitmapInfo.this.key);
                        }
                        OutputStream out = editor.newOutputStream(0);
                        Bitmap.CompressFormat format = info.bitmap.hasAlpha() ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
                        info.bitmap.compress(format, 100, out);
                        out.close();
                        editor.commit();
                    }
                    catch (Exception ex) {
                        editor.abort();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

