/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.layouts;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.util.AttributeSet;
import com.commonsware.cwac.layouts.AspectLockedFrameLayout;
import com.commonsware.cwac.layouts.Mirror;

public class MirroringFrameLayout
extends AspectLockedFrameLayout {
    private Mirror mirror = null;
    private Bitmap bmp = null;
    private Canvas bmpBackedCanvas = null;

    public MirroringFrameLayout(Context context) {
        this(context, null);
    }

    public MirroringFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
        if (mirror != null) {
            mirror.setSource(this);
            this.setAspectRatioSource(mirror);
            this.post(new Runnable(){

                @Override
                public void run() {
                    MirroringFrameLayout.this.requestLayout();
                }
            });
        }
    }

    public void draw(Canvas canvas) {
        if (this.mirror != null) {
            this.bmp.eraseColor(0);
            super.draw(this.bmpBackedCanvas);
            super.draw(canvas);
            if (this.mirror != null) {
                this.mirror.invalidate();
            }
        } else {
            super.draw(canvas);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mirror != null && (this.bmp == null || this.bmp.getWidth() != w || this.bmp.getHeight() != h)) {
            if (this.bmp != null) {
                this.bmp.recycle();
            }
            this.bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bmpBackedCanvas = new Canvas(this.bmp);
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    Bitmap getLastBitmap() {
        return this.bmp;
    }
}

