/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.wakeful;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import com.commonsware.cwac.wakeful.WakefulIntentService;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class AlarmReceiver
extends BroadcastReceiver {
    private static final String WAKEFUL_META_DATA = "com.commonsware.cwac.wakeful";

    public void onReceive(Context ctxt, Intent intent) {
        WakefulIntentService.AlarmListener listener = this.getListener(ctxt);
        if (listener != null) {
            if (intent.getAction() == null) {
                SharedPreferences prefs = ctxt.getSharedPreferences("com.commonsware.cwac.wakeful.WakefulIntentService", 0);
                prefs.edit().putLong("lastAlarm", System.currentTimeMillis()).commit();
                listener.sendWakefulWork(ctxt);
            } else {
                WakefulIntentService.scheduleAlarms(listener, ctxt, true);
            }
        }
    }

    private WakefulIntentService.AlarmListener getListener(Context ctxt) {
        PackageManager pm = ctxt.getPackageManager();
        ComponentName cn = new ComponentName(ctxt, ((Object)((Object)this)).getClass());
        try {
            ActivityInfo ai = pm.getReceiverInfo(cn, 128);
            XmlResourceParser xpp = ai.loadXmlMetaData(pm, WAKEFUL_META_DATA);
            while (xpp.getEventType() != 1) {
                if (xpp.getEventType() == 2 && xpp.getName().equals("WakefulIntentService")) {
                    String clsName = xpp.getAttributeValue(null, "listener");
                    Class<?> cls = Class.forName(clsName);
                    return (WakefulIntentService.AlarmListener)cls.newInstance();
                }
                xpp.next();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Cannot find own info???", e);
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException("Malformed metadata resource XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read resource XML", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Listener class not found", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Listener is not public or lacks public constructor", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not create instance of listener", e);
        }
        return null;
    }
}

