/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap;

import android.webkit.WebSettings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebViewReflect {
    private static Method mWebSettings_setDatabaseEnabled;
    private static Method mWebSettings_setDatabasePath;
    private static Method mWebSettings_setDomStorageEnabled;
    private static Method mWebSettings_setGeolocationEnabled;

    private static void setDatabaseEnabled(boolean e) throws IOException {
        try {
            mWebSettings_setDatabaseEnabled.invoke((Object)e, new Object[0]);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException(ite);
        }
        catch (IllegalAccessException ie) {
            System.err.println("unexpected " + ie);
        }
    }

    public static void checkCompatibility() {
        try {
            mWebSettings_setDatabaseEnabled = WebSettings.class.getMethod("setDatabaseEnabled", Boolean.TYPE);
            mWebSettings_setDatabasePath = WebSettings.class.getMethod("setDatabasePath", String.class);
            mWebSettings_setDomStorageEnabled = WebSettings.class.getMethod("setDomStorageEnabled", Boolean.TYPE);
            mWebSettings_setGeolocationEnabled = WebSettings.class.getMethod("setGeolocationEnabled", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static void setStorage(WebSettings setting, boolean enable, String path) {
        if (mWebSettings_setDatabaseEnabled != null) {
            try {
                mWebSettings_setDatabaseEnabled.invoke((Object)setting, enable);
                mWebSettings_setDatabasePath.invoke((Object)setting, path);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setGeolocationEnabled(WebSettings setting, boolean enable) {
        if (mWebSettings_setGeolocationEnabled != null) {
            try {
                mWebSettings_setGeolocationEnabled.invoke((Object)setting, enable);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Native Geolocation not supported - we're ok");
        }
    }

    public static void setDomStorage(WebSettings setting) {
        if (mWebSettings_setDomStorageEnabled != null) {
            try {
                mWebSettings_setDomStorageEnabled.invoke((Object)setting, true);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        WebViewReflect.checkCompatibility();
    }
}

