/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.Dispatcher;
import com.squareup.okhttp.Failure;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.net.HttpURLConnection;

final class Job
implements Runnable {
    final HttpURLConnection connection;
    final Request request;
    final Response.Receiver responseReceiver;
    final Dispatcher dispatcher;

    public Job(Dispatcher dispatcher, HttpURLConnection connection, Request request, Response.Receiver responseReceiver) {
        this.dispatcher = dispatcher;
        this.connection = connection;
        this.request = request;
        this.responseReceiver = responseReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.sendRequest();
            Response response = this.readResponse();
            this.responseReceiver.onResponse(response);
        }
        catch (IOException e) {
            this.responseReceiver.onFailure(new Failure.Builder().request(this.request).exception(e).build());
        }
        finally {
            this.connection.disconnect();
            this.dispatcher.finished(this);
        }
    }

    private HttpURLConnection sendRequest() throws IOException {
        for (int i = 0; i < this.request.headerCount(); ++i) {
            this.connection.addRequestProperty(this.request.headerName(i), this.request.headerValue(i));
        }
        Request.Body body = this.request.body();
        if (body != null) {
            this.connection.setDoOutput(true);
            long contentLength = body.contentLength();
            if (contentLength == -1L || contentLength > Integer.MAX_VALUE) {
                this.connection.setChunkedStreamingMode(0);
            } else {
                this.connection.setFixedLengthStreamingMode((int)contentLength);
            }
            body.writeTo(this.connection.getOutputStream());
        }
        return this.connection;
    }

    private Response readResponse() throws IOException {
        String name;
        int responseCode = this.connection.getResponseCode();
        Response.Builder responseBuilder = new Response.Builder(this.request, responseCode);
        int i = 0;
        while ((name = this.connection.getHeaderFieldKey(i)) != null) {
            String value = this.connection.getHeaderField(i);
            responseBuilder.addHeader(name, value);
            ++i;
        }
        responseBuilder.body(new Dispatcher.RealResponseBody(this.connection, this.connection.getInputStream()));
        return responseBuilder.build();
    }
}

