/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.IOException;
import java.lang.reflect.Type;
import retrofit.client.Response;
import retrofit.converter.ConversionException;
import retrofit.converter.Converter;
import retrofit.mime.TypedInput;

public class RetrofitError
extends RuntimeException {
    private final String url;
    private final Response response;
    private final Converter converter;
    private final Type successType;
    private final boolean networkError;

    public static RetrofitError networkError(String url, IOException exception) {
        return new RetrofitError(url, null, null, null, true, exception);
    }

    public static RetrofitError conversionError(String url, Response response, Converter converter, Type successType, ConversionException exception) {
        return new RetrofitError(url, response, converter, successType, false, exception);
    }

    public static RetrofitError httpError(String url, Response response, Converter converter, Type successType) {
        return new RetrofitError(url, response, converter, successType, false, null);
    }

    public static RetrofitError unexpectedError(String url, Throwable exception) {
        return new RetrofitError(url, null, null, null, false, exception);
    }

    private RetrofitError(String url, Response response, Converter converter, Type successType, boolean networkError, Throwable exception) {
        super(exception);
        this.url = url;
        this.response = response;
        this.converter = converter;
        this.successType = successType;
        this.networkError = networkError;
    }

    public String getUrl() {
        return this.url;
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean isNetworkError() {
        return this.networkError;
    }

    public Object getBody() {
        TypedInput body = this.response.getBody();
        if (body == null) {
            return null;
        }
        try {
            return this.converter.fromBody(body, this.successType);
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getBodyAs(Type type) {
        TypedInput body = this.response.getBody();
        if (body == null) {
            return null;
        }
        try {
            return this.converter.fromBody(body, type);
        }
        catch (ConversionException e) {
            throw new RuntimeException(e);
        }
    }
}

