/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.util.concurrent.Executor;
import retrofit.Callback;
import retrofit.ResponseWrapper;
import retrofit.RetrofitError;

abstract class CallbackRunnable<T>
implements Runnable {
    private final Callback<T> callback;
    private final Executor callbackExecutor;

    CallbackRunnable(Callback<T> callback, Executor callbackExecutor) {
        this.callback = callback;
        this.callbackExecutor = callbackExecutor;
    }

    @Override
    public final void run() {
        try {
            final ResponseWrapper wrapper = this.obtainResponse();
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.success(wrapper.responseBody, wrapper.response);
                }
            });
        }
        catch (RetrofitError e) {
            this.callbackExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    CallbackRunnable.this.callback.failure(e);
                }
            });
        }
    }

    public abstract ResponseWrapper obtainResponse();
}

