/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.loaderex;

import android.annotation.TargetApi;
import android.content.AsyncTaskLoader;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;

@TargetApi(value=11)
public class SharedPreferencesLoader
extends AsyncTaskLoader<SharedPreferences>
implements SharedPreferences.OnSharedPreferenceChangeListener {
    private SharedPreferences prefs = null;

    public static void persist(final SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT >= 9) {
            editor.apply();
        } else {
            new Thread(){

                @Override
                public void run() {
                    editor.commit();
                }
            }.start();
        }
    }

    public SharedPreferencesLoader(Context context) {
        super(context);
    }

    public SharedPreferences loadInBackground() {
        this.prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
        this.prefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        return this.prefs;
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        this.onContentChanged();
    }

    protected void onStartLoading() {
        if (this.prefs != null) {
            this.deliverResult(this.prefs);
        }
        if (this.takeContentChanged() || this.prefs == null) {
            this.forceLoad();
        }
    }
}

