/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.provider.Settings;
import com.squareup.picasso.Downloader;
import com.squareup.picasso.OkHttpDownloader;
import com.squareup.picasso.Request;
import com.squareup.picasso.UrlConnectionDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ThreadFactory;

final class Utils {
    static final String THREAD_PREFIX = "Picasso-";
    static final String THREAD_IDLE_NAME = "Picasso-Idle";
    static final int DEFAULT_READ_TIMEOUT = 20000;
    static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    private static final String PICASSO_CACHE = "picasso-cache";
    private static final int KEY_PADDING = 50;
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    private static final int MAX_MEM_CACHE_SIZE = 0x1E00000;

    private Utils() {
    }

    static int getBitmapBytes(Bitmap bitmap) {
        int result = Build.VERSION.SDK_INT >= 12 ? BitmapHoneycombMR1.getByteCount(bitmap) : bitmap.getRowBytes() * bitmap.getHeight();
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return result;
    }

    static void checkNotMain() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Method call should not happen from the main thread.");
        }
    }

    static String createKey(Request data) {
        StringBuilder builder;
        if (data.uri != null) {
            String path = data.uri.toString();
            builder = new StringBuilder(path.length() + 50);
            builder.append(path);
        } else {
            builder = new StringBuilder(50);
            builder.append(data.resourceId);
        }
        builder.append('\n');
        if (data.rotationDegrees != 0.0f) {
            builder.append("rotation:").append(data.rotationDegrees);
            if (data.hasRotationPivot) {
                builder.append('@').append(data.rotationPivotX).append('x').append(data.rotationPivotY);
            }
            builder.append('\n');
        }
        if (data.targetWidth != 0) {
            builder.append("resize:").append(data.targetWidth).append('x').append(data.targetHeight);
            builder.append('\n');
        }
        if (data.centerCrop) {
            builder.append("centerCrop\n");
        } else if (data.centerInside) {
            builder.append("centerInside\n");
        }
        if (data.transformations != null) {
            int count = data.transformations.size();
            for (int i = 0; i < count; ++i) {
                builder.append(data.transformations.get(i).key());
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    static void closeQuietly(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static boolean parseResponseSourceHeader(String header) {
        if (header == null) {
            return false;
        }
        String[] parts = header.split(" ", 2);
        if ("CACHE".equals(parts[0])) {
            return true;
        }
        if (parts.length == 1) {
            return false;
        }
        try {
            return "CONDITIONAL_CACHE".equals(parts[0]) && Integer.parseInt(parts[1]) == 304;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static Downloader createDefaultDownloader(Context context) {
        try {
            Class.forName("com.squareup.okhttp.OkHttpClient");
            return OkHttpLoaderCreator.create(context);
        }
        catch (ClassNotFoundException e) {
            return new UrlConnectionDownloader(context);
        }
    }

    static File createDefaultCacheDir(Context context) {
        File cache = new File(context.getApplicationContext().getCacheDir(), PICASSO_CACHE);
        if (!cache.exists()) {
            cache.mkdirs();
        }
        return cache;
    }

    static long calculateDiskCacheSize(File dir) {
        long size = 0x500000L;
        try {
            StatFs statFs = new StatFs(dir.getAbsolutePath());
            long available = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
            size = available / 50L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Math.max(Math.min(size, 0x3200000L), 0x500000L);
    }

    static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap && Build.VERSION.SDK_INT >= 11) {
            memoryClass = ActivityManagerHoneycomb.getLargeMemoryClass(am);
        }
        int size = 0x100000 * memoryClass / 7;
        return Math.min(size, 0x1E00000);
    }

    static boolean isAirplaneModeOn(Context context) {
        ContentResolver contentResolver = context.getContentResolver();
        return Settings.System.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0) != 0;
    }

    static boolean hasPermission(Context context, String permission) {
        return context.checkCallingOrSelfPermission(permission) == 0;
    }

    private static class OkHttpLoaderCreator {
        private OkHttpLoaderCreator() {
        }

        static Downloader create(Context context) {
            return new OkHttpDownloader(context);
        }
    }

    @TargetApi(value=12)
    private static class BitmapHoneycombMR1 {
        private BitmapHoneycombMR1() {
        }

        static int getByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }

    private static class PicassoThread
    extends Thread {
        public PicassoThread(Runnable r) {
            super(r);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    static class PicassoThreadFactory
    implements ThreadFactory {
        PicassoThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new PicassoThread(r);
        }
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

