/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.net.Uri;
import com.squareup.picasso.Transformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Request {
    public final Uri uri;
    public final int resourceId;
    public final List<Transformation> transformations;
    public final int targetWidth;
    public final int targetHeight;
    public final boolean centerCrop;
    public final boolean centerInside;
    public final float rotationDegrees;
    public final float rotationPivotX;
    public final float rotationPivotY;
    public final boolean hasRotationPivot;

    private Request(Uri uri, int resourceId, List<Transformation> transformations, int targetWidth, int targetHeight, boolean centerCrop, boolean centerInside, float rotationDegrees, float rotationPivotX, float rotationPivotY, boolean hasRotationPivot) {
        this.uri = uri;
        this.resourceId = resourceId;
        this.transformations = transformations == null ? null : Collections.unmodifiableList(transformations);
        this.targetWidth = targetWidth;
        this.targetHeight = targetHeight;
        this.centerCrop = centerCrop;
        this.centerInside = centerInside;
        this.rotationDegrees = rotationDegrees;
        this.rotationPivotX = rotationPivotX;
        this.rotationPivotY = rotationPivotY;
        this.hasRotationPivot = hasRotationPivot;
    }

    String getName() {
        if (this.uri != null) {
            return this.uri.getPath();
        }
        return Integer.toHexString(this.resourceId);
    }

    public boolean hasSize() {
        return this.targetWidth != 0;
    }

    boolean needsTransformation() {
        return this.needsMatrixTransform() || this.hasCustomTransformations();
    }

    boolean needsMatrixTransform() {
        return this.targetWidth != 0 || this.rotationDegrees != 0.0f;
    }

    boolean hasCustomTransformations() {
        return this.transformations != null;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public static final class Builder {
        private Uri uri;
        private int resourceId;
        private int targetWidth;
        private int targetHeight;
        private boolean centerCrop;
        private boolean centerInside;
        private float rotationDegrees;
        private float rotationPivotX;
        private float rotationPivotY;
        private boolean hasRotationPivot;
        private List<Transformation> transformations;

        public Builder(Uri uri) {
            this.setUri(uri);
        }

        public Builder(int resourceId) {
            this.setResourceId(resourceId);
        }

        Builder(Uri uri, int resourceId) {
            this.uri = uri;
            this.resourceId = resourceId;
        }

        private Builder(Request request) {
            this.uri = request.uri;
            this.resourceId = request.resourceId;
            this.targetWidth = request.targetWidth;
            this.targetHeight = request.targetHeight;
            this.centerCrop = request.centerCrop;
            this.centerInside = request.centerInside;
            this.rotationDegrees = request.rotationDegrees;
            this.rotationPivotX = request.rotationPivotX;
            this.rotationPivotY = request.rotationPivotY;
            this.hasRotationPivot = request.hasRotationPivot;
            if (request.transformations != null) {
                this.transformations = new ArrayList<Transformation>(request.transformations);
            }
        }

        boolean hasImage() {
            return this.uri != null || this.resourceId != 0;
        }

        boolean hasSize() {
            return this.targetWidth != 0;
        }

        public Builder setUri(Uri uri) {
            if (uri == null) {
                throw new IllegalArgumentException("Image URI may not be null.");
            }
            this.uri = uri;
            this.resourceId = 0;
            return this;
        }

        public Builder setResourceId(int resourceId) {
            if (resourceId == 0) {
                throw new IllegalArgumentException("Image resource ID may not be 0.");
            }
            this.resourceId = resourceId;
            this.uri = null;
            return this;
        }

        public Builder resize(int targetWidth, int targetHeight) {
            if (targetWidth <= 0) {
                throw new IllegalArgumentException("Width must be positive number.");
            }
            if (targetHeight <= 0) {
                throw new IllegalArgumentException("Height must be positive number.");
            }
            this.targetWidth = targetWidth;
            this.targetHeight = targetHeight;
            return this;
        }

        public Builder clearResize() {
            this.targetWidth = 0;
            this.targetHeight = 0;
            this.centerCrop = false;
            this.centerInside = false;
            return this;
        }

        public Builder centerCrop() {
            if (this.centerInside) {
                throw new IllegalStateException("Center crop can not be used after calling centerInside");
            }
            this.centerCrop = true;
            return this;
        }

        public Builder clearCenterCrop() {
            this.centerCrop = false;
            return this;
        }

        public Builder centerInside() {
            if (this.centerCrop) {
                throw new IllegalStateException("Center inside can not be used after calling centerCrop");
            }
            this.centerInside = true;
            return this;
        }

        public Builder clearCenterInside() {
            this.centerInside = false;
            return this;
        }

        public Builder rotate(float degrees) {
            this.rotationDegrees = degrees;
            return this;
        }

        public Builder rotate(float degrees, float pivotX, float pivotY) {
            this.rotationDegrees = degrees;
            this.rotationPivotX = pivotX;
            this.rotationPivotY = pivotY;
            this.hasRotationPivot = true;
            return this;
        }

        public Builder clearRotation() {
            this.rotationDegrees = 0.0f;
            this.rotationPivotX = 0.0f;
            this.rotationPivotY = 0.0f;
            this.hasRotationPivot = false;
            return this;
        }

        public Builder transform(Transformation transformation) {
            if (transformation == null) {
                throw new IllegalArgumentException("Transformation must not be null.");
            }
            if (this.transformations == null) {
                this.transformations = new ArrayList<Transformation>(2);
            }
            this.transformations.add(transformation);
            return this;
        }

        public Request build() {
            if (this.centerInside && this.centerCrop) {
                throw new IllegalStateException("Center crop and center inside can not be used together.");
            }
            if (this.centerCrop && this.targetWidth == 0) {
                throw new IllegalStateException("Center crop requires calling resize.");
            }
            if (this.centerInside && this.targetWidth == 0) {
                throw new IllegalStateException("Center inside requires calling resize.");
            }
            return new Request(this.uri, this.resourceId, this.transformations, this.targetWidth, this.targetHeight, this.centerCrop, this.centerInside, this.rotationDegrees, this.rotationPivotX, this.rotationPivotY, this.hasRotationPivot);
        }
    }
}

