/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;

final class PicassoDrawable
extends Drawable {
    private static final Paint DEBUG_PAINT = new Paint();
    private static final float FADE_DURATION = 200.0f;
    private final boolean debugging;
    private final float density;
    private final Picasso.LoadedFrom loadedFrom;
    final BitmapDrawable image;
    Drawable placeholder;
    long startTimeMillis;
    boolean animating;

    static void setBitmap(ImageView target, Context context, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        Drawable placeholder = target.getDrawable();
        PicassoDrawable drawable = new PicassoDrawable(context, placeholder, bitmap, loadedFrom, noFade, debugging);
        target.setImageDrawable((Drawable)drawable);
    }

    static void setPlaceholder(ImageView target, int placeholderResId, Drawable placeholderDrawable) {
        if (placeholderResId != 0) {
            target.setImageResource(placeholderResId);
        } else {
            target.setImageDrawable(placeholderDrawable);
        }
    }

    PicassoDrawable(Context context, Drawable placeholder, Bitmap bitmap, Picasso.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        boolean fade;
        Resources res = context.getResources();
        this.debugging = debugging;
        this.density = res.getDisplayMetrics().density;
        this.loadedFrom = loadedFrom;
        this.image = new BitmapDrawable(res, bitmap);
        boolean bl = fade = loadedFrom != Picasso.LoadedFrom.MEMORY && !noFade;
        if (fade) {
            this.placeholder = placeholder;
            this.animating = true;
            this.startTimeMillis = SystemClock.uptimeMillis();
        }
    }

    public void draw(Canvas canvas) {
        if (!this.animating) {
            this.image.draw(canvas);
        } else {
            if (this.placeholder != null) {
                this.placeholder.draw(canvas);
            }
            float normalized = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / 200.0f;
            int alpha = (int)(255.0f * normalized);
            if (normalized >= 1.0f) {
                this.animating = false;
                this.placeholder = null;
                this.image.draw(canvas);
            } else {
                this.image.setAlpha(alpha);
                this.image.draw(canvas);
                this.image.setAlpha(255);
                this.invalidateSelf();
            }
        }
        if (this.debugging) {
            this.drawDebugIndicator(canvas);
        }
    }

    public int getIntrinsicWidth() {
        return this.image.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.image.getIntrinsicHeight();
    }

    public void setAlpha(int alpha) {
        if (this.placeholder != null) {
            this.placeholder.setAlpha(alpha);
        }
        this.image.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.placeholder != null) {
            this.placeholder.setColorFilter(cf);
        }
        this.image.setColorFilter(cf);
    }

    public int getOpacity() {
        return this.image.getOpacity();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.image.setBounds(bounds);
        if (this.placeholder != null) {
            this.setBounds(this.placeholder);
        }
    }

    private void setBounds(Drawable drawable) {
        int drawableHeight;
        Rect bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        float ratio = (float)width / (float)height;
        int drawableWidth = drawable.getIntrinsicWidth();
        float drawableRatio = (float)drawableWidth / (float)(drawableHeight = drawable.getIntrinsicHeight());
        if (drawableRatio < ratio) {
            float scale = (float)height / (float)drawableHeight;
            int scaledDrawableWidth = (int)((float)drawableWidth * scale);
            int drawableLeft = bounds.left - (scaledDrawableWidth - width) / 2;
            int drawableRight = drawableLeft + scaledDrawableWidth;
            drawable.setBounds(drawableLeft, bounds.top, drawableRight, bounds.bottom);
        } else {
            float scale = (float)width / (float)drawableWidth;
            int scaledDrawableHeight = (int)((float)drawableHeight * scale);
            int drawableTop = bounds.top - (scaledDrawableHeight - height) / 2;
            int drawableBottom = drawableTop + scaledDrawableHeight;
            drawable.setBounds(bounds.left, drawableTop, bounds.right, drawableBottom);
        }
    }

    private void drawDebugIndicator(Canvas canvas) {
        DEBUG_PAINT.setColor(-1);
        Path path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(16.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
        DEBUG_PAINT.setColor(this.loadedFrom.debugColor);
        path = PicassoDrawable.getTrianglePath(new Point(0, 0), (int)(15.0f * this.density));
        canvas.drawPath(path, DEBUG_PAINT);
    }

    private static Path getTrianglePath(Point p1, int width) {
        Point p2 = new Point(p1.x + width, p1.y);
        Point p3 = new Point(p1.x, p1.y + width);
        Path path = new Path();
        path.moveTo((float)p1.x, (float)p1.y);
        path.lineTo((float)p2.x, (float)p2.y);
        path.lineTo((float)p3.x, (float)p3.y);
        return path;
    }
}

