/*
 * Decompiled with CFR 0.152.
 */
package com.commonsware.cwac.preso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.commonsware.cwac.preso.Mirror;

public class MirroringFrameLayout
extends FrameLayout {
    private Mirror mirror = null;
    private Bitmap bmp = null;
    private Canvas bmpBackedCanvas = null;
    private Rect rect = new Rect();

    public MirroringFrameLayout(Context context) {
        this(context, null);
    }

    public MirroringFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
    }

    public void setMirror(Mirror mirror) {
        this.mirror = mirror;
        mirror.setSource(this);
    }

    public void draw(Canvas canvas) {
        this.bmp.eraseColor(0);
        super.draw(this.bmpBackedCanvas);
        this.getDrawingRect(this.rect);
        canvas.drawBitmap(this.bmp, null, this.rect, null);
        if (this.mirror != null) {
            this.mirror.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.bmp == null || this.bmp.getWidth() != w || this.bmp.getHeight() != h) {
            if (this.bmp != null) {
                this.bmp.recycle();
            }
            this.bmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bmpBackedCanvas = new Canvas(this.bmp);
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    Bitmap getLastBitmap() {
        return this.bmp;
    }
}

