/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xml.impl.xmlbeans;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;

public class LogicalEquality {
    public static boolean nodesEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = false;
        if (xmlCursor.isStartdoc()) {
            xmlCursor.toFirstContentToken();
        }
        if (xmlCursor2.isStartdoc()) {
            xmlCursor2.toFirstContentToken();
        }
        if (xmlCursor.currentTokenType() == xmlCursor2.currentTokenType()) {
            if (xmlCursor.isEnddoc()) {
                bl = true;
            } else if (xmlCursor.isAttr()) {
                bl = LogicalEquality.attributesEqual(xmlCursor, xmlCursor2);
            } else if (xmlCursor.isText()) {
                bl = LogicalEquality.textNodesEqual(xmlCursor, xmlCursor2);
            } else if (xmlCursor.isComment()) {
                bl = LogicalEquality.commentsEqual(xmlCursor, xmlCursor2);
            } else if (xmlCursor.isProcinst()) {
                bl = LogicalEquality.processingInstructionsEqual(xmlCursor, xmlCursor2);
            } else if (xmlCursor.isStart()) {
                bl = LogicalEquality.elementsEqual(xmlCursor, xmlCursor2);
            }
        }
        return bl;
    }

    private static boolean elementsEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = true;
        if (!LogicalEquality.qnamesEqual(xmlCursor.getName(), xmlCursor2.getName())) {
            bl = false;
        } else {
            LogicalEquality.nextToken(xmlCursor);
            LogicalEquality.nextToken(xmlCursor2);
            do {
                if (xmlCursor.currentTokenType() != xmlCursor2.currentTokenType()) {
                    bl = false;
                    break;
                }
                if (xmlCursor.isEnd() || xmlCursor.isEnddoc()) break;
                if (xmlCursor.isAttr()) {
                    bl = LogicalEquality.attributeListsEqual(xmlCursor, xmlCursor2);
                    continue;
                }
                if (xmlCursor.isText()) {
                    bl = LogicalEquality.textNodesEqual(xmlCursor, xmlCursor2);
                } else if (xmlCursor.isComment()) {
                    bl = LogicalEquality.commentsEqual(xmlCursor, xmlCursor2);
                } else if (xmlCursor.isProcinst()) {
                    bl = LogicalEquality.processingInstructionsEqual(xmlCursor, xmlCursor2);
                } else if (xmlCursor.isStart()) {
                    bl = LogicalEquality.elementsEqual(xmlCursor, xmlCursor2);
                }
                LogicalEquality.nextToken(xmlCursor);
                LogicalEquality.nextToken(xmlCursor2);
            } while (bl);
        }
        return bl;
    }

    private static boolean attributeListsEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = true;
        TreeMap treeMap = LogicalEquality.loadAttributeMap(xmlCursor);
        TreeMap treeMap2 = LogicalEquality.loadAttributeMap(xmlCursor2);
        if (treeMap.size() != treeMap2.size()) {
            bl = false;
        } else {
            Set set = treeMap.keySet();
            Set set2 = treeMap2.keySet();
            Iterator iterator = set.iterator();
            Iterator iterator2 = set2.iterator();
            while (bl && iterator.hasNext()) {
                QName qName;
                String string;
                String string2 = (String)iterator.next();
                if (!string2.equals(string = (String)iterator2.next())) {
                    bl = false;
                    continue;
                }
                QName qName2 = (QName)treeMap.get(string2);
                if (LogicalEquality.qnamesEqual(qName2, qName = (QName)treeMap2.get(string))) continue;
                bl = false;
            }
        }
        return bl;
    }

    private static TreeMap loadAttributeMap(XmlCursor xmlCursor) {
        TreeMap<String, QName> treeMap = new TreeMap<String, QName>();
        while (xmlCursor.isAttr()) {
            treeMap.put(xmlCursor.getTextValue(), xmlCursor.getName());
            LogicalEquality.nextToken(xmlCursor);
        }
        return treeMap;
    }

    private static boolean attributesEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = false;
        if (xmlCursor.isAttr() && xmlCursor2.isAttr() && LogicalEquality.qnamesEqual(xmlCursor.getName(), xmlCursor2.getName()) && xmlCursor.getTextValue().equals(xmlCursor2.getTextValue())) {
            bl = true;
        }
        return bl;
    }

    private static boolean textNodesEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = false;
        if (xmlCursor.isText() && xmlCursor2.isText() && xmlCursor.getChars().equals(xmlCursor2.getChars())) {
            bl = true;
        }
        return bl;
    }

    private static boolean commentsEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = false;
        if (xmlCursor.isComment() && xmlCursor2.isComment() && xmlCursor.getTextValue().equals(xmlCursor2.getTextValue())) {
            bl = true;
        }
        return bl;
    }

    private static boolean processingInstructionsEqual(XmlCursor xmlCursor, XmlCursor xmlCursor2) {
        boolean bl = false;
        if (xmlCursor.isProcinst() && xmlCursor2.isProcinst() && LogicalEquality.qnamesEqual(xmlCursor.getName(), xmlCursor2.getName()) && xmlCursor.getTextValue().equals(xmlCursor2.getTextValue())) {
            bl = true;
        }
        return bl;
    }

    private static boolean qnamesEqual(QName qName, QName qName2) {
        boolean bl = false;
        if (qName.getNamespaceURI().equals(qName2.getNamespaceURI()) && qName.getLocalPart().equals(qName2.getLocalPart())) {
            return true;
        }
        return bl;
    }

    private static void nextToken(XmlCursor xmlCursor) {
        do {
            xmlCursor.toNextToken();
        } while (xmlCursor.isText() && xmlCursor.getChars().trim().length() <= 0);
    }
}

