/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptOrFnNode;

public class Node {
    public static final int FUNCTION_PROP = 1;
    public static final int LOCAL_PROP = 2;
    public static final int LOCAL_BLOCK_PROP = 3;
    public static final int REGEXP_PROP = 4;
    public static final int CASEARRAY_PROP = 5;
    public static final int TARGETBLOCK_PROP = 6;
    public static final int VARIABLE_PROP = 7;
    public static final int ISNUMBER_PROP = 8;
    public static final int DIRECTCALL_PROP = 9;
    public static final int SPECIALCALL_PROP = 10;
    public static final int SKIP_INDEXES_PROP = 11;
    public static final int OBJECT_IDS_PROP = 12;
    public static final int INCRDECR_PROP = 13;
    public static final int CATCH_SCOPE_PROP = 14;
    public static final int LABEL_ID_PROP = 15;
    public static final int MEMBER_TYPE_PROP = 16;
    public static final int NAME_PROP = 17;
    public static final int CONTROL_BLOCK_PROP = 18;
    public static final int PARENTHESIZED_PROP = 19;
    public static final int GENERATOR_END_PROP = 20;
    public static final int DESTRUCTURING_ARRAY_LENGTH = 21;
    public static final int DESTRUCTURING_NAMES = 22;
    public static final int LAST_PROP = 22;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NON_SPECIALCALL = 0;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_WITH = 2;
    public static final int DECR_FLAG = 1;
    public static final int POST_FLAG = 2;
    public static final int PROPERTY_FLAG = 1;
    public static final int ATTRIBUTE_FLAG = 2;
    public static final int DESCENDANTS_FLAG = 4;
    static final int END_UNREACHED = 0;
    static final int END_DROPS_OFF = 1;
    static final int END_RETURNS = 2;
    static final int END_RETURNS_VALUE = 4;
    static final int END_YIELDS = 8;
    int type;
    Node next;
    private Node first;
    private Node last;
    protected int lineno = -1;
    private PropListItem propListHead;

    public Node(int n) {
        this.type = n;
    }

    public Node(int n, Node node) {
        this.type = n;
        this.first = this.last = node;
        node.next = null;
    }

    public Node(int n, Node node, Node node2) {
        this.type = n;
        this.first = node;
        this.last = node2;
        node.next = node2;
        node2.next = null;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        this.type = n;
        this.first = node;
        this.last = node3;
        node.next = node2;
        node2.next = node3;
        node3.next = null;
    }

    public Node(int n, int n2) {
        this.type = n;
        this.lineno = n2;
    }

    public Node(int n, Node node, int n2) {
        this(n, node);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2, int n2) {
        this(n, node, node2);
        this.lineno = n2;
    }

    public Node(int n, Node node, Node node2, Node node3, int n2) {
        this(n, node, node2, node3);
        this.lineno = n2;
    }

    public static Node newNumber(double d) {
        return new NumberNode(d);
    }

    public static Node newString(String string) {
        return new StringNode(41, string);
    }

    public static Node newString(int n, String string) {
        return new StringNode(n, string);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node node) {
        if (node == this.first) {
            return null;
        }
        Node node2 = this.first;
        while (node2.next != node) {
            node2 = node2.next;
            if (node2 != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return node2;
    }

    public Node getLastSibling() {
        Node node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    public void addChildToFront(Node node) {
        node.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        }
    }

    public void addChildToBack(Node node) {
        node.next = null;
        if (this.last == null) {
            this.first = this.last = node;
            return;
        }
        this.last.next = node;
        this.last = node;
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node.getLastSibling();
        node2.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node2;
        }
    }

    public void addChildrenToBack(Node node) {
        if (this.last != null) {
            this.last.next = node;
        }
        this.last = node.getLastSibling();
        if (this.first == null) {
            this.first = node;
        }
    }

    public void addChildBefore(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildBefore");
        }
        if (this.first == node2) {
            node.next = this.first;
            this.first = node;
            return;
        }
        Node node3 = this.getChildBefore(node2);
        this.addChildAfter(node, node3);
    }

    public void addChildAfter(Node node, Node node2) {
        if (node.next != null) {
            throw new RuntimeException("newChild had siblings in addChildAfter");
        }
        node.next = node2.next;
        node2.next = node;
        if (this.last == node2) {
            this.last = node;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.first = this.first.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChild(Node node, Node node2) {
        node2.next = node.next;
        if (node == this.first) {
            this.first = node2;
        } else {
            Node node3 = this.getChildBefore(node);
            node3.next = node2;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
    }

    public void replaceChildAfter(Node node, Node node2) {
        Node node3 = node.next;
        node2.next = node3.next;
        node.next = node2;
        if (node3 == this.last) {
            this.last = node2;
        }
        node3.next = null;
    }

    private static final String propToString(int n) {
        return null;
    }

    private PropListItem lookupProperty(int n) {
        PropListItem propListItem = this.propListHead;
        while (propListItem != null && n != propListItem.type) {
            propListItem = propListItem.next;
        }
        return propListItem;
    }

    private PropListItem ensureProperty(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            propListItem = new PropListItem();
            propListItem.type = n;
            propListItem.next = this.propListHead;
            this.propListHead = propListItem;
        }
        return propListItem;
    }

    public void removeProp(int n) {
        PropListItem propListItem = this.propListHead;
        if (propListItem != null) {
            PropListItem propListItem2 = null;
            while (propListItem.type != n) {
                propListItem2 = propListItem;
                propListItem = propListItem.next;
                if (propListItem != null) continue;
                return;
            }
            if (propListItem2 == null) {
                this.propListHead = propListItem.next;
            } else {
                propListItem2.next = propListItem.next;
            }
        }
    }

    public Object getProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return null;
        }
        return propListItem.objectValue;
    }

    public int getIntProp(int n, int n2) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return n2;
        }
        return propListItem.intValue;
    }

    public int getExistingIntProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            Kit.codeBug();
        }
        return propListItem.intValue;
    }

    public void putProp(int n, Object object) {
        if (object == null) {
            this.removeProp(n);
        } else {
            PropListItem propListItem = this.ensureProperty(n);
            propListItem.objectValue = object;
        }
    }

    public void putIntProp(int n, int n2) {
        PropListItem propListItem = this.ensureProperty(n);
        propListItem.intValue = n2;
    }

    public int getLineno() {
        return this.lineno;
    }

    public final double getDouble() {
        return ((NumberNode)this).number;
    }

    public final void setDouble(double d) {
        ((NumberNode)this).number = d;
    }

    public final String getString() {
        return ((StringNode)this).str;
    }

    public final void setString(String string) {
        if (string == null) {
            Kit.codeBug();
        }
        ((StringNode)this).str = string;
    }

    public final Scope getScope() {
        return ((StringNode)this).scope;
    }

    public final void setScope(Scope scope) {
        if (scope == null) {
            Kit.codeBug();
        }
        if (!(this instanceof StringNode)) {
            throw Kit.codeBug();
        }
        ((StringNode)this).scope = scope;
    }

    public static Node newTarget() {
        return new Node(130);
    }

    public final int labelId() {
        if (this.type != 130 && this.type != 72) {
            Kit.codeBug();
        }
        return this.getIntProp(15, -1);
    }

    public void labelId(int n) {
        if (this.type != 130 && this.type != 72) {
            Kit.codeBug();
        }
        this.putIntProp(15, n);
    }

    public boolean hasConsistentReturnUsage() {
        int n = this.endCheck();
        return (n & 4) == 0 || (n & 0xB) == 0;
    }

    private int endCheckIf() {
        int n = 0;
        Node node = this.next;
        Node node2 = ((Jump)this).target;
        n = node.endCheck();
        n = node2 != null ? (n |= node2.endCheck()) : (n |= 1);
        return n;
    }

    private int endCheckSwitch() {
        int n = 0;
        Node node = this.first.next;
        while (node != null && node.type == 114) {
            n |= ((Jump)node).target.endCheck();
            node = node.next;
        }
        n &= 0xFFFFFFFE;
        node = ((Jump)this).getDefault();
        n = node != null ? (n |= node.endCheck()) : (n |= 1);
        return n |= this.getIntProp(18, 0);
    }

    private int endCheckTry() {
        int n = 0;
        Node node = ((Jump)this).getFinally();
        n = node != null ? node.next.first.endCheck() : 1;
        if ((n & 1) != 0) {
            n &= 0xFFFFFFFE;
            n |= this.first.endCheck();
            node = ((Jump)this).target;
            if (node != null) {
                node = node.next.first;
                while (node != null) {
                    n |= node.next.first.next.first.endCheck();
                    node = node.next.next;
                }
            }
        }
        return n;
    }

    private int endCheckLoop() {
        int n = 0;
        Node node = this.first;
        while (node.next != this.last) {
            node = node.next;
        }
        if (node.type != 6) {
            return 1;
        }
        n = ((Jump)node).target.next.endCheck();
        if (node.first.type == 45) {
            n &= 0xFFFFFFFE;
        }
        return n |= this.getIntProp(18, 0);
    }

    private int endCheckBlock() {
        int n = 1;
        Node node = this.first;
        while (n & true && node != null) {
            n &= 0xFFFFFFFE;
            n |= node.endCheck();
            node = node.next;
        }
        return n;
    }

    private int endCheckLabel() {
        int n = 0;
        n = this.next.endCheck();
        return n |= this.getIntProp(18, 0);
    }

    private int endCheckBreak() {
        Jump jump = ((Jump)this).jumpNode;
        jump.putIntProp(18, 1);
        return 0;
    }

    private int endCheck() {
        switch (this.type) {
            case 119: {
                return this.endCheckBreak();
            }
            case 132: {
                if (this.first != null) {
                    return this.first.endCheck();
                }
                return 1;
            }
            case 72: {
                return 8;
            }
            case 50: 
            case 120: {
                return 0;
            }
            case 4: {
                if (this.first != null) {
                    return 4;
                }
                return 2;
            }
            case 130: {
                if (this.next != null) {
                    return this.next.endCheck();
                }
                return 1;
            }
            case 131: {
                return this.endCheckLoop();
            }
            case 128: 
            case 140: {
                if (this.first == null) {
                    return 1;
                }
                switch (this.first.type) {
                    case 129: {
                        return this.first.endCheckLabel();
                    }
                    case 7: {
                        return this.first.endCheckIf();
                    }
                    case 113: {
                        return this.first.endCheckSwitch();
                    }
                    case 80: {
                        return this.first.endCheckTry();
                    }
                }
                return this.endCheckBlock();
            }
        }
        return 1;
    }

    public boolean hasSideEffects() {
        switch (this.type) {
            case 88: 
            case 132: {
                if (this.last != null) {
                    return this.last.hasSideEffects();
                }
                return true;
            }
            case 101: {
                if (this.first == null || this.first.next == null || this.first.next.next == null) {
                    Kit.codeBug();
                }
                return this.first.next.hasSideEffects() && this.first.next.next.hasSideEffects();
            }
            case 103: 
            case 104: {
                if (this.first == null || this.last == null) {
                    Kit.codeBug();
                }
                return this.first.hasSideEffects() || this.last.hasSideEffects();
            }
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: 
            case 35: 
            case 37: 
            case 38: 
            case 50: 
            case 51: 
            case 56: 
            case 57: 
            case 64: 
            case 68: 
            case 69: 
            case 70: 
            case 72: 
            case 80: 
            case 81: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 105: 
            case 106: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 152: 
            case 153: 
            case 157: 
            case 158: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.type);
    }

    private void toString(ObjToIntMap objToIntMap, StringBuffer stringBuffer) {
    }

    public String toStringTree(ScriptOrFnNode scriptOrFnNode) {
        return null;
    }

    private static void toStringTreeHelper(ScriptOrFnNode scriptOrFnNode, Node node, ObjToIntMap objToIntMap, int n, StringBuffer stringBuffer) {
    }

    private static void generatePrintIds(Node node, ObjToIntMap objToIntMap) {
    }

    private static void appendPrintId(Node node, ObjToIntMap objToIntMap, StringBuffer stringBuffer) {
    }

    private static class PropListItem {
        PropListItem next;
        int type;
        int intValue;
        Object objectValue;

        private PropListItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Scope
    extends Jump {
        protected LinkedHashMap<String, Symbol> symbolTable;
        private Scope parent;
        private ScriptOrFnNode top;

        public Scope(int n) {
            super(n);
        }

        public Scope(int n, int n2) {
            super(n, n2);
        }

        public Scope(int n, Node node, int n2) {
            super(n, node, n2);
        }

        public static Scope splitScope(Scope scope) {
            Scope scope2 = new Scope(scope.getType());
            scope2.symbolTable = scope.symbolTable;
            scope.symbolTable = null;
            scope2.parent = scope.parent;
            scope.parent = scope2;
            scope2.top = scope.top;
            return scope2;
        }

        public static void joinScopes(Scope scope, Scope scope2) {
            scope.ensureSymbolTable();
            scope2.ensureSymbolTable();
            if (!Collections.disjoint(scope.symbolTable.keySet(), scope2.symbolTable.keySet())) {
                throw Kit.codeBug();
            }
            scope2.symbolTable.putAll(scope.symbolTable);
        }

        public void setParent(Scope scope) {
            this.parent = scope;
            this.top = scope == null ? (ScriptOrFnNode)this : scope.top;
        }

        public Scope getParentScope() {
            return this.parent;
        }

        public Scope getDefiningScope(String string) {
            Scope scope = this;
            while (scope != null) {
                if (scope.symbolTable != null && scope.symbolTable.containsKey(string)) {
                    return scope;
                }
                scope = scope.parent;
            }
            return null;
        }

        public Symbol getSymbol(String string) {
            return this.symbolTable == null ? null : this.symbolTable.get(string);
        }

        public void putSymbol(String string, Symbol symbol) {
            this.ensureSymbolTable();
            this.symbolTable.put(string, symbol);
            symbol.containingTable = this;
            this.top.addSymbol(symbol);
        }

        public Map<String, Symbol> getSymbolTable() {
            return this.symbolTable;
        }

        private void ensureSymbolTable() {
            if (this.symbolTable == null) {
                this.symbolTable = new LinkedHashMap(5);
            }
        }
    }

    static class Symbol {
        int declType;
        int index;
        String name;
        Scope containingTable;

        Symbol(int n, String string) {
            this.declType = n;
            this.name = string;
            this.index = -1;
        }
    }

    public static class Jump
    extends Node {
        public Node target;
        private Node target2;
        private Jump jumpNode;

        public Jump(int n) {
            super(n);
        }

        Jump(int n, int n2) {
            super(n, n2);
        }

        Jump(int n, Node node) {
            super(n, node);
        }

        Jump(int n, Node node, int n2) {
            super(n, node, n2);
        }

        public final Jump getJumpStatement() {
            if (this.type != 119 && this.type != 120) {
                Kit.codeBug();
            }
            return this.jumpNode;
        }

        public final void setJumpStatement(Jump jump) {
            if (this.type != 119 && this.type != 120) {
                Kit.codeBug();
            }
            if (jump == null) {
                Kit.codeBug();
            }
            if (this.jumpNode != null) {
                Kit.codeBug();
            }
            this.jumpNode = jump;
        }

        public final Node getDefault() {
            if (this.type != 113) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setDefault(Node node) {
            if (this.type != 113) {
                Kit.codeBug();
            }
            if (node.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = node;
        }

        public final Node getFinally() {
            if (this.type != 80) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setFinally(Node node) {
            if (this.type != 80) {
                Kit.codeBug();
            }
            if (node.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = node;
        }

        public final Jump getLoop() {
            if (this.type != 129) {
                Kit.codeBug();
            }
            return this.jumpNode;
        }

        public final void setLoop(Jump jump) {
            if (this.type != 129) {
                Kit.codeBug();
            }
            if (jump == null) {
                Kit.codeBug();
            }
            if (this.jumpNode != null) {
                Kit.codeBug();
            }
            this.jumpNode = jump;
        }

        public final Node getContinue() {
            if (this.type != 131) {
                Kit.codeBug();
            }
            return this.target2;
        }

        public final void setContinue(Node node) {
            if (this.type != 131) {
                Kit.codeBug();
            }
            if (node.type != 130) {
                Kit.codeBug();
            }
            if (this.target2 != null) {
                Kit.codeBug();
            }
            this.target2 = node;
        }
    }

    private static class StringNode
    extends Node {
        String str;
        Scope scope;

        StringNode(int n, String string) {
            super(n);
            this.str = string;
        }
    }

    private static class NumberNode
    extends Node {
        double number;

        NumberNode(double d) {
            super(40);
            this.number = d;
        }
    }
}

