/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.RawHeaders;
import com.squareup.okhttp.internal.http.ResponseHeaders;
import com.squareup.okhttp.internal.http.RetryableOutputStream;
import com.squareup.okhttp.internal.http.Transport;
import com.squareup.okhttp.internal.http.UnknownLengthHttpInputStream;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import com.squareup.okhttp.internal.spdy.SpdyStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.URL;
import java.util.List;

public final class SpdyTransport
implements Transport {
    private final HttpEngine httpEngine;
    private final SpdyConnection spdyConnection;
    private SpdyStream stream;

    public SpdyTransport(HttpEngine httpEngine, SpdyConnection spdyConnection) {
        this.httpEngine = httpEngine;
        this.spdyConnection = spdyConnection;
    }

    @Override
    public OutputStream createRequestBody() throws IOException {
        this.writeRequestHeaders();
        return this.stream.getOutputStream();
    }

    @Override
    public void writeRequestHeaders() throws IOException {
        if (this.stream != null) {
            return;
        }
        this.httpEngine.writingRequestHeaders();
        RawHeaders requestHeaders = this.httpEngine.requestHeaders.getHeaders();
        String version = this.httpEngine.connection.getHttpMinorVersion() == 1 ? "HTTP/1.1" : "HTTP/1.0";
        URL url = this.httpEngine.policy.getURL();
        requestHeaders.addSpdyRequestHeaders(this.httpEngine.method, HttpEngine.requestPath(url), version, HttpEngine.getOriginAddress(url), this.httpEngine.uri.getScheme());
        boolean hasRequestBody = this.httpEngine.hasRequestBody();
        boolean hasResponseBody = true;
        this.stream = this.spdyConnection.newStream(requestHeaders.toNameValueBlock(), hasRequestBody, hasResponseBody);
        this.stream.setReadTimeout(this.httpEngine.policy.getReadTimeout());
    }

    @Override
    public void writeRequestBody(RetryableOutputStream requestBody) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flushRequest() throws IOException {
        this.stream.getOutputStream().close();
    }

    @Override
    public ResponseHeaders readResponseHeaders() throws IOException {
        List<String> nameValueBlock = this.stream.getResponseHeaders();
        RawHeaders rawHeaders = RawHeaders.fromNameValueBlock(nameValueBlock);
        rawHeaders.computeResponseStatusLineFromSpdyHeaders();
        this.httpEngine.receiveHeaders(rawHeaders);
        ResponseHeaders headers = new ResponseHeaders(this.httpEngine.uri, rawHeaders);
        headers.setTransport("spdy/3");
        return headers;
    }

    @Override
    public InputStream getTransferStream(CacheRequest cacheRequest) throws IOException {
        return new UnknownLengthHttpInputStream(this.stream.getInputStream(), cacheRequest, this.httpEngine);
    }

    @Override
    public boolean makeReusable(boolean streamCancelled, OutputStream requestBodyOut, InputStream responseBodyIn) {
        if (streamCancelled) {
            if (this.stream != null) {
                this.stream.closeLater(5);
                return true;
            }
            return false;
        }
        return true;
    }
}

