/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import android.os.StatFs;
import android.provider.ContactsContract;
import com.squareup.picasso.Loader;
import com.squareup.picasso.OkHttpLoader;
import com.squareup.picasso.PicassoBitmapOptions;
import com.squareup.picasso.Request;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.UrlConnectionLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ThreadFactory;

final class Utils {
    static final String THREAD_PREFIX = "Picasso-";
    static final String THREAD_IDLE_NAME = "Picasso-Idle";
    private static final String PICASSO_CACHE = "picasso-cache";
    private static final int KEY_PADDING = 50;
    private static final int MIN_DISK_CACHE_SIZE = 0x500000;
    private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
    private static final int MAX_MEM_CACHE_SIZE = 0x1400000;
    private static final String[] CONTENT_ORIENTATION = new String[]{"orientation"};

    private Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getContentProviderExifRotation(ContentResolver contentResolver, Uri uri) {
        Cursor cursor = null;
        try {
            cursor = contentResolver.query(uri, CONTENT_ORIENTATION, null, null, null);
            if (cursor == null || !cursor.moveToFirst()) {
                int n = 0;
                return n;
            }
            int n = cursor.getInt(0);
            return n;
        }
        catch (IllegalArgumentException ignored) {
            int n = 0;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    static int getBitmapBytes(Bitmap bitmap) {
        int result = Build.VERSION.SDK_INT >= 12 ? BitmapHoneycombMR1.getByteCount(bitmap) : bitmap.getRowBytes() * bitmap.getHeight();
        if (result < 0) {
            throw new IllegalStateException("Negative size: " + bitmap);
        }
        return result;
    }

    static int getFileExifRotation(String path) throws IOException {
        ExifInterface exifInterface = new ExifInterface(path);
        int orientation = exifInterface.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                return 90;
            }
            case 3: {
                return 180;
            }
            case 8: {
                return 270;
            }
        }
        return 0;
    }

    static void checkNotMain() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Method call should not happen from the main thread.");
        }
    }

    static String createKey(Request request) {
        return Utils.createKey(request.uri, request.resourceId, request.options, request.transformations);
    }

    static String createKey(Uri uri, int resourceId, PicassoBitmapOptions options, List<Transformation> transformations) {
        StringBuilder builder;
        if (uri != null) {
            String path = uri.toString();
            builder = new StringBuilder(path.length() + 50);
            builder.append(path);
        } else {
            builder = new StringBuilder(50);
            builder.append(resourceId);
        }
        builder.append('\n');
        if (options != null) {
            float targetRotation = options.targetRotation;
            if (targetRotation != 0.0f) {
                builder.append("rotation:").append(targetRotation);
                if (options.hasRotationPivot) {
                    builder.append('@').append(options.targetPivotX).append('x').append(options.targetPivotY);
                }
                builder.append('\n');
            }
            int targetWidth = options.targetWidth;
            int targetHeight = options.targetHeight;
            if (targetWidth != 0) {
                builder.append("resize:").append(targetWidth).append('x').append(targetHeight);
                builder.append('\n');
            }
            if (options.centerCrop) {
                builder.append("centerCrop\n");
            }
            if (options.centerInside) {
                builder.append("centerInside\n");
            }
            float targetScaleX = options.targetScaleX;
            float targetScaleY = options.targetScaleY;
            if (targetScaleX != 0.0f) {
                builder.append("scale:").append(targetScaleX).append('x').append(targetScaleY);
                builder.append('\n');
            }
        }
        if (transformations != null) {
            int count = transformations.size();
            for (int i = 0; i < count; ++i) {
                builder.append(transformations.get(i).key());
                builder.append('\n');
            }
        }
        return builder.toString();
    }

    static void calculateInSampleSize(PicassoBitmapOptions options) {
        int height = options.outHeight;
        int width = options.outWidth;
        int reqHeight = options.targetHeight;
        int reqWidth = options.targetWidth;
        int sampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            sampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        options.inSampleSize = sampleSize;
        options.inJustDecodeBounds = false;
    }

    static boolean parseResponseSourceHeader(String header) {
        if (header == null) {
            return false;
        }
        String[] parts = header.split(" ", 2);
        if ("CACHE".equals(parts[0])) {
            return true;
        }
        if (parts.length == 1) {
            return false;
        }
        try {
            return "CONDITIONAL_CACHE".equals(parts[0]) && Integer.parseInt(parts[1]) == 304;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    static Loader createDefaultLoader(Context context) {
        try {
            Class.forName("com.squareup.okhttp.OkHttpClient");
            return OkHttpLoaderCreator.create(context);
        }
        catch (ClassNotFoundException e) {
            return new UrlConnectionLoader(context);
        }
    }

    static File createDefaultCacheDir(Context context) {
        File cache = new File(context.getApplicationContext().getCacheDir(), PICASSO_CACHE);
        if (!cache.exists()) {
            cache.mkdirs();
        }
        return cache;
    }

    static int calculateDiskCacheSize(File dir) {
        StatFs statFs = new StatFs(dir.getAbsolutePath());
        int available = statFs.getBlockCount() * statFs.getBlockSize();
        int size = available / 50;
        return Math.max(Math.min(size, 0x3200000), 0x500000);
    }

    static int calculateMemoryCacheSize(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        boolean largeHeap = (context.getApplicationInfo().flags & 0x100000) != 0;
        int memoryClass = am.getMemoryClass();
        if (largeHeap && Build.VERSION.SDK_INT >= 11) {
            memoryClass = ActivityManagerHoneycomb.getLargeMemoryClass(am);
        }
        int size = 0x100000 * memoryClass / 7;
        return Math.min(size, 0x1400000);
    }

    public static InputStream getContactPhotoStream(ContentResolver contentResolver, Uri uri) {
        if (Build.VERSION.SDK_INT < 14) {
            if (uri.toString().startsWith(ContactsContract.Contacts.CONTENT_LOOKUP_URI.toString())) {
                uri = ContactsContract.Contacts.lookupContact((ContentResolver)contentResolver, (Uri)uri);
            }
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri);
        }
        return ContactPhotoStreamIcs.get(contentResolver, uri);
    }

    private static class OkHttpLoaderCreator {
        private OkHttpLoaderCreator() {
        }

        static Loader create(Context context) {
            return new OkHttpLoader(context);
        }
    }

    @TargetApi(value=14)
    private static class ContactPhotoStreamIcs {
        private ContactPhotoStreamIcs() {
        }

        static InputStream get(ContentResolver contentResolver, Uri uri) {
            return ContactsContract.Contacts.openContactPhotoInputStream((ContentResolver)contentResolver, (Uri)uri, (boolean)true);
        }
    }

    @TargetApi(value=12)
    private static class BitmapHoneycombMR1 {
        private BitmapHoneycombMR1() {
        }

        static int getByteCount(Bitmap bitmap) {
            return bitmap.getByteCount();
        }
    }

    private static class PicassoThread
    extends Thread {
        public PicassoThread(Runnable r) {
            super(r);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)10);
            super.run();
        }
    }

    static class PicassoThreadFactory
    implements ThreadFactory {
        PicassoThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new PicassoThread(r);
        }
    }

    @TargetApi(value=11)
    private static class ActivityManagerHoneycomb {
        private ActivityManagerHoneycomb() {
        }

        static int getLargeMemoryClass(ActivityManager activityManager) {
            return activityManager.getLargeMemoryClass();
        }
    }
}

