/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import android.net.http.HttpResponseCache;
import android.os.Build;
import com.squareup.picasso.Loader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlConnectionLoader
implements Loader {
    static final String RESPONSE_SOURCE = "X-Android-Response-Source";
    private static final Object lock = new Object();
    static volatile Object cache;
    private final Context context;

    public UrlConnectionLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    protected HttpURLConnection openConnection(String path) throws IOException {
        return (HttpURLConnection)new URL(path).openConnection();
    }

    @Override
    public Loader.Response load(Uri uri, boolean localCacheOnly) throws IOException {
        if (Build.VERSION.SDK_INT >= 14) {
            UrlConnectionLoader.installCacheIfNeeded(this.context);
        }
        HttpURLConnection connection = this.openConnection(uri.toString());
        connection.setUseCaches(true);
        if (localCacheOnly) {
            connection.setRequestProperty("Cache-Control", "only-if-cached");
        }
        boolean fromCache = Utils.parseResponseSourceHeader(connection.getHeaderField(RESPONSE_SOURCE));
        return new Loader.Response(connection.getInputStream(), fromCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installCacheIfNeeded(Context context) {
        if (cache == null) {
            try {
                Object object = lock;
                synchronized (object) {
                    if (cache == null) {
                        cache = ResponseCacheIcs.install(context);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ResponseCacheIcs {
        private ResponseCacheIcs() {
        }

        static Object install(Context context) throws IOException {
            File cacheDir = Utils.createDefaultCacheDir(context);
            HttpResponseCache cache = HttpResponseCache.getInstalled();
            if (cache == null) {
                int maxSize = Utils.calculateDiskCacheSize(cacheDir);
                cache = HttpResponseCache.install((File)cacheDir, (long)maxSize);
            }
            return cache;
        }
    }
}

