/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.net.Uri;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoBitmapOptions;
import com.squareup.picasso.Request;
import com.squareup.picasso.Target;
import com.squareup.picasso.Transformation;
import java.lang.ref.WeakReference;
import java.util.List;

final class TargetRequest
extends Request {
    private final WeakReference<Target> weakTarget;
    private final Target strongTarget;

    TargetRequest(Picasso picasso, Uri uri, int resourceId, Target target, boolean strong, PicassoBitmapOptions bitmapOptions, List<Transformation> transformations, boolean skipCache) {
        super(picasso, uri, resourceId, null, bitmapOptions, transformations, skipCache, false, 0, null);
        this.weakTarget = strong ? null : new WeakReference<Target>(target);
        this.strongTarget = strong ? target : null;
    }

    @Override
    Target getTarget() {
        return this.strongTarget != null ? this.strongTarget : (Target)this.weakTarget.get();
    }

    @Override
    void complete() {
        if (this.result == null) {
            throw new AssertionError((Object)String.format("Attempted to complete request with no result!\n%s", this));
        }
        Target target = this.getTarget();
        if (target != null) {
            target.onSuccess(this.result);
            if (this.result.isRecycled()) {
                throw new IllegalStateException("Target callback must not recycle bitmap!");
            }
        }
    }

    @Override
    void error() {
        Target target = this.getTarget();
        if (target == null) {
            return;
        }
        target.onError();
    }
}

