/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.squareup.picasso.Cache;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Utils;

class Stats {
    private static final int REQUESTED_COMPLETED = 0;
    private static final int CACHE_HIT = 1;
    private static final int CACHE_MISS = 2;
    private static final int BITMAP_DECODE_FINISHED = 3;
    private static final int BITMAP_TRANSFORMED_FINISHED = 4;
    private static final String STATS_THREAD_NAME = "Picasso-Stats";
    final Cache cache;
    final Handler handler;
    long cacheHits;
    long cacheMisses;
    long totalOriginalBitmapSize;
    long totalTransformedBitmapSize;
    long averageOriginalBitmapSize;
    long averageTransformedBitmapSize;
    int originalBitmapCount;
    int transformedBitmapCount;

    Stats(Cache cache) {
        this.cache = cache;
        HandlerThread statsThread = new HandlerThread(STATS_THREAD_NAME, 10);
        statsThread.start();
        this.handler = new StatsHandler(statsThread.getLooper());
    }

    void bitmapDecoded(Bitmap bitmap) {
        this.processBitmap(bitmap, 3);
    }

    void bitmapTransformed(Bitmap bitmap) {
        this.processBitmap(bitmap, 4);
    }

    void cacheHit() {
        this.handler.sendEmptyMessage(1);
    }

    void cacheMiss() {
        this.handler.sendEmptyMessage(2);
    }

    synchronized StatsSnapshot createSnapshot() {
        return new StatsSnapshot(this.cache.maxSize(), this.cache.size(), this.cacheHits, this.cacheMisses, this.totalOriginalBitmapSize, this.totalTransformedBitmapSize, this.averageOriginalBitmapSize, this.averageTransformedBitmapSize, this.originalBitmapCount, this.transformedBitmapCount, System.currentTimeMillis());
    }

    private void processBitmap(Bitmap bitmap, int what) {
        int bitmapSize = Utils.getBitmapBytes(bitmap);
        this.handler.sendMessage(this.handler.obtainMessage(what, bitmapSize, 0));
    }

    private static long getAverage(int count, long totalSize) {
        return totalSize / (long)count;
    }

    private class StatsHandler
    extends Handler {
        public StatsHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(final Message msg) {
            Stats stats = Stats.this;
            synchronized (stats) {
                switch (msg.what) {
                    case 1: {
                        ++Stats.this.cacheHits;
                        break;
                    }
                    case 2: {
                        ++Stats.this.cacheMisses;
                        break;
                    }
                    case 3: {
                        ++Stats.this.originalBitmapCount;
                        Stats.this.totalOriginalBitmapSize += (long)msg.arg1;
                        Stats.this.averageOriginalBitmapSize = Stats.getAverage(Stats.this.originalBitmapCount, Stats.this.totalOriginalBitmapSize);
                        break;
                    }
                    case 4: {
                        ++Stats.this.transformedBitmapCount;
                        Stats.this.totalTransformedBitmapSize += (long)msg.arg1;
                        Stats.this.averageTransformedBitmapSize = Stats.getAverage(Stats.this.originalBitmapCount, Stats.this.totalTransformedBitmapSize);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        Handler mainHandler = new Handler(Looper.getMainLooper());
                        mainHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                throw new AssertionError((Object)("Unhandled stats message." + msg.what));
                            }
                        });
                    }
                }
            }
        }
    }
}

