/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoBitmapOptions;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Request;
import com.squareup.picasso.Target;
import com.squareup.picasso.TargetRequest;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RequestBuilder {
    private final Picasso picasso;
    private final Uri uri;
    private final int resourceId;
    PicassoBitmapOptions options;
    private List<Transformation> transformations;
    private boolean skipCache;
    private boolean noFade;
    private boolean hasNullPlaceholder;
    private int placeholderResId;
    private Drawable placeholderDrawable;
    private int errorResId;
    private Drawable errorDrawable;

    RequestBuilder(Picasso picasso, Uri uri, int resourceId) {
        this.picasso = picasso;
        this.uri = uri;
        this.resourceId = resourceId;
    }

    RequestBuilder() {
        this.picasso = null;
        this.uri = null;
        this.resourceId = 0;
    }

    private PicassoBitmapOptions getOptions() {
        if (this.options == null) {
            this.options = new PicassoBitmapOptions();
        }
        return this.options;
    }

    public RequestBuilder placeholder(int placeholderResId) {
        if (placeholderResId == 0) {
            throw new IllegalArgumentException("Placeholder image resource invalid.");
        }
        if (this.placeholderDrawable != null) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.placeholderResId = placeholderResId;
        return this;
    }

    public RequestBuilder placeholder(Drawable placeholderDrawable) {
        if (this.placeholderResId != 0) {
            throw new IllegalStateException("Placeholder image already set.");
        }
        this.hasNullPlaceholder = placeholderDrawable == null;
        this.placeholderDrawable = placeholderDrawable;
        return this;
    }

    public RequestBuilder error(int errorResId) {
        if (errorResId == 0) {
            throw new IllegalArgumentException("Error image resource invalid.");
        }
        if (this.errorDrawable != null) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorResId = errorResId;
        return this;
    }

    public RequestBuilder error(Drawable errorDrawable) {
        if (errorDrawable == null) {
            throw new IllegalArgumentException("Error image may not be null.");
        }
        if (this.errorResId != 0) {
            throw new IllegalStateException("Error image already set.");
        }
        this.errorDrawable = errorDrawable;
        return this;
    }

    public RequestBuilder fit() {
        PicassoBitmapOptions options = this.getOptions();
        if (options.targetWidth != 0 || options.targetHeight != 0) {
            throw new IllegalStateException("Fit cannot be used with resize.");
        }
        options.deferredResize = true;
        return this;
    }

    public RequestBuilder resizeDimen(int targetWidthResId, int targetHeightResId) {
        Resources resources = this.picasso.context.getResources();
        int targetWidth = resources.getDimensionPixelSize(targetWidthResId);
        int targetHeight = resources.getDimensionPixelSize(targetHeightResId);
        return this.resize(targetWidth, targetHeight);
    }

    public RequestBuilder resize(int targetWidth, int targetHeight) {
        if (targetWidth <= 0) {
            throw new IllegalArgumentException("Width must be positive number.");
        }
        if (targetHeight <= 0) {
            throw new IllegalArgumentException("Height must be positive number.");
        }
        PicassoBitmapOptions options = this.getOptions();
        if (options.targetWidth != 0 || options.targetHeight != 0) {
            throw new IllegalStateException("Resize may only be called once.");
        }
        if (options.deferredResize) {
            throw new IllegalStateException("Resize cannot be used with fit.");
        }
        options.targetWidth = targetWidth;
        options.targetHeight = targetHeight;
        options.inJustDecodeBounds = true;
        return this;
    }

    public RequestBuilder centerCrop() {
        PicassoBitmapOptions options = this.getOptions();
        if (options.targetWidth == 0 || options.targetHeight == 0) {
            throw new IllegalStateException("Center crop can only be used after calling resize.");
        }
        if (options.centerInside) {
            throw new IllegalStateException("Center crop can not be used after calling centerInside");
        }
        options.centerCrop = true;
        return this;
    }

    public RequestBuilder centerInside() {
        PicassoBitmapOptions options = this.getOptions();
        if (options.targetWidth == 0 || options.targetHeight == 0) {
            throw new IllegalStateException("Center inside can only be used after calling resize.");
        }
        if (options.centerCrop) {
            throw new IllegalStateException("Center inside can not be used after calling centerCrop");
        }
        options.centerInside = true;
        return this;
    }

    public RequestBuilder scale(float factor) {
        if (factor != 1.0f) {
            this.scale(factor, factor);
        }
        return this;
    }

    public RequestBuilder scale(float factorX, float factorY) {
        if (factorX == 0.0f || factorY == 0.0f) {
            throw new IllegalArgumentException("Scale factor must be positive number.");
        }
        if (factorX != 1.0f && factorY != 1.0f) {
            PicassoBitmapOptions options = this.getOptions();
            if (options.targetScaleX != 0.0f || options.targetScaleY != 0.0f) {
                throw new IllegalStateException("Scale may only be called once.");
            }
            options.targetScaleX = factorX;
            options.targetScaleY = factorY;
        }
        return this;
    }

    public RequestBuilder rotate(float degrees) {
        if (degrees != 0.0f) {
            PicassoBitmapOptions options = this.getOptions();
            options.targetRotation = degrees;
        }
        return this;
    }

    public RequestBuilder rotate(float degrees, float pivotX, float pivotY) {
        if (degrees != 0.0f) {
            PicassoBitmapOptions options = this.getOptions();
            options.targetRotation = degrees;
            options.targetPivotX = pivotX;
            options.targetPivotY = pivotY;
            options.hasRotationPivot = true;
        }
        return this;
    }

    public RequestBuilder transform(Transformation transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("Transformation must not be null.");
        }
        if (this.transformations == null) {
            this.transformations = new ArrayList<Transformation>(2);
        }
        this.transformations.add(transformation);
        return this;
    }

    public RequestBuilder skipCache() {
        this.skipCache = true;
        return this;
    }

    public RequestBuilder noFade() {
        this.noFade = true;
        return this;
    }

    public Bitmap get() throws IOException {
        Utils.checkNotMain();
        if (this.uri == null && this.resourceId == 0) {
            return null;
        }
        Request request = new Request(this.picasso, this.uri, this.resourceId, null, this.options, this.transformations, this.skipCache, false, 0, null);
        return this.picasso.resolveRequest(request);
    }

    public void fetch(Target target) {
        this.makeTargetRequest(target, true);
    }

    public void into(Target target) {
        this.makeTargetRequest(target, false);
    }

    public void into(ImageView target) {
        String requestKey;
        Bitmap bitmap;
        boolean hasItemToLoad;
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        boolean bl = hasItemToLoad = this.uri != null || this.resourceId != 0;
        if (hasItemToLoad && (bitmap = this.picasso.quickMemoryCacheCheck(target, this.uri, requestKey = Utils.createKey(this.uri, this.resourceId, this.options, this.transformations))) != null) {
            PicassoDrawable.setBitmap(target, this.picasso.context, bitmap, Request.LoadedFrom.MEMORY, this.noFade, this.picasso.debugging);
            return;
        }
        if (this.placeholderResId != 0 || this.placeholderDrawable != null) {
            PicassoDrawable.setPlaceholder(target, this.picasso.context, this.placeholderResId, this.placeholderDrawable, this.picasso.debugging);
        } else if (this.hasNullPlaceholder) {
            target.setImageDrawable(null);
        }
        if (hasItemToLoad) {
            Request request = new Request(this.picasso, this.uri, this.resourceId, target, this.options, this.transformations, this.skipCache, this.noFade, this.errorResId, this.errorDrawable);
            this.picasso.submit(request);
        } else {
            this.picasso.cancelRequest(target);
        }
    }

    private void makeTargetRequest(Target target, boolean strong) {
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null.");
        }
        if (this.uri == null && this.resourceId == 0) {
            this.picasso.cancelRequest(target);
            return;
        }
        String requestKey = Utils.createKey(this.uri, this.resourceId, this.options, this.transformations);
        Bitmap bitmap = this.picasso.quickMemoryCacheCheck(target, this.uri, requestKey);
        if (bitmap != null) {
            target.onSuccess(bitmap);
            return;
        }
        TargetRequest request = new TargetRequest(this.picasso, this.uri, this.resourceId, target, strong, this.options, this.transformations, this.skipCache);
        this.picasso.submit(request);
    }
}

