/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.ImageView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.PicassoBitmapOptions;
import com.squareup.picasso.PicassoDrawable;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.concurrent.Future;

class Request
implements Runnable {
    static final int DEFAULT_RETRY_COUNT = 2;
    final Picasso picasso;
    final Uri uri;
    final int resourceId;
    final WeakReference<ImageView> target;
    final PicassoBitmapOptions options;
    final List<Transformation> transformations;
    final boolean skipCache;
    final boolean noFade;
    final int errorResId;
    final Drawable errorDrawable;
    final String key;
    Future<?> future;
    Bitmap result;
    LoadedFrom loadedFrom;
    int retryCount;
    boolean retryCancelled;

    Request(Picasso picasso, Uri uri, int resourceId, ImageView imageView, PicassoBitmapOptions options, List<Transformation> transformations, boolean skipCache, boolean noFade, int errorResId, Drawable errorDrawable) {
        this.picasso = picasso;
        this.uri = uri;
        this.resourceId = resourceId;
        this.target = new WeakReference<ImageView>(imageView);
        this.options = options;
        this.transformations = transformations;
        this.skipCache = skipCache;
        this.noFade = noFade;
        this.errorResId = errorResId;
        this.errorDrawable = errorDrawable;
        this.retryCount = 2;
        this.key = Utils.createKey(this);
    }

    Object getTarget() {
        return this.target.get();
    }

    void complete() {
        if (this.result == null) {
            throw new AssertionError((Object)String.format("Attempted to complete request with no result!\n%s", this));
        }
        ImageView target = (ImageView)this.target.get();
        if (target != null) {
            Context context = this.picasso.context;
            boolean debugging = this.picasso.debugging;
            PicassoDrawable.setBitmap(target, context, this.result, this.loadedFrom, this.noFade, debugging);
        }
    }

    void error() {
        ImageView target = (ImageView)this.target.get();
        if (target == null) {
            return;
        }
        if (this.errorResId != 0) {
            target.setImageResource(this.errorResId);
        } else if (this.errorDrawable != null) {
            target.setImageDrawable(this.errorDrawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Thread.currentThread().setName("Picasso-" + this.getName());
            this.picasso.run(this);
        }
        catch (Throwable e) {
            this.picasso.handler.post(new Runnable(){

                @Override
                public void run() {
                    throw new RuntimeException("An unexpected exception occurred", e);
                }
            });
        }
        finally {
            Thread.currentThread().setName("Picasso-Idle");
        }
    }

    private String getName() {
        Uri uri = this.uri;
        return uri != null ? uri.getPath() : Integer.toString(this.resourceId);
    }

    public String toString() {
        return "Request[hashCode=" + this.hashCode() + ", picasso=" + this.picasso + ", uri=" + this.uri + ", resourceId=" + this.resourceId + ", target=" + this.target + ", options=" + (Object)((Object)this.options) + ", transformations=" + this.transformationKeys() + ", future=" + this.future + ", result=" + this.result + ", retryCount=" + this.retryCount + ", loadedFrom=" + (Object)((Object)this.loadedFrom) + ']';
    }

    String transformationKeys() {
        if (this.transformations == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder(this.transformations.size() * 16);
        sb.append('[');
        boolean first = true;
        for (Transformation transformation : this.transformations) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(transformation.key());
        }
        sb.append(']');
        return sb.toString();
    }

    static enum LoadedFrom {
        MEMORY(-16711936),
        DISK(-256),
        NETWORK(-65536);

        final int debugColor;

        private LoadedFrom(int debugColor) {
            this.debugColor = debugColor;
        }
    }
}

