/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.widget.ImageView;
import com.squareup.picasso.Request;

final class PicassoDrawable
extends Drawable {
    private static final Paint DEBUG_PAINT = new Paint();
    private static final float FADE_DURATION = 200.0f;
    private final Context context;
    private final boolean debugging;
    private final float density;
    int placeholderResId;
    Drawable placeHolderDrawable;
    BitmapDrawable bitmapDrawable;
    private Request.LoadedFrom loadedFrom;
    private int alpha;
    private long startTimeMillis;
    boolean animating;

    static void setBitmap(ImageView target, Context context, Bitmap bitmap, Request.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        PicassoDrawable picassoDrawable = PicassoDrawable.extractPicassoDrawable(target);
        if (picassoDrawable != null) {
            picassoDrawable.setBitmap(bitmap, loadedFrom, noFade);
        } else {
            target.setImageDrawable((Drawable)new PicassoDrawable(context, bitmap, loadedFrom, noFade, debugging));
        }
    }

    static void setPlaceholder(ImageView target, Context context, int placeholderResId, Drawable placeholderDrawable, boolean debugging) {
        PicassoDrawable picassoDrawable = PicassoDrawable.extractPicassoDrawable(target);
        if (picassoDrawable != null) {
            picassoDrawable.setPlaceholder(placeholderResId, placeholderDrawable);
        } else {
            target.setImageDrawable((Drawable)new PicassoDrawable(context, placeholderResId, placeholderDrawable, debugging));
        }
    }

    private static PicassoDrawable extractPicassoDrawable(ImageView target) {
        Drawable targetDrawable = target.getDrawable();
        if (targetDrawable instanceof PicassoDrawable) {
            return (PicassoDrawable)targetDrawable;
        }
        return null;
    }

    PicassoDrawable(Context context, int placeholderResId, Drawable placeholderDrawable, boolean debugging) {
        Resources resources = context.getResources();
        this.context = context.getApplicationContext();
        this.density = resources.getDisplayMetrics().density;
        this.placeholderResId = placeholderResId;
        if (placeholderResId != 0) {
            placeholderDrawable = resources.getDrawable(placeholderResId);
        }
        this.placeHolderDrawable = placeholderDrawable;
        this.debugging = debugging;
    }

    PicassoDrawable(Context context, Bitmap bitmap, Request.LoadedFrom loadedFrom, boolean noFade, boolean debugging) {
        Resources resources = context.getResources();
        this.context = context.getApplicationContext();
        this.loadedFrom = loadedFrom;
        this.density = resources.getDisplayMetrics().density;
        this.bitmapDrawable = new BitmapDrawable(resources, bitmap);
        this.debugging = debugging;
        if (loadedFrom != Request.LoadedFrom.MEMORY && !noFade) {
            this.startTimeMillis = 0L;
            this.animating = true;
        }
    }

    public void draw(Canvas canvas) {
        if (this.bitmapDrawable == null) {
            this.placeHolderDrawable.draw(canvas);
            return;
        }
        boolean done = true;
        if (this.animating) {
            if (this.startTimeMillis == 0L) {
                this.startTimeMillis = SystemClock.uptimeMillis();
                done = false;
                this.alpha = 0;
            } else {
                float normalized = (float)(SystemClock.uptimeMillis() - this.startTimeMillis) / 200.0f;
                done = normalized >= 1.0f;
                normalized = Math.min(normalized, 1.0f);
                this.alpha = (int)(255.0f * normalized);
            }
        }
        if (done) {
            this.bitmapDrawable.draw(canvas);
        } else {
            if (this.placeHolderDrawable != null) {
                this.placeHolderDrawable.draw(canvas);
            }
            if (this.alpha > 0) {
                this.bitmapDrawable.setAlpha(this.alpha);
                this.bitmapDrawable.draw(canvas);
                this.bitmapDrawable.setAlpha(255);
            }
            this.invalidateSelf();
        }
        if (this.debugging) {
            this.drawDebugIndicator(canvas);
        }
    }

    public int getIntrinsicWidth() {
        if (this.bitmapDrawable != null) {
            return this.bitmapDrawable.getIntrinsicWidth();
        }
        return -1;
    }

    public int getIntrinsicHeight() {
        if (this.bitmapDrawable != null) {
            return this.bitmapDrawable.getIntrinsicHeight();
        }
        return -1;
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -1;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.bitmapDrawable != null) {
            this.setBounds((Drawable)this.bitmapDrawable);
        }
        if (this.placeHolderDrawable != null) {
            this.placeHolderDrawable.setBounds(this.getBounds());
        }
    }

    void setPlaceholder(int placeholderResId, Drawable placeHolderDrawable) {
        this.bitmapDrawable = null;
        this.loadedFrom = null;
        if (placeholderResId != 0) {
            if (this.placeholderResId != placeholderResId) {
                this.placeHolderDrawable = this.context.getResources().getDrawable(placeholderResId);
                this.placeHolderDrawable.setBounds(this.getBounds());
            }
        } else if (this.placeHolderDrawable != placeHolderDrawable) {
            this.placeHolderDrawable = placeHolderDrawable;
            this.placeHolderDrawable.setBounds(this.getBounds());
        }
        this.invalidateSelf();
    }

    void setBitmap(Bitmap bitmap, Request.LoadedFrom loadedFrom, boolean noFade) {
        boolean fade;
        boolean bl = fade = loadedFrom != Request.LoadedFrom.MEMORY && !noFade;
        if (this.bitmapDrawable != null && fade) {
            this.placeHolderDrawable = this.bitmapDrawable;
        }
        this.bitmapDrawable = new BitmapDrawable(this.context.getResources(), bitmap);
        this.setBounds((Drawable)this.bitmapDrawable);
        this.loadedFrom = loadedFrom;
        this.startTimeMillis = 0L;
        this.animating = fade;
        this.invalidateSelf();
    }

    private void setBounds(Drawable drawable) {
        int drawableHeight;
        Rect bounds = this.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        float ratio = (float)width / (float)height;
        int drawableWidth = drawable.getIntrinsicWidth();
        float drawableRatio = (float)drawableWidth / (float)(drawableHeight = drawable.getIntrinsicHeight());
        if (drawableRatio < ratio) {
            float scale = (float)height / (float)drawableHeight;
            int scaledDrawableWidth = (int)((float)drawableWidth * scale);
            int drawableLeft = bounds.left - (scaledDrawableWidth - width) / 2;
            int drawableRight = drawableLeft + scaledDrawableWidth;
            drawable.setBounds(drawableLeft, bounds.top, drawableRight, bounds.bottom);
        } else {
            float scale = (float)width / (float)drawableWidth;
            int scaledDrawableHeight = (int)((float)drawableHeight * scale);
            int drawableTop = bounds.top - (scaledDrawableHeight - height) / 2;
            int drawableBottom = drawableTop + scaledDrawableHeight;
            drawable.setBounds(bounds.left, drawableTop, bounds.right, drawableBottom);
        }
    }

    private void drawDebugIndicator(Canvas canvas) {
        canvas.save();
        canvas.rotate(45.0f);
        DEBUG_PAINT.setColor(-1);
        canvas.drawRect(0.0f, -10.0f * this.density, 7.5f * this.density, 10.0f * this.density, DEBUG_PAINT);
        DEBUG_PAINT.setColor(this.loadedFrom.debugColor);
        canvas.drawRect(0.0f, -9.0f * this.density, 6.5f * this.density, 9.0f * this.density, DEBUG_PAINT);
        canvas.restore();
    }
}

