/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.ContactsContract;
import android.widget.ImageView;
import com.squareup.picasso.Cache;
import com.squareup.picasso.Loader;
import com.squareup.picasso.LruCache;
import com.squareup.picasso.PicassoBitmapOptions;
import com.squareup.picasso.Request;
import com.squareup.picasso.RequestBuilder;
import com.squareup.picasso.Stats;
import com.squareup.picasso.StatsSnapshot;
import com.squareup.picasso.Target;
import com.squareup.picasso.Transformation;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class Picasso {
    private static final int RETRY_DELAY = 500;
    private static final int REQUEST_COMPLETE = 1;
    private static final int REQUEST_RETRY = 2;
    private static final int REQUEST_DECODE_FAILED = 3;
    private static final Object DECODE_LOCK = new Object();
    final Handler handler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Request request = (Request)msg.obj;
            if (request.future.isCancelled() || request.retryCancelled) {
                return;
            }
            Picasso picasso = request.picasso;
            switch (msg.what) {
                case 1: {
                    picasso.targetsToRequests.remove(request.getTarget());
                    request.complete();
                    break;
                }
                case 2: {
                    picasso.retry(request);
                    break;
                }
                case 3: {
                    picasso.error(request);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown handler message received: " + msg.what));
                }
            }
        }
    };
    static Picasso singleton = null;
    final Context context;
    final Loader loader;
    final ExecutorService service;
    final Cache cache;
    final Listener listener;
    final Stats stats;
    final Map<Object, Request> targetsToRequests;
    boolean debugging;

    Picasso(Context context, Loader loader, ExecutorService service, Cache cache, Listener listener, Stats stats) {
        this.context = context;
        this.loader = loader;
        this.service = service;
        this.cache = cache;
        this.listener = listener;
        this.stats = stats;
        this.targetsToRequests = new WeakHashMap<Object, Request>();
    }

    public void cancelRequest(ImageView view) {
        this.cancelExistingRequest(view, null);
    }

    public void cancelRequest(Target target) {
        this.cancelExistingRequest(target, null);
    }

    public RequestBuilder load(Uri uri) {
        return new RequestBuilder(this, uri, 0);
    }

    public RequestBuilder load(String path) {
        if (path == null) {
            return new RequestBuilder(this, null, 0);
        }
        if (path.trim().length() == 0) {
            throw new IllegalArgumentException("Path must not be empty.");
        }
        return this.load(Uri.parse((String)path));
    }

    public RequestBuilder load(File file) {
        if (file == null) {
            return new RequestBuilder(this, null, 0);
        }
        return this.load(Uri.fromFile((File)file));
    }

    public RequestBuilder load(int resourceId) {
        if (resourceId == 0) {
            throw new IllegalArgumentException("Resource ID must not be zero.");
        }
        return new RequestBuilder(this, null, resourceId);
    }

    public boolean isDebugging() {
        return this.debugging;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public StatsSnapshot getSnapshot() {
        return this.stats.createSnapshot();
    }

    void submit(Request request) {
        Object target = request.getTarget();
        if (target == null) {
            return;
        }
        this.cancelExistingRequest(target, request.uri);
        this.targetsToRequests.put(target, request);
        request.future = this.service.submit(request);
    }

    void run(Request request) {
        try {
            Bitmap result = this.resolveRequest(request);
            if (result == null) {
                this.handler.sendMessage(this.handler.obtainMessage(3, (Object)request));
                return;
            }
            request.result = result;
            this.handler.sendMessage(this.handler.obtainMessage(1, (Object)request));
        }
        catch (IOException e) {
            if (this.listener != null && request.uri != null) {
                this.listener.onImageLoadFailed(this, request.uri, e);
            }
            this.handler.sendMessageDelayed(this.handler.obtainMessage(2, (Object)request), 500L);
        }
    }

    Bitmap resolveRequest(Request request) throws IOException {
        Bitmap bitmap = this.loadFromCache(request);
        if (bitmap == null) {
            this.stats.cacheMiss();
            try {
                bitmap = this.loadFromType(request);
            }
            catch (OutOfMemoryError e) {
                throw new IOException("Failed to decode request: " + request, e);
            }
            if (bitmap != null && !request.skipCache) {
                this.cache.set(request.key, bitmap);
            }
        } else {
            this.stats.cacheHit();
        }
        return bitmap;
    }

    Bitmap quickMemoryCacheCheck(Object target, Uri uri, String key) {
        Bitmap cached = this.cache.get(key);
        this.cancelExistingRequest(target, uri);
        if (cached != null) {
            this.stats.cacheHit();
        }
        return cached;
    }

    void retry(Request request) {
        if (request.retryCancelled) {
            return;
        }
        if (request.retryCount > 0) {
            --request.retryCount;
            this.submit(request);
        } else {
            this.targetsToRequests.remove(request.getTarget());
            request.error();
        }
    }

    void error(Request request) {
        this.targetsToRequests.remove(request.getTarget());
        request.error();
    }

    Bitmap decodeStream(InputStream stream, PicassoBitmapOptions bitmapOptions) {
        if (stream == null) {
            return null;
        }
        if (bitmapOptions != null) {
            bitmapOptions.inJustDecodeBounds = false;
        }
        return BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)bitmapOptions);
    }

    Bitmap decodeContentStream(Uri path, PicassoBitmapOptions bitmapOptions) throws IOException {
        ContentResolver contentResolver = this.context.getContentResolver();
        if (bitmapOptions != null && bitmapOptions.inJustDecodeBounds) {
            BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(path), null, (BitmapFactory.Options)bitmapOptions);
            Utils.calculateInSampleSize(bitmapOptions);
        }
        return BitmapFactory.decodeStream((InputStream)contentResolver.openInputStream(path), null, (BitmapFactory.Options)bitmapOptions);
    }

    Bitmap decodeResource(Resources resources, int resourceId, PicassoBitmapOptions bitmapOptions) {
        if (bitmapOptions != null && bitmapOptions.inJustDecodeBounds) {
            BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)bitmapOptions);
            Utils.calculateInSampleSize(bitmapOptions);
        }
        return BitmapFactory.decodeResource((Resources)resources, (int)resourceId, (BitmapFactory.Options)bitmapOptions);
    }

    private void cancelExistingRequest(Object target, Uri uri) {
        Request existing = this.targetsToRequests.remove(target);
        if (existing != null) {
            if (!existing.future.isDone()) {
                existing.future.cancel(true);
            } else if (uri == null || !uri.equals((Object)existing.uri)) {
                existing.retryCancelled = true;
            }
        }
    }

    private Bitmap loadFromCache(Request request) {
        if (request.skipCache) {
            return null;
        }
        Bitmap cached = this.cache.get(request.key);
        if (cached != null) {
            request.loadedFrom = Request.LoadedFrom.MEMORY;
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap loadFromType(Request request) throws IOException {
        List<Transformation> transformations;
        ImageView target;
        PicassoBitmapOptions options = request.options;
        int exifRotation = 0;
        Bitmap result = null;
        Uri uri = request.uri;
        int resourceId = request.resourceId;
        if (resourceId != 0) {
            result = this.decodeResource(this.context.getResources(), resourceId, options);
            request.loadedFrom = Request.LoadedFrom.DISK;
        } else {
            String scheme = uri.getScheme();
            if ("content".equals(scheme)) {
                ContentResolver contentResolver = this.context.getContentResolver();
                if (ContactsContract.Contacts.CONTENT_URI.getHost().equals(uri.getHost()) && !uri.getPathSegments().contains("photo")) {
                    InputStream contactStream = Utils.getContactPhotoStream(contentResolver, uri);
                    result = this.decodeStream(contactStream, options);
                } else {
                    exifRotation = Utils.getContentProviderExifRotation(contentResolver, uri);
                    result = this.decodeContentStream(uri, options);
                }
                request.loadedFrom = Request.LoadedFrom.DISK;
            } else if ("file".equals(scheme)) {
                exifRotation = Utils.getFileExifRotation(uri.getPath());
                result = this.decodeContentStream(uri, options);
                request.loadedFrom = Request.LoadedFrom.DISK;
            } else if ("android.resource".equals(scheme)) {
                result = this.decodeContentStream(uri, options);
                request.loadedFrom = Request.LoadedFrom.DISK;
            } else {
                Loader.Response response = null;
                try {
                    response = this.loader.load(uri, request.retryCount == 0);
                    if (response == null) {
                        Bitmap contactStream = null;
                        return contactStream;
                    }
                    result = this.decodeStream(response.stream, options);
                }
                finally {
                    if (response != null && response.stream != null) {
                        try {
                            response.stream.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
                Request.LoadedFrom loadedFrom = request.loadedFrom = response.cached ? Request.LoadedFrom.DISK : Request.LoadedFrom.NETWORK;
            }
        }
        if (result == null) {
            return null;
        }
        this.stats.bitmapDecoded(result);
        if (options != null && options.deferredResize && (target = (ImageView)request.target.get()) != null) {
            int targetWidth = target.getMeasuredWidth();
            int targetHeight = target.getMeasuredHeight();
            if (targetWidth != 0 && targetHeight != 0) {
                options.targetWidth = targetWidth;
                options.targetHeight = targetHeight;
            }
        }
        if (options != null || exifRotation != 0) {
            result = Picasso.transformResult(options, result, exifRotation);
        }
        if ((transformations = request.transformations) != null) {
            result = Picasso.applyCustomTransformations(transformations, result);
            this.stats.bitmapTransformed(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bitmap transformResult(PicassoBitmapOptions options, Bitmap result, int exifRotation) {
        int inWidth = result.getWidth();
        int inHeight = result.getHeight();
        int drawX = 0;
        int drawY = 0;
        int drawWidth = inWidth;
        int drawHeight = inHeight;
        Matrix matrix = new Matrix();
        if (options != null) {
            float heightRatio;
            float widthRatio;
            int targetWidth = options.targetWidth;
            int targetHeight = options.targetHeight;
            float targetRotation = options.targetRotation;
            if (targetRotation != 0.0f) {
                if (options.hasRotationPivot) {
                    matrix.setRotate(targetRotation, options.targetPivotX, options.targetPivotY);
                } else {
                    matrix.setRotate(targetRotation);
                }
            }
            if (options.centerCrop) {
                float scale;
                widthRatio = (float)targetWidth / (float)inWidth;
                heightRatio = (float)targetHeight / (float)inHeight;
                if (widthRatio > heightRatio) {
                    scale = widthRatio;
                    int newSize = (int)Math.ceil((float)inHeight * (heightRatio / widthRatio));
                    drawY = (inHeight - newSize) / 2;
                    drawHeight = newSize;
                } else {
                    scale = heightRatio;
                    int newSize = (int)Math.ceil((float)inWidth * (widthRatio / heightRatio));
                    drawX = (inWidth - newSize) / 2;
                    drawWidth = newSize;
                }
                matrix.preScale(scale, scale);
            } else if (options.centerInside) {
                widthRatio = (float)targetWidth / (float)inWidth;
                heightRatio = (float)targetHeight / (float)inHeight;
                float scale = widthRatio < heightRatio ? widthRatio : heightRatio;
                matrix.preScale(scale, scale);
            } else if (targetWidth != 0 && targetHeight != 0 && (targetWidth != inWidth || targetHeight != inHeight)) {
                float sx = (float)targetWidth / (float)inWidth;
                float sy = (float)targetHeight / (float)inHeight;
                matrix.preScale(sx, sy);
            }
            float targetScaleX = options.targetScaleX;
            float targetScaleY = options.targetScaleY;
            if (targetScaleX != 0.0f || targetScaleY != 0.0f) {
                matrix.setScale(targetScaleX, targetScaleY);
            }
        }
        if (exifRotation != 0) {
            matrix.preRotate((float)exifRotation);
        }
        Object object = DECODE_LOCK;
        synchronized (object) {
            Bitmap newResult = Bitmap.createBitmap((Bitmap)result, (int)drawX, (int)drawY, (int)drawWidth, (int)drawHeight, (Matrix)matrix, (boolean)false);
            if (newResult != result) {
                result.recycle();
                result = newResult;
            }
        }
        return result;
    }

    static Bitmap applyCustomTransformations(List<Transformation> transformations, Bitmap result) {
        int count = transformations.size();
        for (int i = 0; i < count; ++i) {
            Transformation transformation = transformations.get(i);
            Bitmap newResult = transformation.transform(result);
            if (newResult == null) {
                StringBuilder builder = new StringBuilder().append("Transformation ").append(transformation.key()).append(" returned null after ").append(i).append(" previous transformation(s).\n\nTransformation list:\n");
                for (Transformation t : transformations) {
                    builder.append(t.key()).append('\n');
                }
                throw new NullPointerException(builder.toString());
            }
            if (newResult == result && result.isRecycled()) {
                throw new IllegalStateException("Transformation " + transformation.key() + " returned input Bitmap but recycled it.");
            }
            if (newResult != result && !result.isRecycled()) {
                throw new IllegalStateException("Transformation " + transformation.key() + " mutated input Bitmap but failed to recycle the original.");
            }
            result = newResult;
        }
        return result;
    }

    public static Picasso with(Context context) {
        if (singleton == null) {
            singleton = new Builder(context).build();
        }
        return singleton;
    }

    public static class Builder {
        private final Context context;
        private Loader loader;
        private ExecutorService service;
        private Cache memoryCache;
        private Listener listener;

        public Builder(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("Context must not be null.");
            }
            this.context = context.getApplicationContext();
        }

        public Builder loader(Loader loader) {
            if (loader == null) {
                throw new IllegalArgumentException("Loader must not be null.");
            }
            if (this.loader != null) {
                throw new IllegalStateException("Loader already set.");
            }
            this.loader = loader;
            return this;
        }

        public Builder executor(ExecutorService executorService) {
            if (executorService == null) {
                throw new IllegalArgumentException("Executor service must not be null.");
            }
            if (this.service != null) {
                throw new IllegalStateException("Executor service already set.");
            }
            this.service = executorService;
            return this;
        }

        public Builder memoryCache(Cache memoryCache) {
            if (memoryCache == null) {
                throw new IllegalArgumentException("Memory cache must not be null.");
            }
            if (this.memoryCache != null) {
                throw new IllegalStateException("Memory cache already set.");
            }
            this.memoryCache = memoryCache;
            return this;
        }

        public Builder listener(Listener listener) {
            if (listener == null) {
                throw new IllegalArgumentException("Listener must not be null.");
            }
            if (this.listener != null) {
                throw new IllegalStateException("Listener already set.");
            }
            this.listener = listener;
            return this;
        }

        public Picasso build() {
            Context context = this.context;
            if (this.loader == null) {
                this.loader = Utils.createDefaultLoader(context);
            }
            if (this.memoryCache == null) {
                this.memoryCache = new LruCache(context);
            }
            if (this.service == null) {
                this.service = Executors.newFixedThreadPool(3, new Utils.PicassoThreadFactory());
            }
            Stats stats = new Stats(this.memoryCache);
            return new Picasso(context, this.loader, this.service, this.memoryCache, this.listener, stats);
        }
    }

    public static interface Listener {
        public void onImageLoadFailed(Picasso var1, Uri var2, Exception var3);
    }
}

