/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.picasso;

import android.content.Context;
import android.net.Uri;
import com.squareup.okhttp.HttpResponseCache;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.picasso.Loader;
import com.squareup.picasso.Utils;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URL;

public class OkHttpLoader
implements Loader {
    static final String RESPONSE_SOURCE = "X-Android-Response-Source";
    private final OkHttpClient client;

    public OkHttpLoader(Context context) {
        this(Utils.createDefaultCacheDir(context));
    }

    public OkHttpLoader(File cacheDir) {
        this(cacheDir, Utils.calculateDiskCacheSize(cacheDir));
    }

    public OkHttpLoader(Context context, int maxSize) {
        this(Utils.createDefaultCacheDir(context), maxSize);
    }

    public OkHttpLoader(File cacheDir, int maxSize) {
        this(new OkHttpClient());
        try {
            this.client.setResponseCache((ResponseCache)new HttpResponseCache(cacheDir, (long)maxSize));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OkHttpLoader(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public Loader.Response load(Uri uri, boolean localCacheOnly) throws IOException {
        HttpURLConnection connection = this.client.open(new URL(uri.toString()));
        connection.setUseCaches(true);
        if (localCacheOnly) {
            connection.setRequestProperty("Cache-Control", "only-if-cached");
        }
        boolean fromCache = Utils.parseResponseSourceHeader(connection.getHeaderField(RESPONSE_SOURCE));
        return new Loader.Response(connection.getInputStream(), fromCache);
    }
}

