/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import retrofit.Callback;
import retrofit.CallbackRunnable;
import retrofit.Platform;
import retrofit.Profiler;
import retrofit.RequestBuilder;
import retrofit.RequestHeaders;
import retrofit.ResponseWrapper;
import retrofit.RestMethodInfo;
import retrofit.RetrofitError;
import retrofit.Server;
import retrofit.Utils;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.converter.Converter;
import retrofit.mime.MimeUtil;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class RestAdapter {
    private static final int LOG_CHUNK_SIZE = 4000;
    static final String THREAD_PREFIX = "Retrofit-";
    static final String IDLE_THREAD_NAME = "Retrofit-Idle";
    private final Server server;
    private final Client.Provider clientProvider;
    private final Executor httpExecutor;
    private final Executor callbackExecutor;
    private final RequestHeaders requestHeaders;
    private final Converter converter;
    private final Profiler profiler;
    private final Log log;
    private volatile boolean debug;

    private RestAdapter(Server server, Client.Provider clientProvider, Executor httpExecutor, Executor callbackExecutor, RequestHeaders requestHeaders, Converter converter, Profiler profiler, Log log, boolean debug) {
        this.server = server;
        this.clientProvider = clientProvider;
        this.httpExecutor = httpExecutor;
        this.callbackExecutor = callbackExecutor;
        this.requestHeaders = requestHeaders;
        this.converter = converter;
        this.profiler = profiler;
        this.log = log;
        this.debug = debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public <T> T create(Class<T> service) {
        if (!service.isInterface()) {
            throw new IllegalArgumentException("Only interface endpoint definitions are supported.");
        }
        return (T)Proxy.newProxyInstance(service.getClassLoader(), new Class[]{service}, (InvocationHandler)new RestHandler());
    }

    private Request logAndReplaceRequest(Request request) throws IOException {
        this.log.log(String.format("---> HTTP %s %s", request.getMethod(), request.getUrl()));
        for (Header header : request.getHeaders()) {
            this.log.log(header.getName() + ": " + header.getValue());
        }
        TypedOutput body = request.getBody();
        int bodySize = 0;
        if (body != null) {
            if (!request.getHeaders().isEmpty()) {
                this.log.log("");
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            body.writeTo(baos);
            byte[] bodyBytes = baos.toByteArray();
            bodySize = bodyBytes.length;
            String bodyMime = body.mimeType();
            String bodyString = new String(bodyBytes, MimeUtil.parseCharset(bodyMime));
            int len = bodyString.length();
            for (int i = 0; i < len; i += 4000) {
                int end = Math.min(len, i + 4000);
                this.log.log(bodyString.substring(i, end));
            }
            body = new TypedByteArray(bodyMime, bodyBytes);
        }
        this.log.log(String.format("---> END HTTP (%s-byte body)", bodySize));
        return new Request(request.getMethod(), request.getUrl(), request.getHeaders(), body);
    }

    private Response logAndReplaceResponse(String url, Response response, long elapsedTime) throws IOException {
        this.log.log(String.format("<--- HTTP %s %s (%sms)", response.getStatus(), url, elapsedTime));
        for (Header header : response.getHeaders()) {
            this.log.log(header.getName() + ": " + header.getValue());
        }
        TypedInput body = response.getBody();
        int bodySize = 0;
        if (body != null) {
            if (!response.getHeaders().isEmpty()) {
                this.log.log("");
            }
            if (!(body instanceof TypedByteArray)) {
                response = Utils.readBodyToBytesIfNecessary(response);
                body = response.getBody();
            }
            byte[] bodyBytes = ((TypedByteArray)body).getBytes();
            bodySize = bodyBytes.length;
            String bodyMime = body.mimeType();
            String bodyCharset = MimeUtil.parseCharset(bodyMime);
            String bodyString = new String(bodyBytes, bodyCharset);
            int len = bodyString.length();
            for (int i = 0; i < len; i += 4000) {
                int end = Math.min(len, i + 4000);
                this.log.log(bodyString.substring(i, end));
            }
        }
        this.log.log(String.format("<--- END HTTP (%s-byte body)", bodySize));
        return response;
    }

    private static Profiler.RequestInformation getRequestInfo(String serverUrl, RestMethodInfo methodDetails, Request request) {
        long contentLength = 0L;
        String contentType = null;
        TypedOutput body = request.getBody();
        if (body != null) {
            contentLength = body.length();
            contentType = body.mimeType();
        }
        return new Profiler.RequestInformation(methodDetails.requestMethod, serverUrl, methodDetails.requestUrl, contentLength, contentType);
    }

    static /* synthetic */ Server access$400(RestAdapter x0) {
        return x0.server;
    }

    static /* synthetic */ RequestHeaders access$500(RestAdapter x0) {
        return x0.requestHeaders;
    }

    static /* synthetic */ Converter access$600(RestAdapter x0) {
        return x0.converter;
    }

    static /* synthetic */ boolean access$700(RestAdapter x0) {
        return x0.debug;
    }

    static /* synthetic */ Request access$800(RestAdapter x0, Request x1) throws IOException {
        return x0.logAndReplaceRequest(x1);
    }

    static /* synthetic */ Profiler access$900(RestAdapter x0) {
        return x0.profiler;
    }

    static /* synthetic */ Client.Provider access$1000(RestAdapter x0) {
        return x0.clientProvider;
    }

    static /* synthetic */ Profiler.RequestInformation access$1100(String x0, RestMethodInfo x1, Request x2) {
        return RestAdapter.getRequestInfo(x0, x1, x2);
    }

    static /* synthetic */ Response access$1200(RestAdapter x0, String x1, Response x2, long x3) throws IOException {
        return x0.logAndReplaceResponse(x1, x2, x3);
    }

    public static class Builder {
        private Server server;
        private Client.Provider clientProvider;
        private Executor httpExecutor;
        private Executor callbackExecutor;
        private RequestHeaders requestHeaders;
        private Converter converter;
        private Profiler profiler;
        private Log log;
        private boolean debug;

        public Builder setServer(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("endpoint");
            }
            return this.setServer(new Server(endpoint));
        }

        public Builder setServer(Server server) {
            if (server == null) {
                throw new NullPointerException("server");
            }
            this.server = server;
            return this;
        }

        public Builder setClient(final Client client) {
            if (client == null) {
                throw new NullPointerException("client");
            }
            return this.setClient(new Client.Provider(){

                @Override
                public Client get() {
                    return client;
                }
            });
        }

        public Builder setClient(Client.Provider clientProvider) {
            if (clientProvider == null) {
                throw new NullPointerException("clientProvider");
            }
            this.clientProvider = clientProvider;
            return this;
        }

        public Builder setExecutors(Executor httpExecutor, Executor callbackExecutor) {
            if (httpExecutor == null) {
                throw new NullPointerException("httpExecutor");
            }
            if (callbackExecutor == null) {
                callbackExecutor = new Utils.SynchronousExecutor();
            }
            this.httpExecutor = httpExecutor;
            this.callbackExecutor = callbackExecutor;
            return this;
        }

        public Builder setRequestHeaders(RequestHeaders requestHeaders) {
            if (requestHeaders == null) {
                throw new NullPointerException("requestHeaders");
            }
            this.requestHeaders = requestHeaders;
            return this;
        }

        public Builder setConverter(Converter converter) {
            if (converter == null) {
                throw new NullPointerException("converter");
            }
            this.converter = converter;
            return this;
        }

        public Builder setProfiler(Profiler profiler) {
            if (profiler == null) {
                throw new NullPointerException("profiler");
            }
            this.profiler = profiler;
            return this;
        }

        public Builder setLog(Log log) {
            if (log == null) {
                throw new NullPointerException("log");
            }
            this.log = log;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public RestAdapter build() {
            if (this.server == null) {
                throw new IllegalArgumentException("Server may not be null.");
            }
            this.ensureSaneDefaults();
            return new RestAdapter(this.server, this.clientProvider, this.httpExecutor, this.callbackExecutor, this.requestHeaders, this.converter, this.profiler, this.log, this.debug);
        }

        private void ensureSaneDefaults() {
            if (this.converter == null) {
                this.converter = Platform.get().defaultConverter();
            }
            if (this.clientProvider == null) {
                this.clientProvider = Platform.get().defaultClient();
            }
            if (this.httpExecutor == null) {
                this.httpExecutor = Platform.get().defaultHttpExecutor();
            }
            if (this.callbackExecutor == null) {
                this.callbackExecutor = Platform.get().defaultCallbackExecutor();
            }
            if (this.log == null) {
                this.log = Platform.get().defaultLog();
            }
            if (this.requestHeaders == null) {
                this.requestHeaders = RequestHeaders.NONE;
            }
        }
    }

    private class RestHandler
    implements InvocationHandler {
        private final Map<Method, RestMethodInfo> methodDetailsCache = new LinkedHashMap<Method, RestMethodInfo>();

        private RestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws InvocationTargetException, IllegalAccessException {
            RestMethodInfo methodDetails;
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            Map<Method, RestMethodInfo> map = this.methodDetailsCache;
            synchronized (map) {
                RestMethodInfo tempMethodDetails = this.methodDetailsCache.get(method);
                if (tempMethodDetails == null) {
                    tempMethodDetails = new RestMethodInfo(method);
                    this.methodDetailsCache.put(method, tempMethodDetails);
                }
                methodDetails = tempMethodDetails;
            }
            if (methodDetails.isSynchronous) {
                return this.invokeRequest(methodDetails, args);
            }
            if (RestAdapter.this.httpExecutor == null || RestAdapter.this.callbackExecutor == null) {
                throw new IllegalStateException("Asynchronous invocation requires calling setExecutors.");
            }
            Callback callback = (Callback)args[args.length - 1];
            RestAdapter.this.httpExecutor.execute(new CallbackRunnable(callback, RestAdapter.this.callbackExecutor){

                @Override
                public ResponseWrapper obtainResponse() {
                    return (ResponseWrapper)RestHandler.this.invokeRequest(methodDetails, args);
                }
            });
            return null;
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Object invokeRequest(RestMethodInfo methodDetails, Object[] args) {
            methodDetails.init();
            url = serverUrl = RestAdapter.access$400(RestAdapter.this).getUrl();
            request = new RequestBuilder(RestAdapter.access$600(RestAdapter.this)).apiUrl(serverUrl).args(args).headers(RestAdapter.access$500(RestAdapter.this).get()).methodInfo(methodDetails).build();
            url = request.getUrl();
            if (!methodDetails.isSynchronous) {
                Thread.currentThread().setName("Retrofit-" + url.substring(serverUrl.length()));
            }
            if (RestAdapter.access$700(RestAdapter.this)) {
                request = RestAdapter.access$800(RestAdapter.this, request);
            }
            profilerObject = null;
            if (RestAdapter.access$900(RestAdapter.this) != null) {
                profilerObject = RestAdapter.access$900(RestAdapter.this).beforeCall();
            }
            start = System.nanoTime();
            response = RestAdapter.access$1000(RestAdapter.this).get().execute(request);
            elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            statusCode = response.getStatus();
            if (RestAdapter.access$900(RestAdapter.this) != null) {
                requestInfo = RestAdapter.access$1100(serverUrl, methodDetails, request);
                RestAdapter.access$900(RestAdapter.this).afterCall(requestInfo, elapsedTime, statusCode, profilerObject);
            }
            if (RestAdapter.access$700(RestAdapter.this)) {
                response = RestAdapter.access$1200(RestAdapter.this, url, response, elapsedTime);
            }
            type = methodDetails.responseObjectType;
            if (statusCode < 200 || statusCode >= 300) ** GOTO lbl-1000
            if (type.equals(Response.class)) {
                response = Utils.readBodyToBytesIfNecessary(response);
                if (methodDetails.isSynchronous) {
                    var14_15 = response;
                    return var14_15;
                }
                var14_16 = new ResponseWrapper(response, response);
                return var14_16;
            }
            body = response.getBody();
            if (body == null) {
                var15_18 = new ResponseWrapper(response, null);
                return var15_18;
            }
            convert = RestAdapter.access$600(RestAdapter.this).fromBody(body, type);
            if (methodDetails.isSynchronous) {
                var16_21 = convert;
                return var16_21;
            }
            var16_22 = new ResponseWrapper(response, convert);
            return var16_22;
lbl-1000:
            // 1 sources

            {
                response = Utils.readBodyToBytesIfNecessary(response);
                throw RetrofitError.httpError(url, response, RestAdapter.access$600(RestAdapter.this), type);
            }
            {
                catch (RetrofitError e) {
                    throw e;
                }
                catch (IOException e) {
                    throw RetrofitError.networkError(url, e);
                }
                catch (Throwable t) {
                    throw RetrofitError.unexpectedError(url, t);
                }
            }
            finally {
                if (!methodDetails.isSynchronous) {
                    Thread.currentThread().setName("Retrofit-Idle");
                }
            }
        }
    }

    public static interface Log {
        public void log(String var1);
    }
}

