/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import retrofit.RestMethodInfo;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.converter.Converter;
import retrofit.mime.FormUrlEncodedTypedOutput;
import retrofit.mime.MultipartTypedOutput;
import retrofit.mime.TypedOutput;

final class RequestBuilder {
    private final Converter converter;
    private RestMethodInfo methodInfo;
    private Object[] args;
    private String apiUrl;
    private List<Header> headers;

    RequestBuilder(Converter converter) {
        this.converter = converter;
    }

    RequestBuilder methodInfo(RestMethodInfo methodDetails) {
        this.methodInfo = methodDetails;
        return this;
    }

    RequestBuilder apiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    RequestBuilder args(Object[] args) {
        this.args = args;
        return this;
    }

    RequestBuilder headers(List<Header> headers) {
        this.headers = headers;
        return this;
    }

    Request build() throws UnsupportedEncodingException {
        String[] requestParamHeader;
        List<Header> methodHeaders;
        Object arg;
        int i;
        String apiUrl = this.apiUrl;
        StringBuilder url = new StringBuilder(apiUrl);
        if (apiUrl.endsWith("/")) {
            url.deleteCharAt(url.length() - 1);
        }
        url.append(this.buildRelativeUrl());
        if (this.methodInfo.hasQueryParams) {
            boolean first = true;
            String requestQuery = this.methodInfo.requestQuery;
            if (requestQuery != null) {
                url.append('?').append(requestQuery);
                first = false;
            }
            String[] requestQueryName = this.methodInfo.requestQueryName;
            for (i = 0; i < requestQueryName.length; ++i) {
                String query = requestQueryName[i];
                if (query == null || (arg = this.args[i]) == null) continue;
                String value = URLEncoder.encode(String.valueOf(arg), "UTF-8");
                url.append(first ? (char)'?' : '&').append(query).append('=').append(value);
                first = false;
            }
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        if (this.headers != null) {
            headers.addAll(this.headers);
        }
        if ((methodHeaders = this.methodInfo.headers) != null) {
            headers.addAll(methodHeaders);
        }
        if ((requestParamHeader = this.methodInfo.requestParamHeader) != null) {
            for (i = 0; i < requestParamHeader.length; ++i) {
                String name = requestParamHeader[i];
                if (name == null || (arg = this.args[i]) == null) continue;
                headers.add(new Header(name, String.valueOf(arg)));
            }
        }
        return new Request(this.methodInfo.requestMethod, url.toString(), headers, this.buildBody());
    }

    private String buildRelativeUrl() throws UnsupportedEncodingException {
        String replacedPath = this.methodInfo.requestUrl;
        String[] requestUrlParam = this.methodInfo.requestUrlParam;
        for (int i = 0; i < requestUrlParam.length; ++i) {
            String param = requestUrlParam[i];
            if (param == null) continue;
            Object arg = this.args[i];
            if (arg == null) {
                throw new IllegalArgumentException("Path parameters must not be null: " + param + ".");
            }
            String value = URLEncoder.encode(String.valueOf(arg), "UTF-8");
            replacedPath = replacedPath.replace("{" + param + "}", value);
        }
        return replacedPath;
    }

    private TypedOutput buildBody() {
        switch (this.methodInfo.requestType) {
            case SIMPLE: {
                int bodyIndex = this.methodInfo.bodyIndex;
                if (bodyIndex == -1) {
                    return null;
                }
                Object body = this.args[bodyIndex];
                if (body == null) {
                    throw new IllegalArgumentException("Body must not be null.");
                }
                if (body instanceof TypedOutput) {
                    return (TypedOutput)body;
                }
                return this.converter.toBody(body);
            }
            case FORM_URL_ENCODED: {
                FormUrlEncodedTypedOutput body = new FormUrlEncodedTypedOutput();
                String[] requestFormFields = this.methodInfo.requestFormFields;
                for (int i = 0; i < requestFormFields.length; ++i) {
                    Object value;
                    String name = requestFormFields[i];
                    if (name == null || (value = this.args[i]) == null) continue;
                    body.addField(name, String.valueOf(value));
                }
                return body;
            }
            case MULTIPART: {
                MultipartTypedOutput body = new MultipartTypedOutput();
                String[] requestMultipartPart = this.methodInfo.requestMultipartPart;
                for (int i = 0; i < requestMultipartPart.length; ++i) {
                    String name = requestMultipartPart[i];
                    if (name == null) continue;
                    Object value = this.args[i];
                    if (value == null) {
                        throw new IllegalArgumentException("Multipart part must not be null: " + name + ".");
                    }
                    if (value instanceof TypedOutput) {
                        body.addPart(name, (TypedOutput)value);
                        continue;
                    }
                    body.addPart(name, this.converter.toBody(value));
                }
                return body;
            }
        }
        throw new IllegalArgumentException("Unknown request type " + (Object)((Object)this.methodInfo.requestType));
    }
}

