/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.api;

import android.webkit.WebView;
import com.phonegap.api.IPlugin;
import com.phonegap.api.PhonegapActivity;
import com.phonegap.api.Plugin;
import com.phonegap.api.PluginResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public final class PluginManager {
    private HashMap<String, Plugin> plugins = new HashMap();
    private HashMap<String, String> services = new HashMap();
    private final PhonegapActivity ctx;
    private final WebView app;

    public PluginManager(WebView app, PhonegapActivity ctx) {
        this.ctx = ctx;
        this.app = app;
    }

    public String exec(String service, final String action, final String callbackId, String jsonArgs, boolean async) {
        PluginResult cr = null;
        boolean runAsync = async;
        try {
            final JSONArray args = new JSONArray(jsonArgs);
            String clazz = this.services.get(service);
            Class c = null;
            if (clazz != null) {
                c = this.getClassByName(clazz);
            }
            if (this.isPhoneGapPlugin(c)) {
                final Plugin plugin = this.addPlugin(clazz, c);
                final PhonegapActivity ctx = this.ctx;
                boolean bl = runAsync = async && !plugin.isSynch(action);
                if (runAsync) {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                PluginResult cr = plugin.execute(action, args, callbackId);
                                int status = cr.getStatus();
                                if (status != PluginResult.Status.NO_RESULT.ordinal() || !cr.getKeepCallback()) {
                                    if (status == PluginResult.Status.OK.ordinal() || status == PluginResult.Status.NO_RESULT.ordinal()) {
                                        ctx.sendJavascript(cr.toSuccessCallbackString(callbackId));
                                    } else {
                                        ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
                                    }
                                }
                            }
                            catch (Exception e) {
                                PluginResult cr = new PluginResult(PluginResult.Status.ERROR);
                                ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
                            }
                        }
                    });
                    thread.start();
                    return "";
                }
                cr = plugin.execute(action, args, callbackId);
                if (cr.getStatus() == PluginResult.Status.NO_RESULT.ordinal() && cr.getKeepCallback()) {
                    return "";
                }
            }
        }
        catch (ClassNotFoundException e) {
            cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
        }
        catch (JSONException e) {
            System.out.println("ERROR: " + e.toString());
            cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
        }
        if (runAsync) {
            if (cr == null) {
                cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            }
            this.ctx.sendJavascript(cr.toErrorCallbackString(callbackId));
        }
        return cr != null ? cr.getJSONString() : "{ status: 0, message: 'all good' }";
    }

    private Class getClassByName(String clazz) throws ClassNotFoundException {
        return Class.forName(clazz);
    }

    private boolean isPhoneGapPlugin(Class c) {
        if (c != null) {
            return Plugin.class.isAssignableFrom(c) || IPlugin.class.isAssignableFrom(c);
        }
        return false;
    }

    public Plugin addPlugin(String className) {
        try {
            return this.addPlugin(className, this.getClassByName(className));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + className + ".");
            return null;
        }
    }

    private Plugin addPlugin(String className, Class clazz) {
        if (this.plugins.containsKey(className)) {
            return this.getPlugin(className);
        }
        try {
            Plugin plugin = (Plugin)clazz.newInstance();
            this.plugins.put(className, plugin);
            plugin.setContext(this.ctx);
            plugin.setView(this.app);
            return plugin;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + className + ".");
            return null;
        }
    }

    private Plugin getPlugin(String className) {
        Plugin plugin = this.plugins.get(className);
        return plugin;
    }

    public void addService(String serviceType, String className) {
        this.services.put(serviceType, className);
    }

    public void onPause() {
        Set<Map.Entry<String, Plugin>> s = this.plugins.entrySet();
        for (Map.Entry<String, Plugin> entry : s) {
            Plugin plugin = entry.getValue();
            plugin.onPause();
        }
    }

    public void onResume() {
        Set<Map.Entry<String, Plugin>> s = this.plugins.entrySet();
        for (Map.Entry<String, Plugin> entry : s) {
            Plugin plugin = entry.getValue();
            plugin.onResume();
        }
    }

    public void onDestroy() {
        Set<Map.Entry<String, Plugin>> s = this.plugins.entrySet();
        for (Map.Entry<String, Plugin> entry : s) {
            Plugin plugin = entry.getValue();
            plugin.onDestroy();
        }
    }
}

