/*
 * Decompiled with CFR 0.152.
 */
package retrofit.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.Request;
import retrofit.client.Response;
import retrofit.mime.TypedInput;
import retrofit.mime.TypedOutput;

public class UrlConnectionClient
implements Client {
    @Override
    public Response execute(Request request) throws IOException {
        HttpURLConnection connection = this.openConnection(request);
        this.prepareRequest(connection, request);
        return this.readResponse(connection);
    }

    protected HttpURLConnection openConnection(Request request) throws IOException {
        return (HttpURLConnection)new URL(request.getUrl()).openConnection();
    }

    void prepareRequest(HttpURLConnection connection, Request request) throws IOException {
        connection.setRequestMethod(request.getMethod());
        connection.setDoInput(true);
        for (Header header : request.getHeaders()) {
            connection.addRequestProperty(header.getName(), header.getValue());
        }
        TypedOutput body = request.getBody();
        if (body != null) {
            connection.setDoOutput(true);
            connection.addRequestProperty("Content-Type", body.mimeType());
            long length = body.length();
            if (length != -1L) {
                connection.addRequestProperty("Content-Length", String.valueOf(length));
            }
            body.writeTo(connection.getOutputStream());
        }
    }

    Response readResponse(HttpURLConnection connection) throws IOException {
        int status = connection.getResponseCode();
        String reason = connection.getResponseMessage();
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Map.Entry<String, List<String>> field : connection.getHeaderFields().entrySet()) {
            String name = field.getKey();
            for (String value : field.getValue()) {
                headers.add(new Header(name, value));
            }
        }
        String mimeType = connection.getContentType();
        int length = connection.getContentLength();
        InputStream stream = status >= 400 ? connection.getErrorStream() : connection.getInputStream();
        TypedInputStream responseBody = new TypedInputStream(mimeType, length, stream);
        return new Response(status, reason, headers, responseBody);
    }

    private static class TypedInputStream
    implements TypedInput {
        private final String mimeType;
        private final long length;
        private final InputStream stream;

        private TypedInputStream(String mimeType, long length, InputStream stream) {
            this.mimeType = mimeType;
            this.length = length;
            this.stream = stream;
        }

        @Override
        public String mimeType() {
            return this.mimeType;
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public InputStream in() throws IOException {
            return this.stream;
        }
    }
}

