/*
 * Decompiled with CFR 0.152.
 */
package retrofit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedInput;

final class Utils {
    private static final int BUFFER_SIZE = 4096;

    static byte[] streamToBytes(InputStream stream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (stream != null) {
            int r;
            byte[] buf = new byte[4096];
            while ((r = stream.read(buf)) != -1) {
                baos.write(buf, 0, r);
            }
        }
        return baos.toByteArray();
    }

    static Response readBodyToBytesIfNecessary(Response response) throws IOException {
        TypedInput body = response.getBody();
        if (body == null || body instanceof TypedByteArray) {
            return response;
        }
        String bodyMime = body.mimeType();
        byte[] bodyBytes = Utils.streamToBytes(body.in());
        body = new TypedByteArray(bodyMime, bodyBytes);
        return Utils.replaceResponseBody(response, body);
    }

    static Response replaceResponseBody(Response response, TypedInput body) {
        return new Response(response.getStatus(), response.getReason(), response.getHeaders(), body);
    }

    private Utils() {
    }

    static class SynchronousExecutor
    implements Executor {
        SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }
    }
}

